/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.harvester.RecordInfo;
import org.fao.geonet.repository.specification.MetadataSpecs;

public class UriMapper {
    private HashMap<String, List<RecordInfo>> hmUriRecords = new HashMap();

    public UriMapper(ServiceContext context, String harvestUuid) {
        IMetadataUtils metadataRepository = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        List metadataList = metadataRepository.findAll(MetadataSpecs.hasHarvesterUuid((String)harvestUuid));
        for (AbstractMetadata metadataRecord : metadataList) {
            String uri = Optional.ofNullable(metadataRecord.getHarvestInfo().getUri()).orElse("");
            ArrayList<RecordInfo> records = this.hmUriRecords.computeIfAbsent(uri, k -> new ArrayList());
            if (records == null) {
                records = new ArrayList<RecordInfo>();
                this.hmUriRecords.put(uri, records);
            }
            records.add(new RecordInfo(metadataRecord));
        }
    }

    public List<RecordInfo> getRecords(String uri) {
        return this.hmUriRecords.get(uri);
    }

    public Iterable<String> getUris() {
        return this.hmUriRecords.keySet();
    }
}

