/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.events.hooks.user;

import org.fao.geonet.domain.User;
import org.fao.geonet.entitylistener.GeonetworkEntityListener;
import org.fao.geonet.entitylistener.PersistentEventType;
import org.fao.geonet.events.user.UserCreated;
import org.fao.geonet.events.user.UserDeleted;
import org.fao.geonet.events.user.UserUpdated;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Component;

@Component
public class UserModified
implements GeonetworkEntityListener<User>,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher eventPublisher;

    public Class<User> getEntityClass() {
        return User.class;
    }

    public void handleEvent(PersistentEventType type, User entity) {
        if (type == PersistentEventType.PrePersist) {
            this.eventPublisher.publishEvent((ApplicationEvent)new UserCreated(entity));
        } else if (type == PersistentEventType.PreUpdate) {
            this.eventPublisher.publishEvent((ApplicationEvent)new UserUpdated(entity));
        } else if (type == PersistentEventType.PreRemove) {
            this.eventPublisher.publishEvent((ApplicationEvent)new UserDeleted(entity));
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }
}

