/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.server;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.a2j.codec.util.OIDRegisterEntry;
import org.jzkit.a2j.gen.AsnUseful.EXTERNAL_type;
import org.jzkit.a2j.gen.AsnUseful.encoding_inline0_type;
import org.jzkit.search.util.RecordModel.ArchetypeRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.jzkit.z3950.gen.v3.NegotiationRecordDefinition_charSetandLanguageNegotiation_3.CharSetandLanguageNegotiation_type;
import org.jzkit.z3950.gen.v3.NegotiationRecordDefinition_charSetandLanguageNegotiation_3.Iso10646_type;
import org.jzkit.z3950.gen.v3.NegotiationRecordDefinition_charSetandLanguageNegotiation_3.OriginProposal_type;
import org.jzkit.z3950.gen.v3.NegotiationRecordDefinition_charSetandLanguageNegotiation_3.proposedCharSets_inline0_choice1_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DefaultDiagFormat_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DeleteResultSetRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DeleteResultSetResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DiagRec_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ElementSetNames_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.InitializeRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.NamePlusRecord_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.OtherInformationItem43_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PDU_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PresentRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PresentResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Records_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.ScanRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SearchRequest_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.SearchResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.addinfo_inline14_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.information_inline44_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.record_inline13_type;
import org.jzkit.z3950.server.BackendDeleteDTO;
import org.jzkit.z3950.server.BackendPresentDTO;
import org.jzkit.z3950.server.BackendSearchDTO;
import org.jzkit.z3950.server.BackendStatusReportDTO;
import org.jzkit.z3950.server.Z3950Main;
import org.jzkit.z3950.server.Z3950NonBlockingBackend;
import org.jzkit.z3950.util.APDUEvent;
import org.jzkit.z3950.util.GenericEventToTargetListenerAdapter;
import org.jzkit.z3950.util.TargetAPDUListener;
import org.jzkit.z3950.util.Z3950Constants;
import org.jzkit.z3950.util.ZTargetEndpoint;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;

public class ZServerAssociation
implements TargetAPDUListener {
    public static Log log = LogFactory.getLog(ZServerAssociation.class);
    public static Log event_log = LogFactory.getLog(Z3950Main.class);
    private ZTargetEndpoint assoc = null;
    private OIDRegister reg = null;
    private int dbg_counter = 0;
    private GenericEventToTargetListenerAdapter event_adapter = null;
    private Z3950NonBlockingBackend backend;
    private ApplicationContext ctx = null;
    private boolean add_extra_status_info = true;
    private SocketAddress client_address = null;

    public ZServerAssociation(Socket s, Z3950NonBlockingBackend backend, ApplicationContext ctx) {
        event_log.info((Object)("New ZServerAssociation " + this.dbg_counter++));
        this.backend = backend;
        this.reg = (OIDRegister)ctx.getBean("OIDRegister");
        this.assoc = new ZTargetEndpoint(s, this.reg);
        this.event_adapter = new GenericEventToTargetListenerAdapter(this);
        this.assoc.getPDUAnnouncer().addObserver(this.event_adapter);
        this.client_address = s.getRemoteSocketAddress();
        if (this.reg == null) {
            throw new RuntimeException("Unable to locate OID Register in Application Context");
        }
        this.assoc.start();
        log.debug((Object)"New thread should have started");
    }

    protected void finalize() throws Throwable {
        --this.dbg_counter;
        event_log.info((Object)("ZServerAssociation::finalize() - " + this.dbg_counter + " remaining"));
    }

    public void incomingInitRequest(APDUEvent e) {
        log.debug((Object)"Incoming initRequest....");
        InitializeRequest_type init_request = (InitializeRequest_type)e.getPDU().o;
        for (int i = 0; i < Z3950Constants.z3950_option_names.length; ++i) {
            if (!init_request.options.isSet(i)) continue;
            log.info((Object)("Origin requested service: " + Z3950Constants.z3950_option_names[i]));
        }
        if (init_request.options.isSet(7)) {
            // empty if block
        }
        if (init_request.userInformationField != null) {
            OIDRegisterEntry ent = this.reg.lookupByOID(init_request.userInformationField.direct_reference);
            if (ent != null) {
                log.debug((Object)("Init Request contains userInformationField oid=" + ent.getName()));
            } else {
                log.debug((Object)"Unkown external in userInformationField");
            }
        }
        if (init_request.otherInfo != null) {
            log.debug((Object)"Init Request contains otherInfo entries");
            Iterator other_info_enum = init_request.otherInfo.iterator();
            block6: while (other_info_enum.hasNext()) {
                log.debug((Object)"Processing otherInfo entry...");
                OtherInformationItem43_type oit = (OtherInformationItem43_type)other_info_enum.next();
                log.debug((Object)"Processing OtherInformationItem43_type");
                switch (oit.information.which) {
                    case 2: {
                        EXTERNAL_type et = (EXTERNAL_type)oit.information.o;
                        if (et.direct_reference == null) continue block6;
                        OIDRegisterEntry ent = this.reg.lookupByOID(et.direct_reference);
                        log.debug((Object)("External with direct reference, oid=" + ent.getName()));
                        if (!ent.getName().equals("z_charset_neg_3")) continue block6;
                        this.handleNLSNegotiation((CharSetandLanguageNegotiation_type)et.encoding.o);
                        break;
                    }
                    default: {
                        log.debug((Object)"Currently unhandled OtherInformationType");
                    }
                }
            }
        }
        try {
            log.debug((Object)"sendInitResponse");
            event_log.info((Object)("New_Z3950_Session:" + this.client_address));
            this.assoc.sendInitResponse(init_request.referenceId, init_request.protocolVersion, init_request.options, init_request.preferredMessageSize.longValue(), init_request.exceptionalRecordSize.longValue(), true, "174", "GeoNetwork JZKit generic server / " + this.backend.getImplName(), this.backend.getVersion(), null, null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void handleNLSNegotiation(CharSetandLanguageNegotiation_type neg) {
        log.debug((Object)"Handle Character Set and Language Negotiation");
        if (neg.which == 0) {
            OriginProposal_type op = (OriginProposal_type)neg.o;
            if (op.proposedCharSets != null) {
                block3: for (proposedCharSets_inline0_choice1_type c : op.proposedCharSets) {
                    switch (c.which) {
                        case 1: {
                            Iso10646_type iso_type = (Iso10646_type)c.o;
                            OIDRegisterEntry ent = this.reg.lookupByOID(iso_type.encodingLevel);
                            log.debug((Object)("Client proposes iso10646 charset: " + ent.getName()));
                            continue block3;
                        }
                    }
                    log.error((Object)"Unhandled character set encoding");
                }
            }
        }
    }

    public void incomingSearchRequest(APDUEvent e) {
        log.debug((Object)"Processing incomingSearchRequest");
        SearchRequest_type search_request = (SearchRequest_type)e.getPDU().o;
        int ssub = search_request.smallSetUpperBound.intValue();
        int lslb = search_request.largeSetLowerBound.intValue();
        int mspn = search_request.mediumSetPresentNumber.intValue();
        String pref_recsyn = null;
        if (search_request.preferredRecordSyntax != null) {
            OIDRegisterEntry ent = this.reg.lookupByOID(search_request.preferredRecordSyntax);
            pref_recsyn = ent != null ? ent.getName() : null;
        }
        this.backend.search(new BackendSearchDTO(this, search_request.query, search_request.databaseNames, pref_recsyn, this.extractSetname(search_request.smallSetElementSetNames), this.extractSetname(search_request.mediumSetElementSetNames), search_request.resultSetName != null ? search_request.resultSetName : "Default", search_request.replaceIndicator, search_request.referenceId));
    }

    public void notifySearchResult(BackendSearchDTO bsr) {
        log.debug((Object)"notifySearchResult");
        PDU_type pdu = new PDU_type();
        pdu.which = 3;
        SearchResponse_type response = new SearchResponse_type();
        pdu.o = response;
        response.searchStatus = bsr.search_status;
        response.resultCount = BigInteger.valueOf(bsr.result_count);
        if (bsr.refid != null) {
            response.referenceId = bsr.refid;
        }
        if (bsr.search_status) {
            if (bsr.piggyback_records != null) {
                response.presentStatus = BigInteger.valueOf(0L);
                response.numberOfRecordsReturned = BigInteger.valueOf(bsr.piggyback_records.length);
                response.nextResultSetPosition = BigInteger.valueOf(bsr.piggyback_records.length + 1);
            } else {
                response.presentStatus = BigInteger.valueOf(0L);
                response.numberOfRecordsReturned = BigInteger.valueOf(0L);
                response.nextResultSetPosition = BigInteger.valueOf(1L);
            }
        } else {
            response.presentStatus = BigInteger.valueOf(5L);
            response.numberOfRecordsReturned = BigInteger.valueOf(0L);
            response.nextResultSetPosition = BigInteger.valueOf(0L);
            response.resultSetStatus = BigInteger.valueOf(3L);
            if (bsr.diagnostic_code == 0L) {
                String addinfo = null;
                if (bsr.status_report != null) {
                    addinfo = bsr.status_report.toString();
                }
                response.records = this.createNSD("2", addinfo, bsr.diagnostic_data);
            } else {
                response.records = this.createNSD("" + bsr.diagnostic_code, bsr.diagnostic_addinfo, bsr.diagnostic_data);
            }
        }
        log.debug((Object)"Send search response : ");
        try {
            event_log.info((Object)"SearchComplete");
            this.assoc.encodeAndSend(pdu);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private String extractSetname(ElementSetNames_type esn_type) {
        String result = esn_type != null && esn_type.which == 0 ? esn_type.o.toString() : "f";
        return result;
    }

    public void incomingPresentRequest(APDUEvent e) {
        log.debug((Object)"Incoming presentRequest");
        PresentRequest_type present_request = (PresentRequest_type)e.getPDU().o;
        int start = present_request.resultSetStartPoint.intValue();
        int count = present_request.numberOfRecordsRequested.intValue();
        String element_set_name = null;
        String result_set_name = present_request.resultSetId;
        String record_syntax = null;
        String schema = null;
        OIDRegisterEntry ent = this.reg.lookupByOID(present_request.preferredRecordSyntax);
        if (ent != null) {
            record_syntax = ent.getName();
        }
        element_set_name = present_request.recordComposition != null && present_request.recordComposition.which == 0 ? this.extractSetname((ElementSetNames_type)present_request.recordComposition.o) : "f";
        ArchetypeRecordFormatSpecification archetype = new ArchetypeRecordFormatSpecification(element_set_name);
        ExplicitRecordFormatSpecification explicit = new ExplicitRecordFormatSpecification(record_syntax, schema, element_set_name);
        this.backend.present(new BackendPresentDTO(this, result_set_name != null ? result_set_name : "Default", start, count, record_syntax, element_set_name, present_request.recordComposition, present_request.referenceId, archetype, explicit));
    }

    public void notifyPresentResult(BackendPresentDTO bpr) {
        log.debug((Object)("notifyPresentResult start=" + bpr.start + ", count=" + bpr.count + ", syntax=" + bpr.record_syntax));
        PDU_type pdu = new PDU_type();
        pdu.which = 5;
        PresentResponse_type response = new PresentResponse_type();
        pdu.o = response;
        response.referenceId = bpr.refid;
        response.otherInfo = null;
        if (bpr.start <= 0) {
            log.debug((Object)"Present out of range");
            response.presentStatus = BigInteger.valueOf(5L);
            response.numberOfRecordsReturned = BigInteger.valueOf(0L);
            response.nextResultSetPosition = BigInteger.valueOf(bpr.next_result_set_position);
            response.records = this.createNonSurrogateDiagnostic(1, "Unknown internal error presenting result records");
        } else if (bpr.start > bpr.total_hits) {
            log.debug((Object)"Present out of range");
            response.presentStatus = BigInteger.valueOf(5L);
            response.numberOfRecordsReturned = BigInteger.valueOf(0L);
            response.nextResultSetPosition = BigInteger.valueOf(bpr.next_result_set_position);
            response.records = this.createNonSurrogateDiagnostic(13, "Requested start record " + bpr.start + ", only 1 to " + bpr.total_hits + " available");
        } else {
            response.records = this.createRecordsFor(bpr.result_records, bpr.record_syntax);
            response.nextResultSetPosition = BigInteger.valueOf(bpr.next_result_set_position);
            if (response.records != null && response.records.which == 0) {
                log.debug((Object)("Got some records to present " + ((List)response.records.o).size()));
                response.numberOfRecordsReturned = BigInteger.valueOf(((List)response.records.o).size());
                response.presentStatus = BigInteger.valueOf(0L);
            } else {
                log.debug((Object)"response.records.which did not contain response records.. Non surrogate diagnostic returned");
                response.numberOfRecordsReturned = BigInteger.valueOf(0L);
                response.presentStatus = BigInteger.valueOf(5L);
            }
        }
        try {
            log.debug((Object)"Sending present response");
            this.assoc.encodeAndSend(pdu);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void incomingDeleteResultSetRequest(APDUEvent e) {
        log.debug((Object)"Incoming deleteResultSetRequest");
        DeleteResultSetRequest_type delete_request = (DeleteResultSetRequest_type)e.getPDU().o;
        PDU_type pdu = new PDU_type();
        pdu.which = 7;
        DeleteResultSetResponse_type response = new DeleteResultSetResponse_type();
        pdu.o = response;
        response.referenceId = delete_request.referenceId;
        if (delete_request.deleteFunction.intValue() == 0) {
            for (String next_rs : delete_request.resultSetList) {
            }
        }
        response.deleteOperationStatus = BigInteger.valueOf(0L);
        try {
            this.assoc.encodeAndSend(pdu);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void notifyDeleteResult(BackendDeleteDTO bdr) {
        log.debug((Object)bdr);
    }

    public void incomingAccessControlRequest(APDUEvent e) {
        log.info((Object)"Incoming accessControlRequest");
    }

    public void incomingAccessControlResponse(APDUEvent e) {
        log.info((Object)"Incoming AccessControlResponse");
    }

    public void incomingResourceControlRequest(APDUEvent e) {
        log.info((Object)"Incoming resourceControlRequest");
    }

    public void incomingTriggerResourceControlRequest(APDUEvent e) {
        log.info((Object)"Incoming triggetResourceControlRequest");
    }

    public void incomingResourceReportRequest(APDUEvent e) {
        log.info((Object)"Incoming resourceReportRequest");
    }

    public void incomingScanRequest(APDUEvent e) {
        ScanRequest_type scan_request = (ScanRequest_type)e.getPDU().o;
        boolean step_size = false;
        boolean scan_status = false;
        boolean number_of_entries_returned = false;
        boolean position_of_term = false;
    }

    public void incomingSortRequest(APDUEvent e) {
        log.info((Object)"Incoming sortRequest");
    }

    public void incomingSegmentRequest(APDUEvent e) {
        log.info((Object)"Incoming segmentRequest");
    }

    public void incomingExtendedServicesRequest(APDUEvent e) {
        log.info((Object)"Incoming extendedServicesRequest");
    }

    public void incomingClose(APDUEvent e) {
        log.debug((Object)"Close...");
        this.assoc.getPDUAnnouncer().deleteObserver(this.event_adapter);
        this.assoc.getPDUAnnouncer().deleteObservers();
        this.event_adapter = null;
        this.assoc.shutdown();
        try {
            this.assoc.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.debug((Object)"Done joining with assoc thread");
        log.debug((Object)"Deleting tasks...");
        this.assoc = null;
    }

    private Records_type createNonSurrogateDiagnostic(int condition, String addinfo) {
        Records_type retval = new Records_type();
        retval.which = 1;
        DefaultDiagFormat_type default_diag = new DefaultDiagFormat_type();
        retval.o = default_diag;
        default_diag.diagnosticSetId = this.reg.oidByName("diag-bib-1");
        default_diag.condition = BigInteger.valueOf(condition);
        if (addinfo != null) {
            default_diag.addinfo = new addinfo_inline14_type();
            default_diag.addinfo.which = 0;
            default_diag.addinfo.o = addinfo;
        }
        return retval;
    }

    private Records_type createRecordsFor(InformationFragment[] raw_records, String spec) {
        Records_type retval;
        block7: {
            log.debug((Object)("createRecordsFor... spec=" + spec));
            Object rb = null;
            retval = new Records_type();
            try {
                if (rb != null) {
                    log.error((Object)"createRecordsFor called with unhandled record syntax");
                    retval.which = 1;
                    DefaultDiagFormat_type default_diag = new DefaultDiagFormat_type();
                    retval.o = default_diag;
                    default_diag.diagnosticSetId = this.reg.oidByName("diag-bib-1");
                    default_diag.condition = BigInteger.valueOf(0L);
                    default_diag.addinfo = new addinfo_inline14_type();
                    default_diag.addinfo.which = 0;
                    default_diag.addinfo.o = "createRecordsFor called with unhandled record syntax";
                    break block7;
                }
                if (raw_records != null) {
                    ArrayList<NamePlusRecord_type> v = new ArrayList<NamePlusRecord_type>();
                    retval.which = 0;
                    retval.o = v;
                    for (int i = 0; i < raw_records.length; ++i) {
                        log.debug((Object)("Adding record " + i + " to result"));
                        NamePlusRecord_type npr = new NamePlusRecord_type();
                        npr.name = raw_records[i].getSourceCollectionName();
                        npr.record = new record_inline13_type();
                        try {
                            npr.record.which = 0;
                            npr.record.o = this.encodeRecordForZ3950(raw_records[i]);
                        }
                        catch (Exception e) {
                            log.warn((Object)"Problem encoding respionse fragment", (Throwable)e);
                            npr.record.which = 1;
                            DiagRec_type diag_rec = new DiagRec_type();
                            DefaultDiagFormat_type default_diag = new DefaultDiagFormat_type();
                            default_diag.diagnosticSetId = this.reg.oidByName("diag-bib-1");
                            default_diag.condition = BigInteger.valueOf(0L);
                            default_diag.addinfo = new addinfo_inline14_type();
                            default_diag.addinfo.which = 0;
                            default_diag.addinfo.o = e.toString();
                            diag_rec.which = 0;
                            diag_rec.o = default_diag;
                            npr.record.o = diag_rec;
                        }
                        v.add(npr);
                    }
                    break block7;
                }
                log.error((Object)"createRecordsFor called with no internal records");
                retval.which = 1;
                DefaultDiagFormat_type default_diag = new DefaultDiagFormat_type();
                retval.o = default_diag;
                default_diag.diagnosticSetId = this.reg.oidByName("diag-bib-1");
                default_diag.condition = BigInteger.valueOf(0L);
                default_diag.addinfo = new addinfo_inline14_type();
                default_diag.addinfo.which = 0;
                default_diag.addinfo.o = "createRecordsFor called with no internal records";
            }
            catch (Exception pe) {
                log.error((Object)("Error processing records in createRecordsFor.." + spec), (Throwable)pe);
                retval.which = 1;
                DefaultDiagFormat_type default_diag = new DefaultDiagFormat_type();
                retval.o = default_diag;
                default_diag.diagnosticSetId = this.reg.oidByName("diag-bib-1");
                default_diag.condition = BigInteger.valueOf(0L);
                default_diag.addinfo = new addinfo_inline14_type();
                default_diag.addinfo.which = 0;
                default_diag.addinfo.o = pe.toString();
            }
        }
        return retval;
    }

    private EXTERNAL_type encodeRecordForZ3950(InformationFragment fragment) {
        log.debug((Object)("encodeRecordForZ3950... encoding=" + fragment.getFormatSpecification().getEncoding() + ", schema=" + fragment.getFormatSpecification().getSchema().toString()));
        EXTERNAL_type rec = null;
        if (fragment.getOriginalObject() instanceof Document) {
            rec = new EXTERNAL_type();
            rec.direct_reference = this.reg.oidByName("xml");
            rec.encoding = new encoding_inline0_type();
            rec.encoding.which = 1;
            try {
                Document d = (Document)fragment.getOriginalObject();
                log.debug((Object)("serialize " + d.getDocumentElement()));
                OutputFormat format = new OutputFormat("xml", "utf-8", false);
                format.setOmitXMLDeclaration(true);
                StringWriter stringOut = new StringWriter();
                XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
                serial.asDOMSerializer();
                serial.serialize(d.getDocumentElement());
                log.debug((Object)("Serialized form is " + stringOut.toString()));
                rec.encoding.o = stringOut.toString().getBytes("UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
                rec.encoding.o = new String(e.toString()).getBytes();
            }
        } else if (fragment.getFormatSpecification().getEncoding().toString().equals("iso2709")) {
            rec = new EXTERNAL_type();
            rec.direct_reference = this.reg.oidByName(fragment.getFormatSpecification().getSchema().toString());
            rec.encoding = new encoding_inline0_type();
            rec.encoding.which = 1;
            rec.encoding.o = (byte[])fragment.getOriginalObject();
        } else if (fragment.getOriginalObject() instanceof String) {
            rec = new EXTERNAL_type();
            rec.direct_reference = this.reg.oidByName("sutrs");
            rec.encoding = new encoding_inline0_type();
            rec.encoding.which = 0;
            rec.encoding.o = fragment.toString();
        } else {
            throw new RuntimeException("unhandled object encoding: " + fragment.getFormatSpecification());
        }
        return rec;
    }

    private Records_type createNSD(String diag_code, String additional, Object[] params) {
        Records_type retval = new Records_type();
        retval.which = 1;
        DefaultDiagFormat_type default_diag = new DefaultDiagFormat_type();
        retval.o = default_diag;
        default_diag.diagnosticSetId = this.reg.oidByName("diag-bib-1");
        default_diag.condition = diag_code != null ? BigInteger.valueOf(Long.parseLong(diag_code)) : BigInteger.valueOf(0L);
        if (additional != null) {
            default_diag.addinfo = new addinfo_inline14_type();
            default_diag.addinfo.which = 0;
            default_diag.addinfo.o = additional;
        }
        return retval;
    }

    private ExplicitRecordFormatSpecification getExplicitFormat(String record_syntax, String element_set_name) {
        ExplicitRecordFormatSpecification result = null;
        if (record_syntax.equalsIgnoreCase("usmarc")) {
            result = new ExplicitRecordFormatSpecification("iso2709", "usmarc", element_set_name);
        } else if (record_syntax.equalsIgnoreCase("marc21")) {
            result = new ExplicitRecordFormatSpecification("iso2709", "marc21", element_set_name);
        } else if (record_syntax.equalsIgnoreCase("ukmark")) {
            result = new ExplicitRecordFormatSpecification("iso2709", "ukmarc", element_set_name);
        } else if (record_syntax.equalsIgnoreCase("sutrs")) {
            result = new ExplicitRecordFormatSpecification("string", "sutrs", element_set_name);
        } else if (record_syntax.equalsIgnoreCase("xml")) {
            result = new ExplicitRecordFormatSpecification("xml", null, element_set_name);
        }
        return result;
    }

    private void createAdditionalSearchInfo(List l, BackendStatusReportDTO backend_status_report) {
        String report = backend_status_report.toString();
        OtherInformationItem43_type result = new OtherInformationItem43_type();
        result.information = new information_inline44_type();
        result.information.which = 0;
        result.information.o = report;
        l.add(result);
    }
}

