/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.provider.z3950;

import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.a2j.gen.AsnUseful.EXTERNAL_type;
import org.jzkit.search.provider.iface.IREvent;
import org.jzkit.search.provider.z3950.PresentCallbackHandler;
import org.jzkit.search.provider.z3950.Z3950Origin;
import org.jzkit.search.util.RecordModel.ArchetypeRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.FormatProperty;
import org.jzkit.search.util.RecordModel.IndirectFormatProperty;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.jzkit.search.util.RecordModel.InformationFragmentImpl;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.ResultSet.AbstractIRResultSet;
import org.jzkit.search.util.ResultSet.AsynchronousEnumeration;
import org.jzkit.search.util.ResultSet.IFSNotificationTarget;
import org.jzkit.search.util.ResultSet.IRResultSet;
import org.jzkit.search.util.ResultSet.IRResultSetException;
import org.jzkit.search.util.ResultSet.IRResultSetInfo;
import org.jzkit.search.util.ResultSet.ReadAheadEnumeration;
import org.jzkit.util.FormatSpecOIDHelper;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DefaultDiagFormat_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DiagRec_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.NamePlusRecord_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PresentResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Records_type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Z3950SearchTask
extends AbstractIRResultSet
implements IRResultSet {
    public static final int ZSTATUS_NONE = 0;
    public static final int ZSTATUS_IDLE = 1;
    public static final int ZSTATUS_SEARCHING = 2;
    public static final int ZSTATUS_SEARCH_COMPLETE = 3;
    public static final int ZSTATUS_PRESENTING = 4;
    public static final int ZSTATUS_ALL_PRESENTED = 5;
    public static final int ZSTATUS_SORTING = 6;
    public static final int ZSTATUS_SORT_COMPLETE = 7;
    public static final int ZSTATUS_ERROR = 8;
    private static final String[] private_status_types = new String[]{"Undefined", "Idle", "Searching", "Search complete", "Requesting records", "All records returned", "Sorting", "Sort Complete", "Error"};
    public int z3950_status = 0;
    private Z3950Origin protocol_endpoint = null;
    private int fragment_count = 0;
    private static Log log = LogFactory.getLog(Z3950SearchTask.class);
    public static int dbg_counter = 0;
    private int default_present_timeout = 60000;
    private RecordFormatSpecification default_spec = null;
    private String grs_record_profile = null;
    private Hashtable outstanding_requests = new Hashtable();
    private String charset = "UTF-8";
    private DocumentBuilder docBuilder = null;
    private DocumentBuilder htmldb = null;

    public Z3950SearchTask(Z3950Origin protocol_endpoint, Observer[] observers, RecordFormatSpecification default_spec) {
        super(observers);
        ++dbg_counter;
        this.protocol_endpoint = protocol_endpoint;
        this.default_spec = default_spec;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            docFactory.setValidating(false);
            docFactory.setAttribute("http://xml.org/sax/features/validation", Boolean.FALSE);
            docFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            this.docBuilder = docFactory.newDocumentBuilder();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(false);
            dbf.setIgnoringElementContentWhitespace(false);
            dbf.setExpandEntityReferences(false);
            this.htmldb = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void finalize() {
        log.debug((Object)("Z3950SearchTask::finalize() (" + --dbg_counter + " active)"));
    }

    protected void setPrivateStatusCode(int code) {
        this.z3950_status = code;
    }

    public int getPrivateTaskStatusCode() {
        return this.z3950_status;
    }

    public String lookupPrivateStatusCode(int code) {
        return private_status_types[code];
    }

    public InformationFragment[] getFragment(int starting_fragment, int count, RecordFormatSpecification spec) throws IRResultSetException {
        if (this.protocol_endpoint.connected()) {
            ExplicitRecordFormatSpecification actual_spec = this.interpretSpec(spec);
            log.debug((Object)("Z3950SearchTask::getFragment - " + this.protocol_endpoint.getServiceId() + "," + this.protocol_endpoint.getServiceName() + "," + this.protocol_endpoint.getHost() + "."));
            log.debug((Object)("Z3950SearchTask::getFragment(" + starting_fragment + "," + count + "," + actual_spec + ")"));
            if (starting_fragment > this.fragment_count) {
                throw new IRResultSetException("Present out of range, only " + this.fragment_count + " records available");
            }
            if (starting_fragment + count - 1 > this.fragment_count) {
                count = this.fragment_count - starting_fragment + 1;
                log.debug((Object)("get asks for record past end of result set, trim to " + count));
            }
            Object result = null;
            PresentResponse_type pr = this.protocol_endpoint.fetchRecords(this.getSetID(), actual_spec, starting_fragment, count, this.default_present_timeout);
            return this.processRecords(pr.records, actual_spec, starting_fragment);
        }
        log.debug((Object)"GF Remote target has become disconnected, mark this result set as FAILURE");
        this.setStatus(8);
        return null;
    }

    public void asyncGetFragment(int starting_fragment, int count, RecordFormatSpecification spec, IFSNotificationTarget target) throws IRResultSetException {
        if (this.protocol_endpoint.connected()) {
            ExplicitRecordFormatSpecification actual_spec = this.interpretSpec(spec);
            log.debug((Object)("Z3950SearchTask::asyncgetFragment(" + starting_fragment + "," + count + "," + actual_spec + ")"));
            if (starting_fragment > this.fragment_count) {
                throw new IRResultSetException("Present out of range, only " + this.fragment_count + " records available");
            }
            if (starting_fragment + count - 1 > this.fragment_count) {
                count = this.fragment_count - starting_fragment + 1;
                log.debug((Object)("get asks for record past end of result set, trim to " + count));
            }
            try {
                this.protocol_endpoint.asyncFetchRecords(this.getSetID(), actual_spec, starting_fragment, count, new PresentCallbackHandler(this, target, actual_spec, starting_fragment));
            }
            catch (IRResultSetException rse) {
                log.warn((Object)"Problem", (Throwable)rse);
                target.notifyError("bib1-diag", null, "Problem", (Throwable)new IRResultSetException(rse.toString()));
            }
        } else {
            log.debug((Object)"Remote target has become disconnected, mark this result set as FAILURE");
            this.setStatus(8);
            target.notifyError("bib1-diag", null, "Problem", (Throwable)new IRResultSetException("Connection Closed"));
        }
    }

    protected InformationFragment[] processRecords(Records_type r, ExplicitRecordFormatSpecification actual_spec, int starting_fragment) {
        InformationFragment[] result;
        block42: {
            block41: {
                result = null;
                if (r == null) break block41;
                switch (r.which) {
                    case 0: {
                        ArrayList v = (ArrayList)r.o;
                        int num_records = v.size();
                        int counter = 0;
                        result = new InformationFragment[num_records];
                        log.debug((Object)("Response contains " + num_records + " Response Records"));
                        Iterator recs = v.iterator();
                        while (recs.hasNext()) {
                            int hitno = starting_fragment + counter;
                            NamePlusRecord_type npr = (NamePlusRecord_type)recs.next();
                            if (null != npr) {
                                String source_name = this.protocol_endpoint.getTargetDN();
                                String source_collection = npr.name;
                                if (source_collection == null) {
                                    source_collection = "No Collection Given";
                                }
                                log.debug((Object)("Result record, source name:" + source_name + " source collection:" + source_collection + "."));
                                block7 : switch (npr.record.which) {
                                    case 0: {
                                        EXTERNAL_type et = (EXTERNAL_type)npr.record.o;
                                        int[] record_oid = et.direct_reference;
                                        ExplicitRecordFormatSpecification spec = FormatSpecOIDHelper.getSpec((OIDRegister)this.protocol_endpoint.reg, (int[])record_oid, (String)null, null);
                                        log.debug((Object)("Derived record spec : " + spec));
                                        switch (et.direct_reference.length) {
                                            case 6: {
                                                switch (et.direct_reference[5]) {
                                                    case 1: {
                                                        result[counter++] = new InformationFragmentImpl((long)hitno, source_name, source_collection, null, et.encoding.o, new ExplicitRecordFormatSpecification("iso2709:unimarc:F"));
                                                        break block7;
                                                    }
                                                    case 3: {
                                                        break block7;
                                                    }
                                                    case 10: 
                                                    case 11: 
                                                    case 12: 
                                                    case 13: 
                                                    case 14: 
                                                    case 15: 
                                                    case 21: 
                                                    case 22: {
                                                        result[counter++] = new InformationFragmentImpl((long)hitno, source_name, source_collection, null, et.encoding.o, spec);
                                                        break block7;
                                                    }
                                                    case 100: {
                                                        log.debug((Object)"Explain");
                                                        result[counter++] = new InformationFragmentImpl((long)hitno, source_name, source_collection, null, et.encoding.o, new ExplicitRecordFormatSpecification("java:" + et.encoding.o.getClass().getName() + ":F"));
                                                        break block7;
                                                    }
                                                    case 101: {
                                                        log.debug((Object)"SUTRS");
                                                        result[counter++] = new InformationFragmentImpl((long)hitno, source_name, source_collection, null, et.encoding.o, new ExplicitRecordFormatSpecification("string::F"));
                                                        break block7;
                                                    }
                                                    case 102: {
                                                        log.debug((Object)"Opac record");
                                                        result[counter++] = new InformationFragmentImpl((long)hitno, source_name, source_collection, null, et.encoding.o, new ExplicitRecordFormatSpecification("asn1:opac:F"));
                                                    }
                                                    case 105: {
                                                        log.debug((Object)"GRS1");
                                                        break block7;
                                                    }
                                                }
                                                log.info((Object)("unknow Syntax OID ending with " + et.direct_reference[4]));
                                                result[counter++] = new InformationFragmentImpl((long)hitno, source_name, source_collection, null, et.encoding.o, new ExplicitRecordFormatSpecification("bytes::F"));
                                                break block7;
                                            }
                                            case 7: {
                                                if (et.direct_reference[5] == 109) {
                                                    switch (et.direct_reference[6]) {
                                                        case 1: {
                                                            log.debug((Object)"PDF Document...");
                                                            break block7;
                                                        }
                                                        case 9: {
                                                            log.debug((Object)"SGML record...");
                                                            break block7;
                                                        }
                                                        case 3: {
                                                            String htm = new String((byte[])et.encoding.o);
                                                            log.debug((Object)("HTML doc is " + htm));
                                                            Document doc = null;
                                                            try {
                                                                doc = this.htmldb.newDocument();
                                                                Element root = doc.createElement("HTML");
                                                                root.appendChild(doc.createTextNode(htm));
                                                                doc.appendChild(root);
                                                                result[counter++] = new InformationFragmentImpl((long)hitno, source_name, source_collection, null, (Object)doc, actual_spec);
                                                            }
                                                            catch (Exception e) {
                                                                e.printStackTrace();
                                                            }
                                                            break block7;
                                                        }
                                                        case 10: {
                                                            String rec = new String((byte[])et.encoding.o);
                                                            log.debug((Object)("XML doc is " + rec));
                                                            try {
                                                                Document new_result_document = this.docBuilder.parse(new ByteArrayInputStream((byte[])et.encoding.o));
                                                                result[counter++] = new InformationFragmentImpl((long)hitno, source_name, source_collection, null, (Object)new_result_document, actual_spec);
                                                            }
                                                            catch (Exception e) {
                                                                e.printStackTrace();
                                                            }
                                                            break block7;
                                                        }
                                                    }
                                                    break block7;
                                                }
                                                log.info((Object)"Unhandled 7-int OID for record type");
                                            }
                                        }
                                        break;
                                    }
                                    case 1: {
                                        log.info((Object)"SurrogateDiagnostic");
                                        DiagRec_type d = (DiagRec_type)npr.record.o;
                                        if (d.which == 0) {
                                            DefaultDiagFormat_type ddf = (DefaultDiagFormat_type)d.o;
                                            String reason = "Diagnostic " + (ddf.addinfo != null ? ddf.addinfo.toString() : "none");
                                            log.info((Object)("  code:" + ddf.condition + " reason:" + reason));
                                            this.setDiagnosticStatus("diag.bib1." + ddf.condition, this.protocol_endpoint.getTargetName(), source_name + " " + source_collection);
                                            result[counter++] = new InformationFragmentImpl((long)hitno, source_name, source_collection, null, (Object)ddf.condition, new ExplicitRecordFormatSpecification("string::F"));
                                            break;
                                        }
                                        log.info((Object)"Externally defined surrogate");
                                        this.setDiagnosticStatus("diag.k-int.7", this.protocol_endpoint.getTargetName(), source_name + " " + source_collection);
                                        result[counter++] = new InformationFragmentImpl((long)hitno, source_name, source_collection, null, (Object)"diag", new ExplicitRecordFormatSpecification("string::F"));
                                        break;
                                    }
                                    case 2: {
                                        log.info((Object)"StartingFragment");
                                        break;
                                    }
                                    case 3: {
                                        log.info((Object)"IntermediateFragment");
                                        break;
                                    }
                                    case 4: {
                                        log.info((Object)"FinalFragment");
                                        break;
                                    }
                                    default: {
                                        log.info((Object)"Unhandled record type");
                                        break;
                                    }
                                }
                                continue;
                            }
                            log.debug((Object)"Error... record ptr is null");
                        }
                        break block42;
                    }
                    case 1: {
                        DefaultDiagFormat_type d = (DefaultDiagFormat_type)r.o;
                        if (d.addinfo != null) {
                            log.info((Object)("Non surrogate diagnostics [" + d.condition + "] Additional Info : " + d.addinfo.o));
                            this.setDiagnosticStatus("diag.bib1." + d.condition, this.protocol_endpoint.getTargetName(), "Additional Info : " + d.addinfo.o);
                            break;
                        }
                        log.info((Object)("Non surrogate diagnostics [" + d.condition + "] no additional info"));
                        this.setDiagnosticStatus("diag.bib1." + d.condition, this.protocol_endpoint.getTargetName(), null);
                        break;
                    }
                    case 2: {
                        log.info((Object)"Multiple non surrogate diagnostics");
                        break;
                    }
                    default: {
                        log.info((Object)("Unknown choice for records response : " + r.which));
                    }
                }
                break block42;
            }
            log.debug((Object)"Records member of present response is null");
        }
        return result;
    }

    public void setFragmentCount(int i) {
        log.debug((Object)("Z3950SearchTask::setFragmentCount(" + i + ")"));
        this.fragment_count = i;
        IREvent e = new IREvent(1001, (Object)new Integer(i));
        log.debug((Object)"setChanged");
        this.setChanged();
        log.debug((Object)"notifyObservers");
        this.notifyObservers(e);
        log.debug((Object)"leave Z3950SearchTask::setFragmentCount");
    }

    public int getFragmentCount() {
        return this.fragment_count;
    }

    public int getRecordAvailableHWM() {
        return this.fragment_count;
    }

    public void cancelTask() {
        log.debug((Object)"Z3950SearchTask::cancelTask()");
    }

    public void close() {
        log.debug((Object)"Z3950SearchTask::close()");
    }

    public void destroyTask() {
        super.destroyTask();
        log.debug((Object)"Z3950SearchTask::destroyTask()");
    }

    public AsynchronousEnumeration elements() {
        log.debug((Object)"Z3950SearchTask::elements()");
        int default_present_chunk_size = 10;
        return new ReadAheadEnumeration((IRResultSet)this, default_present_chunk_size);
    }

    public String toString() {
        return "Z3950SearchTask - " + this.getSetID();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExplicitRecordFormatSpecification interpretSpec(RecordFormatSpecification in_spec) throws IRResultSetException {
        ExplicitRecordFormatSpecification retval = null;
        if (in_spec instanceof ExplicitRecordFormatSpecification) {
            ExplicitRecordFormatSpecification spec;
            retval = spec = (ExplicitRecordFormatSpecification)in_spec;
            boolean new_spec_needed = false;
            try {
                String new_format = this.strval(spec.getEncoding());
                String new_schema = this.strval(spec.getSchema());
                String new_esetname = this.strval(spec.getSetname());
                log.debug((Object)("InterpretSpec " + spec));
                if (spec.getEncoding() instanceof IndirectFormatProperty) {
                    log.debug((Object)("Convert format " + spec.getEncoding()));
                    new_format = BeanUtils.getProperty((Object)this.protocol_endpoint, (String)new_format);
                    new_spec_needed = true;
                    log.debug((Object)("actual format will be " + new_format));
                }
                if (spec.getSchema() instanceof IndirectFormatProperty) {
                    new_schema = BeanUtils.getProperty((Object)this.protocol_endpoint, (String)new_schema);
                    new_spec_needed = true;
                    log.debug((Object)("actual format will be " + new_schema));
                }
                if (spec.getSetname() instanceof IndirectFormatProperty) {
                    log.debug((Object)("Convert setname " + spec.getSchema()));
                    new_esetname = BeanUtils.getProperty((Object)this.protocol_endpoint, (String)new_esetname);
                    new_spec_needed = true;
                    log.debug((Object)("actual format will be " + new_esetname));
                }
                if (!new_spec_needed) return retval;
                retval = new ExplicitRecordFormatSpecification(new_format, new_schema, new_esetname);
                log.debug((Object)("Converted " + spec.toString() + " into " + retval));
                return retval;
            }
            catch (IllegalAccessException iae) {
                throw new IRResultSetException("Problem interpreting spec", (Object)iae);
            }
            catch (InvocationTargetException ite) {
                throw new IRResultSetException("Problem interpreting spec", (Object)ite);
            }
            catch (NoSuchMethodException nspe) {
                throw new IRResultSetException("Problem interpreting spec", (Object)nspe);
            }
        } else {
            if (!(in_spec instanceof ArchetypeRecordFormatSpecification)) throw new IRResultSetException("Unhandled RecordFormatSpecification of class " + in_spec.getClass().getName());
            String actual_spec = (String)this.protocol_endpoint.getRecordArchetypes().get(in_spec.toString());
            if (actual_spec == null) {
                throw new IRResultSetException("Unable to locate format specification for archetype " + in_spec.toString());
            }
            log.debug((Object)("Record Archetype " + in_spec + " converted to " + actual_spec));
            return new ExplicitRecordFormatSpecification(actual_spec);
        }
    }

    private String strval(FormatProperty p) {
        if (p != null) {
            return p.toString();
        }
        return null;
    }

    public IRResultSetInfo getResultSetInfo() {
        return new IRResultSetInfo(this.getResultSetName(), "Z3950", null, this.getFragmentCount(), this.getStatus(), null);
    }
}

