/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.stream.VLSNReader;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.VLSN;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FeederSyncupReader
extends VLSNReader {
    private final VLSNIndex.BackwardVLSNScanner scanner;

    public FeederSyncupReader(EnvironmentImpl envImpl, VLSNIndex vlsnIndex, long endOfLogLsn, int readBufferSize, NameIdPair nameIdPair, VLSN startVLSN, long finishLsn) throws IOException, DatabaseException {
        super(envImpl, vlsnIndex, false, endOfLogLsn, readBufferSize, nameIdPair, finishLsn);
        this.scanner = new VLSNIndex.BackwardVLSNScanner(vlsnIndex);
        this.initScan(startVLSN);
    }

    private void initScan(VLSN startVLSN) throws DatabaseException, IOException {
        if (startVLSN.equals(VLSN.NULL_VLSN)) {
            throw EnvironmentFailureException.unexpectedState("FeederSyncupReader start can't be NULL_VLSN");
        }
        VLSN startPoint = startVLSN;
        this.startLsn = this.scanner.getStartingLsn(startPoint);
        assert (this.startLsn != -1L);
        this.envImpl.getLogManager().flushNoSync();
        this.window.initAtFileStart(this.startLsn);
        this.currentEntryPrevOffset = this.window.getEndOffset();
        this.currentEntryOffset = this.window.getEndOffset();
        this.currentVLSN = startVLSN;
    }

    public OutputWireRecord scanBackwards(VLSN vlsn) throws FileNotFoundException, ChecksumException {
        VLSNRange range = this.vlsnIndex.getRange();
        if (vlsn.compareTo(range.getFirst()) < 0) {
            return null;
        }
        this.currentVLSN = vlsn;
        long repositionLsn = this.scanner.getPreciseLsn(vlsn);
        this.setPosition(repositionLsn);
        if (this.readNextEntry()) {
            return this.currentFeedRecord;
        }
        return null;
    }

    private void checkForPassingTarget(int compareResult) {
        if (compareResult < 0) {
            throw EnvironmentFailureException.unexpectedState("want to read " + this.currentVLSN + " but reader at " + this.currentEntryHeader.getVLSN());
        }
    }

    protected boolean isTargetEntry() throws DatabaseException {
        ++this.nScanned;
        if (this.currentEntryHeader.isInvisible()) {
            return false;
        }
        if (this.entryIsReplicated()) {
            VLSN entryVLSN = this.currentEntryHeader.getVLSN();
            int compareResult = entryVLSN.compareTo(this.currentVLSN);
            this.checkForPassingTarget(compareResult);
            return compareResult == 0;
        }
        return false;
    }

    protected boolean processEntry(ByteBuffer entryBuffer) {
        ByteBuffer buffer = entryBuffer.slice();
        buffer.limit(this.currentEntryHeader.getItemSize());
        this.currentFeedRecord = new OutputWireRecord(this.currentEntryHeader, buffer);
        entryBuffer.position(entryBuffer.position() + this.currentEntryHeader.getItemSize());
        return true;
    }
}

