/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rackspace.clouddns.v1.CloudDNSApi;
import org.jclouds.rackspace.clouddns.v1.domain.Subdomain;
import org.jclouds.rackspace.clouddns.v1.features.DomainApi;

@Beta
public class SubdomainsToPagedIterable
extends Arg0ToPagedIterable<Subdomain, SubdomainsToPagedIterable> {
    private final DomainApi api;

    @Inject
    protected SubdomainsToPagedIterable(CloudDNSApi api) {
        this.api = ((CloudDNSApi)Preconditions.checkNotNull((Object)api, (Object)"api")).getDomainApi();
    }

    protected Function<Object, IterableWithMarker<Subdomain>> markerToNextForArg0(Optional<Object> domainId) {
        return new ListSubdomainsUnderDomainIdAtMarker(this.api, Integer.parseInt(domainId.get().toString()));
    }

    private static class ListSubdomainsUnderDomainIdAtMarker
    implements Function<Object, IterableWithMarker<Subdomain>> {
        private final DomainApi api;
        private final int domainId;

        @Inject
        protected ListSubdomainsUnderDomainIdAtMarker(DomainApi api, int domainId) {
            this.api = (DomainApi)Preconditions.checkNotNull((Object)api, (Object)"api");
            this.domainId = domainId;
        }

        public PaginatedCollection<Subdomain> apply(Object input) {
            PaginationOptions paginationOptions = (PaginationOptions)input;
            return this.api.listSubdomains(this.domainId, paginationOptions);
        }

        public String toString() {
            return "ListSubdomainsUnderDomainIdAtMarker(" + this.domainId + ")";
        }
    }
}

