/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.nosql.NoSqlSessionDataStore;
import org.eclipse.jetty.nosql.mongodb.MongoUtils;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.util.ClassLoadingObjectInputStream;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class MongoSessionDataStore
extends NoSqlSessionDataStore {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    public static final String METADATA = "__metadata__";
    public static final String CONTEXT = "context";
    public static final String VERSION = "__metadata__.version";
    public static final String LASTSAVED = "__metadata__.lastSaved";
    public static final String LASTNODE = "__metadata__.lastNode";
    public static final String ACCESSED = "accessed";
    public static final String LAST_ACCESSED = "lastAccessed";
    public static final String ATTRIBUTES = "attributes";
    public static final String EXPIRY = "expiry";
    public static final String MAX_IDLE = "maxIdle";
    public static final String CREATED = "created";
    public static final String VALID = "valid";
    public static final String ID = "id";
    private DBObject _version1;
    private DBCollection _dbSessions;

    public void setDBCollection(DBCollection collection) {
        this._dbSessions = collection;
    }

    @ManagedAttribute(value="DBCollection", readonly=true)
    public DBCollection getDBCollection() {
        return this._dbSessions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SessionData doLoad(String id) throws Exception {
        DBObject sessionDocument = this._dbSessions.findOne((DBObject)new BasicDBObject(ID, (Object)id));
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("id={} loaded={}", new Object[]{id, sessionDocument});
            }
            if (sessionDocument == null) {
                return null;
            }
            Boolean valid = (Boolean)sessionDocument.get(VALID);
            if (LOG.isDebugEnabled()) {
                LOG.debug("id={} valid={}", new Object[]{id, valid});
            }
            if (valid == null || !valid.booleanValue()) {
                return null;
            }
            Object version = MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(VERSION));
            Long lastSaved = (Long)MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(LASTSAVED));
            String lastNode = (String)MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(LASTNODE));
            byte[] attributes = (byte[])MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(ATTRIBUTES));
            Long created = (Long)sessionDocument.get(CREATED);
            Long accessed = (Long)sessionDocument.get(ACCESSED);
            Long lastAccessed = (Long)sessionDocument.get(LAST_ACCESSED);
            Long maxInactive = (Long)sessionDocument.get(MAX_IDLE);
            Long expiry = (Long)sessionDocument.get(EXPIRY);
            NoSqlSessionDataStore.NoSqlSessionData data = null;
            DBObject sessionSubDocumentForContext = (DBObject)MongoUtils.getNestedValue(sessionDocument, this.getContextField());
            if (LOG.isDebugEnabled()) {
                LOG.debug("attrs {}", new Object[]{sessionSubDocumentForContext});
            }
            if (sessionSubDocumentForContext != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Session {} present for context {}", new Object[]{id, this._context});
                }
                data = (NoSqlSessionDataStore.NoSqlSessionData)this.newSessionData(id, created, accessed, lastAccessed == null ? accessed : lastAccessed, maxInactive);
                data.setVersion(version);
                data.setExpiry(expiry);
                data.setContextPath(this._context.getCanonicalContextPath());
                data.setVhost(this._context.getVhost());
                data.setLastSaved(lastSaved);
                data.setLastNode(lastNode);
                if (attributes == null) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String name : sessionSubDocumentForContext.keySet()) {
                        if (METADATA.equals(name)) continue;
                        String attr = MongoUtils.decodeName(name);
                        Object value = MongoUtils.decodeValue(sessionSubDocumentForContext.get(name));
                        map.put(attr, value);
                    }
                    data.putAllAttributes(map);
                    return data;
                }
                try (ByteArrayInputStream bais = new ByteArrayInputStream(attributes);
                     ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream((InputStream)bais);){
                    SessionData.deserializeAttributes((SessionData)data, (ObjectInputStream)ois);
                    return data;
                }
            }
            if (!LOG.isDebugEnabled()) return data;
            LOG.debug("Session  {} not present for context {}", new Object[]{id, this._context});
            return data;
        }
        catch (Exception e) {
            throw new UnreadableSessionDataException(id, this._context, (Throwable)e);
        }
    }

    public boolean delete(String id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Remove:session {} for context ", new Object[]{id, this._context});
        }
        BasicDBObject mongoKey = new BasicDBObject(ID, (Object)id);
        DBObject sessionDocument = this._dbSessions.findOne((DBObject)new BasicDBObject(ID, (Object)id));
        if (sessionDocument != null) {
            DBObject c = (DBObject)MongoUtils.getNestedValue(sessionDocument, CONTEXT);
            if (c == null) {
                this._dbSessions.remove((DBObject)mongoKey, WriteConcern.SAFE);
                return false;
            }
            Set contexts = c.keySet();
            if (contexts.isEmpty()) {
                this._dbSessions.remove((DBObject)mongoKey, WriteConcern.SAFE);
                return false;
            }
            if (contexts.size() == 1 && ((String)contexts.iterator().next()).equals(this.getCanonicalContextId())) {
                this._dbSessions.remove((DBObject)new BasicDBObject(ID, (Object)id), WriteConcern.SAFE);
                return true;
            }
            BasicDBObject remove = new BasicDBObject();
            BasicDBObject unsets = new BasicDBObject();
            unsets.put(this.getContextField(), (Object)1);
            remove.put("$unset", (Object)unsets);
            this._dbSessions.update((DBObject)mongoKey, (DBObject)remove, false, false, WriteConcern.SAFE);
            return true;
        }
        return false;
    }

    public boolean exists(String id) throws Exception {
        BasicDBObject fields = new BasicDBObject();
        fields.put(EXPIRY, (Object)1);
        fields.put(VALID, (Object)1);
        fields.put(this.getContextSubfield(VERSION), (Object)1);
        DBObject sessionDocument = this._dbSessions.findOne((DBObject)new BasicDBObject(ID, (Object)id), (DBObject)fields);
        if (sessionDocument == null) {
            return false;
        }
        Boolean valid = (Boolean)sessionDocument.get(VALID);
        if (!valid.booleanValue()) {
            return false;
        }
        Long expiry = (Long)sessionDocument.get(EXPIRY);
        if (expiry > 0L && expiry < System.currentTimeMillis()) {
            return false;
        }
        Object version = MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(VERSION));
        return version != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> doGetExpired(Set<String> candidates) {
        long now;
        long upperBound = now = System.currentTimeMillis();
        HashSet<String> expiredSessions = new HashSet<String>();
        BasicDBObject query = new BasicDBObject();
        query.append(ID, (Object)new BasicDBObject("$in", candidates));
        query.append(EXPIRY, (Object)new BasicDBObject("$gt", (Object)0).append("$lt", (Object)upperBound));
        try (DBCursor verifiedExpiredSessions = null;){
            verifiedExpiredSessions = this._dbSessions.find((DBObject)query, (DBObject)new BasicDBObject(ID, (Object)1));
            for (DBObject session : verifiedExpiredSessions) {
                String id = (String)session.get(ID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Mongo confirmed expired session {}", new Object[]{this._context, id});
                }
                expiredSessions.add(id);
            }
        }
        upperBound = this._lastExpiryCheckTime <= 0L ? now - 3L * (1000L * (long)this._gracePeriodSec) : this._lastExpiryCheckTime - 1000L * (long)this._gracePeriodSec;
        query = new BasicDBObject();
        BasicDBObject gt = new BasicDBObject(EXPIRY, (Object)new BasicDBObject("$gt", (Object)0));
        BasicDBObject lt = new BasicDBObject(EXPIRY, (Object)new BasicDBObject("$lt", (Object)upperBound));
        BasicDBList list = new BasicDBList();
        list.add((Object)gt);
        list.add((Object)lt);
        query.append("$and", (Object)list);
        try (DBCursor oldExpiredSessions = null;){
            BasicDBObject bo = new BasicDBObject(ID, (Object)1);
            bo.append(EXPIRY, (Object)1);
            oldExpiredSessions = this._dbSessions.find((DBObject)query, (DBObject)bo);
            for (DBObject session : oldExpiredSessions) {
                String id = (String)session.get(ID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Mongo found old expired session {}", new Object[]{this._context, id + " exp=" + session.get(EXPIRY)});
                }
                expiredSessions.add(id);
            }
        }
        for (String c : candidates) {
            if (expiredSessions.contains(c)) continue;
            try {
                if (this.exists(c)) continue;
                expiredSessions.add(c);
            }
            catch (Exception e) {
                LOG.warn("Problem checking potentially expired session {}", new Object[]{c, e});
            }
        }
        return expiredSessions;
    }

    public void initialize(SessionContext context) throws Exception {
        if (this.isStarted()) {
            throw new IllegalStateException("Context set after SessionDataStore started");
        }
        this._context = context;
        this.ensureIndexes();
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        BasicDBObject key = new BasicDBObject(ID, (Object)id);
        BasicDBObject update = new BasicDBObject();
        boolean upsert = false;
        BasicDBObject sets = new BasicDBObject();
        Object version = ((NoSqlSessionDataStore.NoSqlSessionData)data).getVersion();
        if (lastSaveTime <= 0L) {
            upsert = true;
            version = new Long(1L);
            sets.put(CREATED, (Object)data.getCreated());
            sets.put(VALID, (Object)true);
            sets.put(this.getContextSubfield(VERSION), version);
            sets.put(this.getContextSubfield(LASTSAVED), (Object)data.getLastSaved());
            sets.put(this.getContextSubfield(LASTNODE), (Object)data.getLastNode());
            sets.put(MAX_IDLE, (Object)data.getMaxInactiveMs());
            sets.put(EXPIRY, (Object)data.getExpiry());
            ((NoSqlSessionDataStore.NoSqlSessionData)data).setVersion(version);
        } else {
            sets.put(this.getContextSubfield(LASTSAVED), (Object)data.getLastSaved());
            sets.put(this.getContextSubfield(LASTNODE), (Object)data.getLastNode());
            version = new Long(((Number)version).longValue() + 1L);
            ((NoSqlSessionDataStore.NoSqlSessionData)data).setVersion(version);
            update.put("$inc", (Object)this._version1);
            BasicDBObject fields = new BasicDBObject();
            fields.append(MAX_IDLE, (Object)true);
            fields.append(EXPIRY, (Object)true);
            DBObject o = this._dbSessions.findOne((DBObject)new BasicDBObject(ID, (Object)id), (DBObject)fields);
            if (o != null) {
                long currentExpiry;
                Long tmpLong = (Long)o.get(MAX_IDLE);
                long currentMaxIdle = tmpLong == null ? 0L : tmpLong;
                tmpLong = (Long)o.get(EXPIRY);
                long l = currentExpiry = tmpLong == null ? 0L : tmpLong;
                if (currentMaxIdle != data.getMaxInactiveMs()) {
                    sets.put(MAX_IDLE, (Object)data.getMaxInactiveMs());
                }
                if (currentExpiry != data.getExpiry()) {
                    sets.put(EXPIRY, (Object)data.getExpiry());
                }
            } else {
                LOG.warn("Session {} not found, can't update", new Object[]{id});
            }
        }
        sets.put(ACCESSED, (Object)data.getAccessed());
        sets.put(LAST_ACCESSED, (Object)data.getLastAccessed());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            SessionData.serializeAttributes((SessionData)data, (ObjectOutputStream)oos);
            sets.put(this.getContextSubfield(ATTRIBUTES), (Object)baos.toByteArray());
        }
        if (!sets.isEmpty()) {
            update.put("$set", (Object)sets);
        }
        WriteResult res = this._dbSessions.update((DBObject)key, (DBObject)update, upsert, false, WriteConcern.SAFE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Save:db.sessions.update( {}, {},{} )", new Object[]{key, update, res});
        }
    }

    protected void ensureIndexes() throws MongoException {
        this._version1 = new BasicDBObject(this.getContextSubfield(VERSION), (Object)1);
        DBObject idKey = BasicDBObjectBuilder.start().add(ID, (Object)1).get();
        this._dbSessions.createIndex(idKey, BasicDBObjectBuilder.start().add("name", (Object)"id_1").add("ns", (Object)this._dbSessions.getFullName()).add("sparse", (Object)false).add("unique", (Object)true).get());
        DBObject versionKey = BasicDBObjectBuilder.start().add(ID, (Object)1).add("version", (Object)1).get();
        this._dbSessions.createIndex(versionKey, BasicDBObjectBuilder.start().add("name", (Object)"id_1_version_1").add("ns", (Object)this._dbSessions.getFullName()).add("sparse", (Object)false).add("unique", (Object)true).get());
        LOG.debug("done ensure Mongodb indexes existing", new Object[0]);
    }

    private String getContextField() {
        return "context." + this.getCanonicalContextId();
    }

    private String getCanonicalContextId() {
        return this.canonicalizeVHost(this._context.getVhost()) + ":" + this._context.getCanonicalContextPath();
    }

    private String canonicalizeVHost(String vhost) {
        if (vhost == null) {
            return "";
        }
        return StringUtil.replace((String)vhost, (char)'.', (char)'_');
    }

    private String getContextSubfield(String attr) {
        return this.getContextField() + "." + attr;
    }

    @ManagedAttribute(value="does store serialize sessions", readonly=true)
    public boolean isPassivating() {
        return true;
    }

    public String toString() {
        return String.format("%s[collection=%s]", super.toString(), this.getDBCollection());
    }
}

