/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.strategy.ListCookbookVersions;
import org.jclouds.chef.strategy.internal.BaseListCookbookVersionsImpl;
import org.jclouds.logging.Logger;

@Singleton
public class ListCookbookVersionsImpl
extends BaseListCookbookVersionsImpl
implements ListCookbookVersions {
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    ListCookbookVersionsImpl(ChefApi api) {
        super(api);
    }

    @Override
    public Iterable<? extends CookbookVersion> execute() {
        return super.execute(this.api.listCookbooks());
    }

    @Override
    public Iterable<? extends CookbookVersion> execute(ExecutorService executor) {
        return this.executeConcurrently(MoreExecutors.listeningDecorator((ExecutorService)executor));
    }

    private Iterable<? extends CookbookVersion> executeConcurrently(ListeningExecutorService executor) {
        return super.executeConcurrently(executor, this.api.listCookbooks());
    }
}

