/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.rdfxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.NamespaceListener;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParseException;
import org.openrdf.rio.ParseLocationListener;
import org.openrdf.rio.Parser;
import org.openrdf.rio.StatementHandler;
import org.openrdf.rio.StatementHandlerException;
import org.openrdf.rio.rdfxml.Att;
import org.openrdf.rio.rdfxml.Atts;
import org.openrdf.rio.rdfxml.SAXFilter;
import org.openrdf.util.uri.URI;
import org.openrdf.util.xml.XMLReaderFactory;
import org.openrdf.util.xml.XmlDatatypeUtil;
import org.openrdf.util.xml.XmlUtil;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class RdfXmlParser
implements Parser {
    private org.openrdf.model.URI RDF_TYPE;
    private org.openrdf.model.URI RDF_SUBJECT;
    private org.openrdf.model.URI RDF_PREDICATE;
    private org.openrdf.model.URI RDF_OBJECT;
    private org.openrdf.model.URI RDF_STATEMENT;
    private org.openrdf.model.URI RDF_LI;
    private org.openrdf.model.URI RDF_FIRST;
    private org.openrdf.model.URI RDF_REST;
    private org.openrdf.model.URI RDF_NIL;
    private SAXFilter _saxFilter;
    private ValueFactory _valueFactory;
    private Map _bNodeIdMap;
    private StatementHandler _statementHandler;
    private ParseErrorListener _errorListener;
    private URI _baseURI;
    private String _documentURI;
    private String _xmlLang;
    private Stack _elementStack = new Stack();
    private Set _usedIDs = new HashSet();
    boolean _verifyData = true;
    boolean _preserveBNodeIds = false;
    private int _datatypeHandling;
    boolean _stopAtFirstError = true;

    public RdfXmlParser() {
        this((ValueFactory)new ValueFactoryImpl());
    }

    public RdfXmlParser(ValueFactory valueFactory) {
        this._valueFactory = valueFactory;
        this._bNodeIdMap = new HashMap();
        this._datatypeHandling = 20;
        this.RDF_TYPE = this._valueFactory.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.RDF_SUBJECT = this._valueFactory.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#subject");
        this.RDF_PREDICATE = this._valueFactory.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate");
        this.RDF_OBJECT = this._valueFactory.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#object");
        this.RDF_STATEMENT = this._valueFactory.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement");
        this.RDF_LI = this._valueFactory.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#li");
        this.RDF_FIRST = this._valueFactory.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        this.RDF_REST = this._valueFactory.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        this.RDF_NIL = this._valueFactory.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        this._saxFilter = new SAXFilter(this);
    }

    public synchronized void setStatementHandler(StatementHandler sh) {
        this._statementHandler = sh;
    }

    public synchronized void setParseErrorListener(ParseErrorListener el) {
        this._errorListener = el;
    }

    public synchronized void setParseLocationListener(ParseLocationListener ll) {
        this._saxFilter.setParseLocationListener(ll);
    }

    public synchronized void setNamespaceListener(NamespaceListener nl) {
        this._saxFilter.setNamespaceListener(nl);
    }

    public synchronized void setVerifyData(boolean verifyData) {
        this._verifyData = verifyData;
    }

    public synchronized void setPreserveBNodeIds(boolean preserveBNodeIds) {
        this._preserveBNodeIds = preserveBNodeIds;
    }

    public synchronized void setStopAtFirstError(boolean stopAtFirstError) {
        this._stopAtFirstError = stopAtFirstError;
    }

    public void setDatatypeHandling(int datatypeHandling) {
        this._datatypeHandling = datatypeHandling;
    }

    public void setParseStandAloneDocuments(boolean standAloneDocs) {
        this._saxFilter.setParseStandAloneDocuments(standAloneDocs);
    }

    public boolean getParseStandAloneDocuments() {
        return this._saxFilter.getParseStandAloneDocuments();
    }

    public synchronized void parse(InputStream in, String baseURI) throws IOException, ParseException, StatementHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream cannot be 'null'");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("Base URI cannot be 'null'");
        }
        InputSource inputSource = new InputSource(in);
        inputSource.setSystemId(baseURI);
        this._parse(inputSource);
    }

    public synchronized void parse(Reader reader, String baseURI) throws IOException, ParseException, StatementHandlerException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be 'null'");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("Base URI cannot be 'null'");
        }
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(baseURI);
        this._parse(inputSource);
    }

    private void _parse(InputSource inputSource) throws IOException, ParseException, StatementHandlerException {
        try {
            try {
                this._documentURI = inputSource.getSystemId();
                this._saxFilter.setDocumentURI(this._documentURI);
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                xmlReader.setContentHandler(this._saxFilter);
                xmlReader.parse(inputSource);
            }
            catch (SAXParseException e) {
                Exception wrappedExc = e.getException();
                if (wrappedExc == null) {
                    wrappedExc = e;
                }
                throw new ParseException(wrappedExc, e.getLineNumber(), e.getColumnNumber());
            }
            catch (SAXException e) {
                Exception wrappedExc = e.getException();
                if (wrappedExc == null) {
                    wrappedExc = e;
                }
                if (wrappedExc instanceof StatementHandlerException) {
                    throw (StatementHandlerException)wrappedExc;
                }
                throw new ParseException(wrappedExc, -1, -1);
            }
            Object var5_5 = null;
            this._saxFilter.clear();
            this._baseURI = null;
            this._xmlLang = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._saxFilter.clear();
            this._baseURI = null;
            this._xmlLang = null;
            this._elementStack.clear();
            this._usedIDs.clear();
            this._bNodeIdMap.clear();
            throw throwable;
        }
        this._elementStack.clear();
        this._usedIDs.clear();
        this._bNodeIdMap.clear();
    }

    void setBaseURI(URI baseURI) {
        this._baseURI = baseURI;
    }

    void setXmlLang(String xmlLang) {
        this._xmlLang = "".equals(xmlLang) ? null : xmlLang;
    }

    void startElement(String namespaceURI, String localName, String qName, Atts atts) throws SAXException {
        if (this._topIsProperty()) {
            this._processNodeElt(namespaceURI, localName, qName, atts, false);
        } else {
            this._processPropertyElt(namespaceURI, localName, qName, atts, false);
        }
    }

    void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Object topElement = this._peekStack(0);
        if (topElement instanceof NodeElement) {
            if (((NodeElement)topElement).isVolatile()) {
                this._elementStack.pop();
            }
        } else {
            PropertyElement predicate = (PropertyElement)topElement;
            if (predicate.parseCollection()) {
                Resource lastListResource = predicate.getLastListResource();
                if (lastListResource == null) {
                    NodeElement subject = (NodeElement)this._peekStack(1);
                    this._reportStatement(subject.getResource(), predicate.getURI(), (Value)this.RDF_NIL);
                    this._handleReification((Value)this.RDF_NIL);
                } else {
                    this._reportStatement(lastListResource, this.RDF_REST, (Value)this.RDF_NIL);
                }
            }
        }
        this._elementStack.pop();
    }

    void emptyElement(String namespaceURI, String localName, String qName, Atts atts) throws SAXException {
        if (this._topIsProperty()) {
            this._processNodeElt(namespaceURI, localName, qName, atts, true);
        } else {
            this._processPropertyElt(namespaceURI, localName, qName, atts, true);
        }
    }

    void text(String text) throws SAXException {
        if (!this._topIsProperty()) {
            throw new SAXException("unexpected literal");
        }
        PropertyElement propEl = (PropertyElement)this._peekStack(0);
        String datatype = propEl.getDatatype();
        Literal lit = this._createLiteral(text, this._xmlLang, datatype);
        NodeElement subject = (NodeElement)this._peekStack(1);
        PropertyElement predicate = (PropertyElement)this._peekStack(0);
        this._reportStatement(subject.getResource(), predicate.getURI(), (Value)lit);
        this._handleReification((Value)lit);
    }

    private void _processNodeElt(String namespaceURI, String localName, String qName, Atts atts, boolean isEmptyElt) throws SAXException {
        Att type;
        if (this._verifyData) {
            this._checkNodeEltName(namespaceURI, localName, qName);
        }
        Resource nodeResource = this._getNodeResource(atts);
        NodeElement nodeElement = new NodeElement(nodeResource);
        if (!this._elementStack.isEmpty()) {
            NodeElement subject = (NodeElement)this._peekStack(1);
            PropertyElement predicate = (PropertyElement)this._peekStack(0);
            if (predicate.parseCollection()) {
                Resource lastListRes = predicate.getLastListResource();
                BNode newListRes = this._createBNode();
                if (lastListRes == null) {
                    this._reportStatement(subject.getResource(), predicate.getURI(), (Value)newListRes);
                    this._handleReification((Value)newListRes);
                } else {
                    this._reportStatement(lastListRes, this.RDF_REST, (Value)newListRes);
                }
                this._reportStatement((Resource)newListRes, this.RDF_FIRST, (Value)nodeResource);
                predicate.setLastListResource((Resource)newListRes);
            } else {
                this._reportStatement(subject.getResource(), predicate.getURI(), (Value)nodeResource);
                this._handleReification((Value)nodeResource);
            }
        }
        if (!localName.equals("Description") || !namespaceURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            org.openrdf.model.URI className = null;
            className = "".equals(namespaceURI) ? this._buildResourceFromLocalName(localName) : this._createURI(namespaceURI + localName);
            this._reportStatement(nodeResource, this.RDF_TYPE, (Value)className);
        }
        if ((type = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type")) != null) {
            org.openrdf.model.URI className = this._buildURIFromReference(type.getValue());
            this._reportStatement(nodeResource, this.RDF_TYPE, (Value)className);
        }
        if (this._verifyData) {
            this._checkRdfAtts(atts);
        }
        this._processSubjectAtts(nodeElement, atts);
        if (!isEmptyElt) {
            this._elementStack.push(nodeElement);
        }
    }

    private Resource _getNodeResource(Atts atts) throws SAXException {
        Att id = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        Att about = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
        Att nodeID = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        if (this._verifyData) {
            int definedAttsCount = 0;
            if (id != null) {
                ++definedAttsCount;
            }
            if (about != null) {
                ++definedAttsCount;
            }
            if (nodeID != null) {
                ++definedAttsCount;
            }
            if (definedAttsCount > 1) {
                this.sendError("Only one of the attributes rdf:ID, rdf:about or rdf:nodeID can be used here");
            }
        }
        Object result = null;
        result = id != null ? this._buildURIFromID(id.getValue()) : (about != null ? this._buildURIFromReference(about.getValue()) : (nodeID != null ? this._createBNode(nodeID.getValue()) : this._createBNode()));
        return result;
    }

    private void _processSubjectAtts(NodeElement nodeElt, Atts atts) throws SAXException {
        Resource subject = nodeElt.getResource();
        Iterator iter = atts.iterator();
        while (iter.hasNext()) {
            Att att = (Att)iter.next();
            org.openrdf.model.URI predicate = this._createURI(att.getURI());
            Literal lit = this._createLiteral(att.getValue(), this._xmlLang, null);
            this._reportStatement(subject, predicate, (Value)lit);
        }
    }

    private void _processPropertyElt(String namespaceURI, String localName, String qName, Atts atts, boolean isEmptyElt) throws SAXException {
        Att parseType;
        if (this._verifyData) {
            this._checkPropertyEltName(namespaceURI, localName, qName);
        }
        org.openrdf.model.URI propURI = null;
        if (namespaceURI.equals("")) {
            this.sendError("unqualified property element <" + qName + "> not allowed");
            propURI = this._buildResourceFromLocalName(localName);
        } else {
            propURI = this._createURI(namespaceURI + localName);
        }
        if (propURI.equals(this.RDF_LI)) {
            NodeElement subject = (NodeElement)this._peekStack(0);
            propURI = this._createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + subject.getNextLiCounter());
        }
        PropertyElement predicate = new PropertyElement(propURI);
        this._elementStack.push(predicate);
        Att id = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        if (id != null) {
            org.openrdf.model.URI reifURI = this._buildURIFromID(id.getValue());
            predicate.setReificationURI(reifURI);
        }
        if ((parseType = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType")) != null) {
            String parseTypeValue;
            if (this._verifyData) {
                this._checkNoMoreAtts(atts);
            }
            if ((parseTypeValue = parseType.getValue()).equals("Resource")) {
                BNode objectResource = this._createBNode();
                NodeElement subject = (NodeElement)this._peekStack(1);
                this._reportStatement(subject.getResource(), propURI, (Value)objectResource);
                if (isEmptyElt) {
                    this._handleReification((Value)objectResource);
                } else {
                    NodeElement object = new NodeElement((Resource)objectResource);
                    object.setIsVolatile(true);
                    this._elementStack.push(object);
                }
            } else if (parseTypeValue.equals("Collection")) {
                if (isEmptyElt) {
                    NodeElement subject = (NodeElement)this._peekStack(1);
                    this._reportStatement(subject.getResource(), propURI, (Value)this.RDF_NIL);
                    this._handleReification((Value)this.RDF_NIL);
                } else {
                    predicate.setParseCollection(true);
                }
            } else {
                if (!parseTypeValue.equals("Literal")) {
                    this.sendWarning("unknown parseType: " + parseType.getValue());
                }
                if (isEmptyElt) {
                    NodeElement subject = (NodeElement)this._peekStack(1);
                    Literal lit = this._createLiteral("", null, "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
                    this._reportStatement(subject.getResource(), propURI, (Value)lit);
                    this._handleReification((Value)lit);
                } else {
                    predicate.setDatatype("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
                    this._saxFilter.setParseLiteralMode();
                }
            }
        } else if (isEmptyElt) {
            Att datatype = atts.getAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
            if (atts.size() == 0 || atts.size() == 1 && datatype != null) {
                NodeElement subject = (NodeElement)this._peekStack(1);
                Literal lit = datatype == null ? this._createLiteral("", this._xmlLang, null) : this._createLiteral("", null, datatype.getValue());
                this._reportStatement(subject.getResource(), propURI, (Value)lit);
                this._handleReification((Value)lit);
            } else {
                Resource resourceRes = this._getPropertyResource(atts);
                if (this._verifyData) {
                    this._checkRdfAtts(atts);
                }
                NodeElement resourceElt = new NodeElement(resourceRes);
                NodeElement subject = (NodeElement)this._peekStack(1);
                this._reportStatement(subject.getResource(), propURI, (Value)resourceRes);
                this._handleReification((Value)resourceRes);
                Att type = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
                if (type != null) {
                    org.openrdf.model.URI className = this._buildURIFromReference(type.getValue());
                    this._reportStatement(resourceRes, this.RDF_TYPE, (Value)className);
                }
                this._processSubjectAtts(resourceElt, atts);
            }
        } else {
            Att datatype = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
            if (datatype != null) {
                predicate.setDatatype(datatype.getValue());
            }
            if (this._verifyData) {
                this._checkNoMoreAtts(atts);
            }
        }
        if (isEmptyElt) {
            this._elementStack.pop();
        }
    }

    private Resource _getPropertyResource(Atts atts) throws SAXException {
        Att resource = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
        Att nodeID = atts.removeAtt("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        if (this._verifyData) {
            int definedAttsCount = 0;
            if (resource != null) {
                ++definedAttsCount;
            }
            if (nodeID != null) {
                ++definedAttsCount;
            }
            if (definedAttsCount > 1) {
                this.sendError("Only one of the attributes rdf:resource or rdf:nodeID can be used here");
            }
        }
        Object result = null;
        result = resource != null ? this._buildURIFromReference(resource.getValue()) : (nodeID != null ? this._createBNode(nodeID.getValue()) : this._createBNode());
        return result;
    }

    private void _handleReification(Value value) throws SAXException {
        PropertyElement predicate = (PropertyElement)this._peekStack(0);
        if (predicate.isReified()) {
            NodeElement subject = (NodeElement)this._peekStack(1);
            org.openrdf.model.URI reifRes = predicate.getReificationURI();
            this._reifyStatement((Resource)reifRes, subject.getResource(), predicate.getURI(), value);
        }
    }

    private void _reifyStatement(Resource reifNode, Resource subj, org.openrdf.model.URI pred, Value obj) throws SAXException {
        this._reportStatement(reifNode, this.RDF_TYPE, (Value)this.RDF_STATEMENT);
        this._reportStatement(reifNode, this.RDF_SUBJECT, (Value)subj);
        this._reportStatement(reifNode, this.RDF_PREDICATE, (Value)pred);
        this._reportStatement(reifNode, this.RDF_OBJECT, obj);
    }

    private org.openrdf.model.URI _buildResourceFromLocalName(String localName) throws SAXException {
        String uriString = this._baseURI.resolve("#" + localName).toString();
        return this._createURI(uriString);
    }

    private org.openrdf.model.URI _buildURIFromID(String id) throws SAXException {
        if (this._verifyData && !XmlUtil.isNCName((String)id)) {
            this.sendError("Not an XML Name: " + id);
        }
        String uriString = this._baseURI.resolve("#" + id).toString();
        if (this._verifyData && !this._usedIDs.add(uriString)) {
            this.sendError("ID '" + id + "' has already been defined");
        }
        return this._createURI(uriString);
    }

    private org.openrdf.model.URI _buildURIFromReference(String uriReference) throws SAXException {
        URI relUri = new URI(uriReference);
        if (this._verifyData && relUri.isRelative() && !relUri.isSelfReference() && this._baseURI.isOpaque()) {
            this.sendError("Relative URI '" + uriReference + "' cannot be resolved using the opaque base URI '" + this._baseURI + "'");
        }
        String uriString = this._baseURI.resolve(relUri).toString();
        return this._createURI(uriString);
    }

    private org.openrdf.model.URI _createURI(String uri) throws SAXException {
        try {
            return this._valueFactory.createURI(uri);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private BNode _createBNode() throws SAXException {
        try {
            return this._valueFactory.createBNode();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private BNode _createBNode(String nodeID) throws SAXException {
        BNode result;
        if (this._verifyData && !XmlUtil.isNCName((String)nodeID)) {
            this.sendError("Not an XML Name: " + nodeID);
        }
        if ((result = (BNode)this._bNodeIdMap.get(nodeID)) == null) {
            try {
                result = this._preserveBNodeIds ? this._valueFactory.createBNode(nodeID) : this._valueFactory.createBNode();
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            this._bNodeIdMap.put(nodeID, result);
        }
        return result;
    }

    private Literal _createLiteral(String label, String lang, String datatype) throws SAXException {
        org.openrdf.model.URI dtURI = null;
        if (datatype != null) {
            if (this._datatypeHandling == 20) {
                if (!XmlDatatypeUtil.isValidValue((String)label, (String)datatype)) {
                    this.sendError("'" + label + "' is not a valid value for datatype " + datatype);
                }
            } else if (this._datatypeHandling == 30) {
                try {
                    label = XmlDatatypeUtil.normalize((String)label, (String)datatype);
                }
                catch (IllegalArgumentException e) {
                    this.sendError("'" + label + "' is not a valid value for datatype " + datatype + ": " + e.getMessage());
                }
            }
            dtURI = this._createURI(datatype);
        }
        try {
            if (dtURI != null) {
                return this._valueFactory.createLiteral(label, dtURI);
            }
            if (lang != null) {
                return this._valueFactory.createLiteral(label, lang);
            }
            return this._valueFactory.createLiteral(label);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private Object _peekStack(int distFromTop) {
        return this._elementStack.get(this._elementStack.size() - 1 - distFromTop);
    }

    private boolean _topIsProperty() {
        return this._elementStack.isEmpty() || this._peekStack(0) instanceof PropertyElement;
    }

    private void _checkNodeEltName(String namespaceURI, String localName, String qName) throws SAXException {
        if (!(!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespaceURI) || localName.equals("Description") || localName.equals("Seq") || localName.equals("Bag") || localName.equals("Alt") || localName.equals("Statement") || localName.equals("Property") || localName.equals("List") || localName.equals("subject") || localName.equals("predicate") || localName.equals("object") || localName.equals("type") || localName.equals("value") || localName.equals("first") || localName.equals("rest") || localName.equals("nil") || localName.startsWith("_"))) {
            if (localName.equals("li") || localName.equals("RDF") || localName.equals("ID") || localName.equals("about") || localName.equals("parseType") || localName.equals("resource") || localName.equals("nodeID") || localName.equals("datatype")) {
                this.sendError("<" + qName + "> not allowed as node element");
            } else if (localName.equals("bagID") || localName.equals("aboutEach") || localName.equals("aboutEachPrefix")) {
                this.sendError(qName + " is no longer a valid RDF name");
            } else {
                this.sendWarning("unknown rdf element <" + qName + ">");
            }
        }
    }

    private void _checkPropertyEltName(String namespaceURI, String localName, String qName) throws SAXException {
        if (!(!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespaceURI) || localName.equals("li") || localName.equals("Seq") || localName.equals("Bag") || localName.equals("Alt") || localName.equals("Statement") || localName.equals("Property") || localName.equals("List") || localName.equals("subject") || localName.equals("predicate") || localName.equals("object") || localName.equals("type") || localName.equals("value") || localName.equals("first") || localName.equals("rest") || localName.equals("nil") || localName.startsWith("_"))) {
            if (localName.equals("Description") || localName.equals("RDF") || localName.equals("ID") || localName.equals("about") || localName.equals("parseType") || localName.equals("resource") || localName.equals("nodeID") || localName.equals("datatype")) {
                this.sendError("<" + qName + "> not allowed as property element");
            } else if (localName.equals("bagID") || localName.equals("aboutEach") || localName.equals("aboutEachPrefix")) {
                this.sendError(qName + " is no longer a valid RDF name");
            } else {
                this.sendWarning("unknown rdf element <" + qName + ">");
            }
        }
    }

    private void _checkRdfAtts(Atts atts) throws SAXException {
        Iterator iter = atts.iterator();
        while (iter.hasNext()) {
            String localName;
            Att att = (Att)iter.next();
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(att.getNamespace()) || (localName = att.getLocalName()).equals("Seq") || localName.equals("Bag") || localName.equals("Alt") || localName.equals("Statement") || localName.equals("Property") || localName.equals("List") || localName.equals("subject") || localName.equals("predicate") || localName.equals("object") || localName.equals("type") || localName.equals("value") || localName.equals("first") || localName.equals("rest") || localName.equals("nil") || localName.startsWith("_")) continue;
            if (localName.equals("Description") || localName.equals("li") || localName.equals("RDF") || localName.equals("ID") || localName.equals("about") || localName.equals("parseType") || localName.equals("resource") || localName.equals("nodeID") || localName.equals("datatype")) {
                this.sendError("'" + att.getQName() + "' not allowed as attribute name");
                iter.remove();
                continue;
            }
            if (localName.equals("bagID") || localName.equals("aboutEach") || localName.equals("aboutEachPrefix")) {
                this.sendError(att.getQName() + " is no longer a valid RDF name");
                continue;
            }
            this.sendWarning("unknown rdf attribute '" + att.getQName() + "'");
        }
    }

    private void _checkNoMoreAtts(Atts atts) throws SAXException {
        if (atts.size() > 0) {
            Iterator iter = atts.iterator();
            while (iter.hasNext()) {
                Att att = (Att)iter.next();
                this.sendError("unexpected attribute '" + att.getQName() + "'");
                iter.remove();
            }
        }
    }

    private void _reportStatement(Resource subject, org.openrdf.model.URI predicate, Value object) throws SAXException {
        try {
            this._statementHandler.handleStatement(subject, predicate, object);
        }
        catch (StatementHandlerException e) {
            throw new SAXException(e);
        }
    }

    void sendWarning(String msg) {
        if (this._errorListener != null) {
            Locator loc = this._saxFilter.getLocator();
            if (loc == null) {
                this._errorListener.warning(msg, -1, -1);
            } else {
                this._errorListener.warning(msg, loc.getLineNumber(), loc.getColumnNumber());
            }
        }
    }

    void sendError(String msg) throws SAXException {
        if (this._errorListener != null) {
            Locator loc = this._saxFilter.getLocator();
            if (loc == null) {
                this._errorListener.error(msg, -1, -1);
            } else {
                this._errorListener.error(msg, loc.getLineNumber(), loc.getColumnNumber());
            }
        }
        if (this._stopAtFirstError) {
            throw new SAXException(msg);
        }
    }

    void sendFatalError(String msg) throws SAXException {
        if (this._errorListener != null) {
            Locator loc = this._saxFilter.getLocator();
            if (loc == null) {
                this._errorListener.fatalError(msg, -1, -1);
            } else {
                this._errorListener.fatalError(msg, loc.getLineNumber(), loc.getColumnNumber());
            }
        }
        throw new SAXException(msg);
    }

    static class PropertyElement {
        private org.openrdf.model.URI _uri;
        private org.openrdf.model.URI _reificationURI;
        private String _datatype;
        private boolean _parseCollection = false;
        private Resource _lastListResource;

        public PropertyElement(org.openrdf.model.URI uri) {
            this._uri = uri;
        }

        public org.openrdf.model.URI getURI() {
            return this._uri;
        }

        public boolean isReified() {
            return this._reificationURI != null;
        }

        public void setReificationURI(org.openrdf.model.URI reifURI) {
            this._reificationURI = reifURI;
        }

        public org.openrdf.model.URI getReificationURI() {
            return this._reificationURI;
        }

        public void setDatatype(String datatype) {
            this._datatype = datatype;
        }

        public String getDatatype() {
            return this._datatype;
        }

        public boolean parseCollection() {
            return this._parseCollection;
        }

        public void setParseCollection(boolean parseCollection) {
            this._parseCollection = parseCollection;
        }

        public Resource getLastListResource() {
            return this._lastListResource;
        }

        public void setLastListResource(Resource resource) {
            this._lastListResource = resource;
        }
    }

    static class NodeElement {
        private Resource _resource;
        private boolean _isVolatile = false;
        private int _liCounter = 1;

        public NodeElement(Resource resource) {
            this._resource = resource;
        }

        public Resource getResource() {
            return this._resource;
        }

        public void setIsVolatile(boolean isVolatile) {
            this._isVolatile = isVolatile;
        }

        public boolean isVolatile() {
            return this._isVolatile;
        }

        public int getNextLiCounter() {
            return this._liCounter++;
        }
    }
}

