/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.util.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactory<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyFactory.class);
    private final Class<T> genericType;
    private final TypedObjectFactory<T> objectFactory;

    private ProxyFactory(TypedObjectFactory<T> objectFactory, Class<T> genericType) {
        Validate.notNull(objectFactory);
        Validate.notNull(genericType);
        this.objectFactory = objectFactory;
        this.genericType = genericType;
    }

    public static <T> T proxy(TypedObjectFactory<T> objectFactory, Class<T> genericType) {
        try {
            return super.create();
        }
        catch (RuntimeException e) {
            LOG.error("exception", (Throwable)e);
            throw e;
        }
    }

    private T create() {
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke(ProxyFactory.this.objectFactory.create(), args);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getCause();
                }
            }
        };
        LOG.debug("genericType: {}", this.genericType);
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), this.getInterfacesSet().toArray(new Class[0]), handler);
    }

    private Set<Class<?>> getInterfacesSet() {
        Class<?>[] classes;
        HashSet set = new HashSet();
        if (this.genericType.isInterface()) {
            set.add(this.genericType);
        }
        for (Class<?> clazz : classes = this.objectFactory.getObjectClass().getInterfaces()) {
            set.add(clazz);
        }
        LOG.debug("interfaces set: {}", set);
        return set;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TypedObjectFactory<T>
    extends ObjectFactory<T> {
        public Class<? extends T> getObjectClass();
    }
}

