/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.geom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geojson.geom.GeometryHandlerBase;
import org.json.simple.parser.ParseException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class MultiLineHandler
extends GeometryHandlerBase<MultiLineString> {
    List<Coordinate> coordinates;
    List<Coordinate[]> lines;

    public MultiLineHandler(GeometryFactory factory) {
        super(factory);
    }

    @Override
    public boolean startObjectEntry(String key) throws ParseException, IOException {
        if ("coordinates".equals(key)) {
            this.lines = new ArrayList<Coordinate[]>();
        }
        return true;
    }

    @Override
    public boolean startArray() throws ParseException, IOException {
        if (this.coordinates == null) {
            this.coordinates = new ArrayList<Coordinate>();
        } else if (this.ordinates == null) {
            this.ordinates = new ArrayList();
        }
        return true;
    }

    @Override
    public boolean endArray() throws ParseException, IOException {
        if (this.ordinates != null) {
            this.coordinates.add(this.coordinate(this.ordinates));
            this.ordinates = null;
        } else if (this.coordinates != null) {
            this.lines.add(this.coordinates(this.coordinates));
            this.coordinates = null;
        }
        return true;
    }

    @Override
    public boolean endObject() throws ParseException, IOException {
        if (this.lines != null) {
            LineString[] lineStrings = new LineString[this.lines.size()];
            for (int i = 0; i < this.lines.size(); ++i) {
                lineStrings[i] = this.factory.createLineString(this.lines.get(i));
            }
            this.value = this.factory.createMultiLineString(lineStrings);
            this.lines = null;
        }
        return true;
    }
}

