/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.feature;

import java.io.IOException;
import org.geotools.geojson.HandlerBase;
import org.geotools.geojson.IContentHandler;
import org.geotools.referencing.CRS;
import org.json.simple.parser.ParseException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSHandler
extends HandlerBase
implements IContentHandler<CoordinateReferenceSystem> {
    CoordinateReferenceSystem crs;
    int state = 0;

    @Override
    public boolean startObjectEntry(String key) throws ParseException, IOException {
        if ("properties".equals(key)) {
            this.state = 1;
        } else if (("name".equals(key) || "code".equals(key)) && this.state == 1) {
            this.state = 2;
        }
        return true;
    }

    @Override
    public boolean primitive(Object value) throws ParseException, IOException {
        if (this.state == 2) {
            try {
                try {
                    this.crs = CRS.decode(value.toString());
                }
                catch (NoSuchAuthorityCodeException e) {
                    try {
                        this.crs = CRS.decode("EPSG:" + value.toString());
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                throw (IOException)new IOException("Error parsing " + value + " as crs id").initCause(e);
            }
            this.state = -1;
        }
        return true;
    }

    @Override
    public CoordinateReferenceSystem getValue() {
        return this.crs;
    }
}

