/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.PathExtensionContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodArgumentResolver;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractMessageConverterMethodProcessor
extends AbstractMessageConverterMethodArgumentResolver
implements HandlerMethodReturnValueHandler {
    private static final MediaType MEDIA_TYPE_APPLICATION = new MediaType("application");
    private static final UrlPathHelper RAW_URL_PATH_HELPER = new UrlPathHelper();
    private static final UrlPathHelper DECODING_URL_PATH_HELPER = new UrlPathHelper();
    private static final Set<String> WHITELISTED_EXTENSIONS;
    private static final Set<String> WHITELISTED_MEDIA_BASE_TYPES;
    private final ContentNegotiationManager contentNegotiationManager;
    private final PathExtensionContentNegotiationStrategy pathStrategy;
    private final Set<String> safeExtensions = new HashSet<String>();

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> converters) {
        this(converters, (ContentNegotiationManager)null);
    }

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> converters, ContentNegotiationManager contentNegotiationManager) {
        this(converters, contentNegotiationManager, null);
    }

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> converters, ContentNegotiationManager manager, List<Object> requestResponseBodyAdvice) {
        super(converters, requestResponseBodyAdvice);
        this.contentNegotiationManager = manager != null ? manager : new ContentNegotiationManager();
        this.pathStrategy = AbstractMessageConverterMethodProcessor.initPathStrategy(this.contentNegotiationManager);
        this.safeExtensions.addAll(this.contentNegotiationManager.getAllFileExtensions());
        this.safeExtensions.addAll(WHITELISTED_EXTENSIONS);
    }

    private static PathExtensionContentNegotiationStrategy initPathStrategy(ContentNegotiationManager manager) {
        Class<PathExtensionContentNegotiationStrategy> clazz = PathExtensionContentNegotiationStrategy.class;
        PathExtensionContentNegotiationStrategy strategy = (PathExtensionContentNegotiationStrategy)manager.getStrategy(clazz);
        return strategy != null ? strategy : new PathExtensionContentNegotiationStrategy();
    }

    protected ServletServerHttpResponse createOutputMessage(NativeWebRequest webRequest) {
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        return new ServletServerHttpResponse(response);
    }

    protected <T> void writeWithMessageConverters(T returnValue, MethodParameter returnType, NativeWebRequest webRequest) throws IOException, HttpMediaTypeNotAcceptableException, HttpMessageNotWritableException {
        ServletServerHttpRequest inputMessage = this.createInputMessage(webRequest);
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        this.writeWithMessageConverters(returnValue, returnType, inputMessage, outputMessage);
    }

    protected <T> void writeWithMessageConverters(T value, MethodParameter returnType, ServletServerHttpRequest inputMessage, ServletServerHttpResponse outputMessage) throws IOException, HttpMediaTypeNotAcceptableException, HttpMessageNotWritableException {
        Class<Object> clazz = this.getReturnValueType(value, returnType);
        Object type = this.getGenericType(returnType);
        if (value != null && value instanceof CharSequence) {
            clazz = String.class;
            type = String.class;
            value = value.toString();
        }
        HttpServletRequest servletRequest = inputMessage.getServletRequest();
        List<MediaType> requestedMediaTypes = this.getAcceptableMediaTypes(servletRequest);
        List<MediaType> producibleMediaTypes = this.getProducibleMediaTypes(servletRequest, clazz, (Type)type);
        if (value != null && producibleMediaTypes.isEmpty()) {
            throw new IllegalArgumentException("No converter found for return value of type: " + clazz);
        }
        LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
        for (MediaType requestedType : requestedMediaTypes) {
            for (MediaType producibleType : producibleMediaTypes) {
                if (!requestedType.isCompatibleWith(producibleType)) continue;
                compatibleMediaTypes.add(this.getMostSpecificMediaType(requestedType, producibleType));
            }
        }
        if (compatibleMediaTypes.isEmpty()) {
            if (value != null) {
                throw new HttpMediaTypeNotAcceptableException(producibleMediaTypes);
            }
            return;
        }
        ArrayList mediaTypes = new ArrayList(compatibleMediaTypes);
        MediaType.sortBySpecificityAndQuality(mediaTypes);
        MediaType selectedMediaType = null;
        for (MediaType mediaType : mediaTypes) {
            if (mediaType.isConcrete()) {
                selectedMediaType = mediaType;
                break;
            }
            if (!mediaType.equals((Object)MediaType.ALL) && !mediaType.equals((Object)MEDIA_TYPE_APPLICATION)) continue;
            selectedMediaType = MediaType.APPLICATION_OCTET_STREAM;
            break;
        }
        if (selectedMediaType != null) {
            selectedMediaType = selectedMediaType.removeQualityValue();
            for (HttpMessageConverter messageConverter : this.messageConverters) {
                if (messageConverter instanceof GenericHttpMessageConverter) {
                    if (!((GenericHttpMessageConverter)messageConverter).canWrite((Type)type, clazz, selectedMediaType)) continue;
                    value = this.getAdvice().beforeBodyWrite(value, returnType, selectedMediaType, (Class<? extends HttpMessageConverter<?>>)messageConverter.getClass(), (ServerHttpRequest)inputMessage, (ServerHttpResponse)outputMessage);
                    if (value != null) {
                        this.addContentDispositionHeader(inputMessage, outputMessage);
                        ((GenericHttpMessageConverter)messageConverter).write(value, (Type)type, selectedMediaType, (HttpOutputMessage)outputMessage);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Written [" + value + "] as \"" + selectedMediaType + "\" using [" + messageConverter + "]"));
                        }
                    }
                    return;
                }
                if (!messageConverter.canWrite(clazz, selectedMediaType)) continue;
                value = this.getAdvice().beforeBodyWrite(value, returnType, selectedMediaType, (Class<? extends HttpMessageConverter<?>>)messageConverter.getClass(), (ServerHttpRequest)inputMessage, (ServerHttpResponse)outputMessage);
                if (value != null) {
                    this.addContentDispositionHeader(inputMessage, outputMessage);
                    messageConverter.write(value, selectedMediaType, (HttpOutputMessage)outputMessage);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Written [" + value + "] as \"" + selectedMediaType + "\" using [" + messageConverter + "]"));
                    }
                }
                return;
            }
        }
        if (value != null) {
            throw new HttpMediaTypeNotAcceptableException(this.allSupportedMediaTypes);
        }
    }

    protected Class<?> getReturnValueType(Object returnValue, MethodParameter returnType) {
        return returnValue != null ? returnValue.getClass() : returnType.getParameterType();
    }

    private Type getGenericType(MethodParameter returnType) {
        Type type;
        if (HttpEntity.class.isAssignableFrom(returnType.getParameterType())) {
            returnType.increaseNestingLevel();
            type = returnType.getNestedGenericParameterType();
        } else {
            type = returnType.getGenericParameterType();
        }
        return type;
    }

    protected List<MediaType> getProducibleMediaTypes(HttpServletRequest request, Class<?> returnValueClass) {
        return this.getProducibleMediaTypes(request, returnValueClass, null);
    }

    protected List<MediaType> getProducibleMediaTypes(HttpServletRequest request, Class<?> returnValueClass, Type returnValueType) {
        Set mediaTypes = (Set)request.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        if (!CollectionUtils.isEmpty((Collection)mediaTypes)) {
            return new ArrayList<MediaType>(mediaTypes);
        }
        if (!this.allSupportedMediaTypes.isEmpty()) {
            ArrayList<MediaType> result = new ArrayList<MediaType>();
            for (HttpMessageConverter converter : this.messageConverters) {
                if (converter instanceof GenericHttpMessageConverter && returnValueType != null) {
                    if (!((GenericHttpMessageConverter)converter).canWrite(returnValueType, returnValueClass, null)) continue;
                    result.addAll(converter.getSupportedMediaTypes());
                    continue;
                }
                if (!converter.canWrite(returnValueClass, null)) continue;
                result.addAll(converter.getSupportedMediaTypes());
            }
            return result;
        }
        return Collections.singletonList(MediaType.ALL);
    }

    private List<MediaType> getAcceptableMediaTypes(HttpServletRequest request) throws HttpMediaTypeNotAcceptableException {
        List<MediaType> mediaTypes = this.contentNegotiationManager.resolveMediaTypes((NativeWebRequest)new ServletWebRequest(request));
        return mediaTypes.isEmpty() ? Collections.singletonList(MediaType.ALL) : mediaTypes;
    }

    private MediaType getMostSpecificMediaType(MediaType acceptType, MediaType produceType) {
        MediaType produceTypeToUse = produceType.copyQualityValue(acceptType);
        return MediaType.SPECIFICITY_COMPARATOR.compare(acceptType, produceTypeToUse) <= 0 ? acceptType : produceTypeToUse;
    }

    private void addContentDispositionHeader(ServletServerHttpRequest request, ServletServerHttpResponse response) {
        HttpHeaders headers = response.getHeaders();
        if (headers.containsKey((Object)"Content-Disposition")) {
            return;
        }
        try {
            int status = response.getServletResponse().getStatus();
            if (status < 200 || status > 299) {
                return;
            }
        }
        catch (Throwable status) {
            // empty catch block
        }
        HttpServletRequest servletRequest = request.getServletRequest();
        String requestUri = RAW_URL_PATH_HELPER.getOriginatingRequestUri(servletRequest);
        int index = requestUri.lastIndexOf(47) + 1;
        String filename = requestUri.substring(index);
        String pathParams = "";
        index = filename.indexOf(59);
        if (index != -1) {
            pathParams = filename.substring(index);
            filename = filename.substring(0, index);
        }
        filename = DECODING_URL_PATH_HELPER.decodeRequestString(servletRequest, filename);
        String ext = StringUtils.getFilenameExtension((String)filename);
        pathParams = DECODING_URL_PATH_HELPER.decodeRequestString(servletRequest, pathParams);
        String extInPathParams = StringUtils.getFilenameExtension((String)pathParams);
        if (!this.safeExtension(servletRequest, ext) || !this.safeExtension(servletRequest, extInPathParams)) {
            headers.add("Content-Disposition", "inline;filename=f.txt");
        }
    }

    private boolean safeExtension(HttpServletRequest request, String extension) {
        String name;
        Set mediaTypes;
        if (!StringUtils.hasText((String)extension)) {
            return true;
        }
        if (this.safeExtensions.contains(extension = extension.toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        String pattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (pattern != null && pattern.endsWith("." + extension)) {
            return true;
        }
        if (extension.equals("html") && !CollectionUtils.isEmpty((Collection)(mediaTypes = (Set)request.getAttribute(name = HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE))) && mediaTypes.contains(MediaType.TEXT_HTML)) {
            return true;
        }
        return this.safeMediaTypesForExtension(extension);
    }

    private boolean safeMediaTypesForExtension(String extension) {
        List mediaTypes = null;
        try {
            mediaTypes = this.pathStrategy.resolveMediaTypeKey(null, extension);
        }
        catch (HttpMediaTypeNotAcceptableException httpMediaTypeNotAcceptableException) {
            // empty catch block
        }
        if (CollectionUtils.isEmpty(mediaTypes)) {
            return false;
        }
        for (MediaType mediaType : mediaTypes) {
            if (this.safeMediaType(mediaType)) continue;
            return false;
        }
        return true;
    }

    private boolean safeMediaType(MediaType mediaType) {
        return WHITELISTED_MEDIA_BASE_TYPES.contains(mediaType.getType()) || mediaType.getSubtype().endsWith("+xml");
    }

    static {
        RAW_URL_PATH_HELPER.setRemoveSemicolonContent(false);
        RAW_URL_PATH_HELPER.setUrlDecode(false);
        WHITELISTED_EXTENSIONS = new HashSet<String>(Arrays.asList("txt", "text", "yml", "properties", "csv", "json", "xml", "atom", "rss", "png", "jpe", "jpeg", "jpg", "gif", "wbmp", "bmp"));
        WHITELISTED_MEDIA_BASE_TYPES = new HashSet<String>(Arrays.asList("audio", "image", "video"));
    }
}

