/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.i18n;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.LocaleResolver;

public class AcceptHeaderLocaleResolver
implements LocaleResolver {
    private final List<Locale> supportedLocales = new ArrayList<Locale>(4);
    private Locale defaultLocale;

    public void setSupportedLocales(List<Locale> locales) {
        this.supportedLocales.clear();
        if (locales != null) {
            this.supportedLocales.addAll(locales);
        }
    }

    public List<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public Locale resolveLocale(HttpServletRequest request) {
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale != null && request.getHeader("Accept-Language") == null) {
            return defaultLocale;
        }
        Locale locale = request.getLocale();
        if (!this.isSupportedLocale(locale)) {
            locale = this.findSupportedLocale(request, locale);
        }
        return locale;
    }

    private boolean isSupportedLocale(Locale locale) {
        List<Locale> supportedLocales = this.getSupportedLocales();
        return supportedLocales.isEmpty() || supportedLocales.contains(locale);
    }

    private Locale findSupportedLocale(HttpServletRequest request, Locale fallback) {
        Enumeration requestLocales = request.getLocales();
        while (requestLocales.hasMoreElements()) {
            Locale locale = (Locale)requestLocales.nextElement();
            if (!this.getSupportedLocales().contains(locale)) continue;
            return locale;
        }
        return fallback;
    }

    @Override
    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        throw new UnsupportedOperationException("Cannot change HTTP accept header - use a different locale resolution strategy");
    }
}

