/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.springframework.http.HttpHeaders;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public class StandardMultipartHttpServletRequest
extends AbstractMultipartHttpServletRequest {
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final String FILENAME_KEY = "filename=";
    private static final String FILENAME_WITH_CHARSET_KEY = "filename*=";
    private static final Charset US_ASCII = Charset.forName("us-ascii");
    private Set<String> multipartParameterNames;

    public StandardMultipartHttpServletRequest(HttpServletRequest request) throws MultipartException {
        this(request, false);
    }

    public StandardMultipartHttpServletRequest(HttpServletRequest request, boolean lazyParsing) throws MultipartException {
        super(request);
        if (!lazyParsing) {
            this.parseRequest(request);
        }
    }

    private void parseRequest(HttpServletRequest request) {
        try {
            Collection parts = request.getParts();
            this.multipartParameterNames = new LinkedHashSet<String>(parts.size());
            LinkedMultiValueMap files = new LinkedMultiValueMap(parts.size());
            for (Part part : parts) {
                String disposition = part.getHeader(CONTENT_DISPOSITION);
                String filename = this.extractFilename(disposition);
                if (filename == null) {
                    filename = this.extractFilenameWithCharset(disposition);
                }
                if (filename != null) {
                    files.add((Object)part.getName(), (Object)new StandardMultipartFile(part, filename));
                    continue;
                }
                this.multipartParameterNames.add(part.getName());
            }
            this.setMultipartFiles((MultiValueMap<String, MultipartFile>)files);
        }
        catch (Exception ex) {
            throw new MultipartException("Could not parse multipart servlet request", ex);
        }
    }

    private String extractFilename(String contentDisposition) {
        return this.extractFilename(contentDisposition, FILENAME_KEY);
    }

    private String extractFilename(String contentDisposition, String key) {
        if (contentDisposition == null) {
            return null;
        }
        int startIndex = contentDisposition.indexOf(key);
        if (startIndex == -1) {
            return null;
        }
        String filename = contentDisposition.substring(startIndex + key.length());
        if (filename.startsWith("\"")) {
            int endIndex = filename.indexOf("\"", 1);
            if (endIndex != -1) {
                return filename.substring(1, endIndex);
            }
        } else {
            int endIndex = filename.indexOf(";");
            if (endIndex != -1) {
                return filename.substring(0, endIndex);
            }
        }
        return filename;
    }

    private String extractFilenameWithCharset(String contentDisposition) {
        String filename = this.extractFilename(contentDisposition, FILENAME_WITH_CHARSET_KEY);
        if (filename == null) {
            return null;
        }
        int index = filename.indexOf("'");
        if (index != -1) {
            Charset charset = null;
            try {
                charset = Charset.forName(filename.substring(0, index));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            filename = filename.substring(index + 1);
            index = filename.indexOf("'");
            if (index != -1) {
                filename = filename.substring(index + 1);
            }
            if (charset != null) {
                filename = new String(filename.getBytes(US_ASCII), charset);
            }
        }
        return filename;
    }

    @Override
    protected void initializeMultipart() {
        this.parseRequest(this.getRequest());
    }

    public Enumeration<String> getParameterNames() {
        if (this.multipartParameterNames == null) {
            this.initializeMultipart();
        }
        if (this.multipartParameterNames.isEmpty()) {
            return super.getParameterNames();
        }
        LinkedHashSet paramNames = new LinkedHashSet();
        Enumeration paramEnum = super.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            paramNames.add(paramEnum.nextElement());
        }
        paramNames.addAll(this.multipartParameterNames);
        return Collections.enumeration(paramNames);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.multipartParameterNames == null) {
            this.initializeMultipart();
        }
        if (this.multipartParameterNames.isEmpty()) {
            return super.getParameterMap();
        }
        LinkedHashMap<String, String[]> paramMap = new LinkedHashMap<String, String[]>();
        paramMap.putAll(super.getParameterMap());
        for (String paramName : this.multipartParameterNames) {
            if (paramMap.containsKey(paramName)) continue;
            paramMap.put(paramName, this.getParameterValues(paramName));
        }
        return paramMap;
    }

    @Override
    public String getMultipartContentType(String paramOrFileName) {
        try {
            Part part = this.getPart(paramOrFileName);
            return part != null ? part.getContentType() : null;
        }
        catch (Exception ex) {
            throw new MultipartException("Could not access multipart servlet request", ex);
        }
    }

    @Override
    public HttpHeaders getMultipartHeaders(String paramOrFileName) {
        try {
            Part part = this.getPart(paramOrFileName);
            if (part != null) {
                HttpHeaders headers = new HttpHeaders();
                for (String headerName : part.getHeaderNames()) {
                    headers.put(headerName, new ArrayList<String>(part.getHeaders(headerName)));
                }
                return headers;
            }
            return null;
        }
        catch (Exception ex) {
            throw new MultipartException("Could not access multipart servlet request", ex);
        }
    }

    private static class StandardMultipartFile
    implements MultipartFile,
    Serializable {
        private final Part part;
        private final String filename;

        public StandardMultipartFile(Part part, String filename) {
            this.part = part;
            this.filename = filename;
        }

        @Override
        public String getName() {
            return this.part.getName();
        }

        @Override
        public String getOriginalFilename() {
            return this.filename;
        }

        @Override
        public String getContentType() {
            return this.part.getContentType();
        }

        @Override
        public boolean isEmpty() {
            return this.part.getSize() == 0L;
        }

        @Override
        public long getSize() {
            return this.part.getSize();
        }

        @Override
        public byte[] getBytes() throws IOException {
            return FileCopyUtils.copyToByteArray((InputStream)this.part.getInputStream());
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        @Override
        public void transferTo(File dest) throws IOException, IllegalStateException {
            this.part.write(dest.getPath());
        }
    }
}

