/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.render.pdf.pdfbox.Cache;
import org.apache.fop.render.pdf.pdfbox.ImagePDF;
import org.apache.fop.render.pdf.pdfbox.Interceptors;
import org.apache.fop.render.pdf.pdfbox.PDFUtil;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.util.io.SubInputStream;

public class PreloaderPDF
extends AbstractImagePreloader {
    private static final String PDF_HEADER = "%PDF-";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo preloadImage(String uri, Source src, ImageContext context) throws IOException, ImageException {
        if (!ImageUtil.hasImageInputStream((Source)src)) {
            return null;
        }
        ImageInfo info = null;
        ImageInputStream in = ImageUtil.needImageInputStream((Source)src);
        in.mark();
        try {
            byte[] header = this.getHeader(in, PDF_HEADER.length());
            String s = new String(header, "US-ASCII");
            boolean supported = PDF_HEADER.equals(s);
            if (supported) {
                info = this.loadPDF(uri, src, context);
            }
            ImageInfo imageInfo = info;
            return imageInfo;
        }
        finally {
            if (info == null) {
                in.reset();
            }
        }
    }

    private static URI deriveDocumentURI(String uri) throws ImageException {
        try {
            URI originalURI = new URI(URISpecification.escapeURI((String)uri));
            URI tempURI = new URI(originalURI.getScheme(), originalURI.getSchemeSpecificPart(), null);
            return tempURI;
        }
        catch (URISyntaxException e) {
            throw new ImageException("Problem processing URI", (Throwable)e);
        }
    }

    private ImageInfo loadPDF(String uri, Source src, ImageContext context) throws IOException, ImageException {
        int selectedPage = ImageUtil.needPageIndexFromURI((String)uri);
        URI docURI = PreloaderPDF.deriveDocumentURI(src.getSystemId());
        PDDocument pddoc = this.getDocument(context, docURI, src);
        pddoc = Interceptors.getInstance().interceptOnLoad(pddoc, docURI);
        pddoc.getDocument().setWarnMissingClose(false);
        int pageCount = pddoc.getNumberOfPages();
        if (selectedPage < 0 || selectedPage >= pageCount) {
            throw new ImageException("Selected page (index: " + selectedPage + ") does not exist in the PDF file. The document has " + pddoc.getNumberOfPages() + " pages.");
        }
        PDPage page = pddoc.getPage(selectedPage);
        PDRectangle mediaBox = page.getMediaBox();
        PDRectangle cropBox = page.getCropBox();
        PDRectangle viewBox = cropBox != null ? cropBox : mediaBox;
        int w = Math.round(viewBox.getWidth() * 1000.0f);
        int h = Math.round(viewBox.getHeight() * 1000.0f);
        int rotation = PDFUtil.getNormalizedRotation(page);
        if (rotation == 90 || rotation == 270) {
            int exch = w;
            w = h;
            h = exch;
        }
        ImageSize size = new ImageSize();
        size.setSizeInMillipoints(w, h);
        size.setResolution((double)context.getSourceResolution());
        size.calcPixelsFromSize();
        ImageInfo info = new ImageInfo(uri, "application/pdf");
        info.setSize(size);
        info.getCustomObjects().put(ImageInfo.ORIGINAL_IMAGE, new ImagePDF(info, pddoc));
        int lastPageIndex = pddoc.getNumberOfPages() - 1;
        if (selectedPage < lastPageIndex) {
            info.getCustomObjects().put(ImageInfo.HAS_MORE_IMAGES, Boolean.TRUE);
        }
        return info;
    }

    private PDDocument getDocument(Object context, URI uri, Source src) throws IOException {
        try {
            return this.createDocumentMaker(src, uri).make();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Cache.ValueMaker<PDDocument> createDocumentMaker(Source src, URI docURI) {
        return new DocumentMaker(src, docURI);
    }

    static class DocumentMaker
    implements Cache.ValueMaker<PDDocument> {
        private Source src;
        private URI docURI;

        public DocumentMaker(Source src, URI docURI) {
            this.src = src;
            this.docURI = docURI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PDDocument make() throws Exception {
            InputStream in = ImageUtil.needInputStream((Source)this.src);
            try {
                PDDocument pddoc = PDDocument.load((InputStream)new SubInputStream(in, Integer.MAX_VALUE));
                PDDocument pDDocument = Interceptors.getInstance().interceptOnLoad(pddoc, this.docURI);
                return pDDocument;
            }
            finally {
                ImageUtil.closeQuietly((Source)this.src);
            }
        }
    }
}

