/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.fop.render.pdf.pdfbox.AbstractPDFBoxHandler;
import org.apache.fop.render.pdf.pdfbox.ImagePDF;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;

public class PDFBoxImageHandler
extends AbstractPDFBoxHandler
implements ImageHandler {
    protected static final Log log = LogFactory.getLog(PDFBoxImageHandler.class);
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImagePDF.PDFBOX_IMAGE};

    public void handleImage(RenderingContext context, Image image, Rectangle pos) throws IOException {
        assert (context instanceof PDFRenderingContext);
        PDFRenderingContext pdfContext = (PDFRenderingContext)context;
        PDFContentGenerator generator = pdfContext.getGenerator();
        assert (image instanceof ImagePDF);
        ImagePDF pdfImage = (ImagePDF)image;
        try {
            float x = (float)pos.getX() / 1000.0f;
            float y = (float)pos.getY() / 1000.0f;
            float h = (float)pos.getHeight() / 1000.0f;
            AffineTransform pageAdjust = new AffineTransform();
            AffineTransform at = generator.getAffineTransform();
            if (at != null) {
                pageAdjust.setToTranslation((float)generator.getState().getTransform().getTranslateX(), (float)(generator.getState().getTransform().getTranslateY() - (double)h - (double)y));
            }
            FontInfo fontinfo = (FontInfo)context.getHint((Object)"fontinfo");
            String stream = this.createStreamForPDF(pdfImage, pdfContext.getPage(), pdfContext.getUserAgent(), pageAdjust, fontinfo, pos, pdfContext.getPageNumbers(), pdfContext.getPdfLogicalStructureHandler(), pdfContext.getCurrentSessionStructElem());
            if (stream == null) {
                return;
            }
            if (pageAdjust.getScaleX() != 0.0) {
                pageAdjust.translate((double)x * (1.0 / pageAdjust.getScaleX()), (double)(-y) * (1.0 / -pageAdjust.getScaleY()));
            }
            generator.placeImage(pageAdjust, stream);
            pdfImage.close();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error on PDF page: " + pdfImage.getInfo().getOriginalURI() + " " + t.getMessage(), t);
        }
    }

    public boolean isCompatible(RenderingContext targetContext, Image image) {
        return (image == null || image instanceof ImagePDF) && targetContext instanceof PDFRenderingContext;
    }

    public int getPriority() {
        return 50;
    }

    public Class getSupportedImageClass() {
        return ImagePDF.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return (ImageFlavor[])FLAVORS.clone();
    }
}

