/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.fontbox.cff.CFFCharset;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.render.pdf.pdfbox.FOPPDFFont;
import org.apache.fop.render.pdf.pdfbox.FontContainer;
import org.apache.fop.render.pdf.pdfbox.MaximumProfileTable;
import org.apache.fop.render.pdf.pdfbox.MergeCFFFonts;
import org.apache.fop.render.pdf.pdfbox.MergeFonts;
import org.apache.fop.render.pdf.pdfbox.MergeTTFonts;
import org.apache.fop.util.CharUtilities;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.encoding.GlyphList;

public class FOPPDFMultiByteFont
extends MultiByteFont
implements FOPPDFFont {
    protected PDFDictionary ref;
    private Map<Integer, Integer> newWidth = new TreeMap<Integer, Integer>();
    private Map<String, Integer> charMapGlobal = new LinkedHashMap<String, Integer>();
    private MergeFonts mergeFonts;
    private final Map<COSDictionary, FontContainer> fontMap = new HashMap<COSDictionary, FontContainer>();

    public FOPPDFMultiByteFont(COSDictionary fontData, String name) throws IOException {
        super(null, EmbeddingMode.SUBSET);
        this.setEmbeddingMode(EmbeddingMode.FULL);
        this.readFontBBox((COSBase)fontData);
        this.setFontName(name);
        this.addFont(fontData);
        this.notifyMapOperation();
    }

    @Override
    public String addFont(COSDictionary fontData) throws IOException {
        FontContainer font = this.getFont(fontData);
        FOPPDFMultiByteFont.setProperties((CustomFont)this, font.font);
        PDCIDFont mainFont = null;
        TrueTypeFont ttf = null;
        if (font.font instanceof PDType0Font) {
            PDCIDFont cidFont = ((PDType0Font)font.font).getDescendantFont();
            int dw = cidFont.getCOSObject().getInt(COSName.DW);
            this.setDefaultWidth(dw);
            mainFont = cidFont;
            if (cidFont instanceof PDCIDFontType0) {
                this.setCIDType(CIDFontType.CIDTYPE0);
                this.setFontType(FontType.CIDTYPE0);
            } else {
                ttf = ((PDCIDFontType2)cidFont).getTrueTypeFont();
            }
        } else {
            ttf = ((PDTrueTypeFont)font.font).getTrueTypeFont();
            this.setDefaultWidth(1000);
        }
        GlyphData[] glyphData = new GlyphData[]{};
        if (ttf != null) {
            glyphData = ttf.getGlyph().getGlyphs();
        }
        HashMap<Integer, Integer> oldToNewGIMap = new HashMap<Integer, Integer>();
        if (this.charMapGlobal.isEmpty()) {
            oldToNewGIMap.put(0, 0);
        }
        CMap c = font.getToUnicodeCMap();
        Map<Integer, String> mapping = this.getMapping(font, c, glyphData.length);
        if (glyphData.length > 0) {
            this.differentGlyphData(glyphData, mapping);
        }
        TreeMap<Integer, String> gidToGlyph = new TreeMap<Integer, String>(mapping);
        if (font.font instanceof PDTrueTypeFont) {
            CmapSubtable cmap = ttf.getCmap().getCmaps()[0];
            gidToGlyph.clear();
            for (int i = 1; i < glyphData.length; ++i) {
                String mappedChar = mapping.get(cmap.getCharacterCode(i));
                gidToGlyph.put(i, mappedChar);
            }
        }
        this.readCharMap(font, gidToGlyph, glyphData, mainFont, oldToNewGIMap);
        InputStream ffr = this.readFontFile(font.font);
        if (this.mergeFonts == null) {
            this.mergeFonts = ttf != null ? new MergeTTFonts(null) : new MergeCFFFonts();
        }
        if (this.mergeFonts instanceof MergeTTFonts) {
            FOPPDFMultiByteFont.mergeMaxp(ttf, ((MergeTTFonts)this.mergeFonts).maxp);
            int sizeNoCompGlyphs = oldToNewGIMap.size();
            this.mergeFonts.readFont(ffr, null, null, oldToNewGIMap, true);
            if (oldToNewGIMap.size() > sizeNoCompGlyphs) {
                this.cidSet.mapChar(65536, '\u0000');
            }
        } else {
            this.mergeFonts.readFont(ffr, this.getEmbedFontName(), null, null, true);
        }
        return this.getFontName();
    }

    private void readCharMap(FontContainer font, Map<Integer, String> gidToGlyph, GlyphData[] glyphData, PDCIDFont mainFont, Map<Integer, Integer> oldToNewGIMap) throws IOException {
        int widthPos = font.getFirstChar() + 1;
        for (Map.Entry<Integer, String> i : gidToGlyph.entrySet()) {
            boolean skipWidth;
            String mappedChar = i.getValue();
            int key = i.getKey();
            boolean bl = skipWidth = mappedChar == null || mappedChar.length() == 0;
            if (skipWidth) {
                mappedChar = (char)this.charMapGlobal.size() + "tmp";
            } else if (mappedChar.length() > 1) {
                mappedChar = "" + (char)mappedChar.hashCode();
            }
            if (!this.charMapGlobal.containsKey(mappedChar)) {
                char c = mappedChar.charAt(0);
                if (glyphData.length > 0 && glyphData[key] == null && !CharUtilities.isAdjustableSpace((int)c)) continue;
                boolean addToEnd = this.charMapGlobal.containsValue(key);
                if (addToEnd) {
                    this.addPrivateUseMapping(c, this.charMapGlobal.size() + 1);
                    this.charMapGlobal.put(mappedChar, this.charMapGlobal.size() + 1);
                } else {
                    this.addPrivateUseMapping(c, key);
                    this.charMapGlobal.put(mappedChar, key);
                }
                char glyph = '\u0000';
                if (this.hasChar(c)) {
                    glyph = this.mapChar(c);
                }
                oldToNewGIMap.put(key, Integer.valueOf(glyph));
                if (!skipWidth) {
                    float w;
                    if (!(font.font instanceof PDTrueTypeFont)) {
                        widthPos = key;
                    }
                    if ((w = font.font.getWidth(widthPos)) >= 0.0f) {
                        if (mainFont instanceof PDCIDFontType0) {
                            this.newWidth.put(key, (int)w);
                        } else {
                            this.newWidth.put(Integer.valueOf(glyph), (int)w);
                        }
                    }
                }
            }
            if (skipWidth) continue;
            ++widthPos;
        }
    }

    private Map<Integer, String> getMapping(FontContainer font, CMap c, int len) throws IOException {
        PDCIDFont cidFont;
        Map<Integer, String> mapping = new HashMap<Integer, String>();
        if (font.font instanceof PDType0Font && (cidFont = ((PDType0Font)font.font).getDescendantFont()) instanceof PDCIDFontType0) {
            mapping = this.getStrings(((PDCIDFontType0)cidFont).getCFFFont());
        }
        if (c != null) {
            int last = font.getLastChar();
            if (last == -1) {
                last = len;
            }
            for (int i = font.getFirstChar(); i <= last; ++i) {
                String l = c.toUnicode(i);
                if (l == null) continue;
                mapping.put(i, l);
            }
        }
        return mapping;
    }

    private Map<Integer, String> getStrings(CFFFont ff) throws IOException {
        CFFCharset cs = ff.getCharset();
        LinkedHashMap<Integer, String> strings = new LinkedHashMap<Integer, String>();
        for (int gid = 0; gid < 256; ++gid) {
            int sid = cs.getCIDForGID(gid);
            if (sid == 0) continue;
            strings.put(sid, GlyphList.getAdobeGlyphList().toUnicode(this.readString(sid)));
        }
        return strings;
    }

    private String readString(int index) throws IOException {
        if (index >= 0 && index <= 390) {
            return CFFStandardString.getName((int)index);
        }
        return "SID" + index;
    }

    private boolean differentGlyphData(GlyphData[] data, Map<Integer, String> mapping) throws IOException {
        HashMap<String, Integer> tmpMap = new HashMap<String, Integer>();
        for (Map.Entry<Integer, String> entry : mapping.entrySet()) {
            if (tmpMap.containsKey(entry.getValue())) continue;
            tmpMap.put(entry.getValue(), entry.getKey());
        }
        mapping.clear();
        for (Map.Entry<Integer, String> entry : tmpMap.entrySet()) {
            mapping.put((Integer)((Object)entry.getValue()), (String)((Object)entry.getKey()));
        }
        for (Map.Entry<Integer, String> entry : mapping.entrySet()) {
            if (entry.getKey() < data.length) continue;
            throw new IOException("Mapping not found in glyphData");
        }
        return false;
    }

    private InputStream readFontFile(PDFont font) throws IOException {
        PDStream ff;
        PDFontDescriptor fd = font.getFontDescriptor();
        if (font instanceof PDType0Font) {
            PDCIDFont cidFont = ((PDType0Font)font).getDescendantFont();
            fd = cidFont.getFontDescriptor();
        }
        if ((ff = fd.getFontFile3()) == null && (ff = fd.getFontFile2()) == null) {
            ff = fd.getFontFile();
        }
        if (ff == null) {
            throw new IOException(font.getName() + " no fontfile");
        }
        COSInputStream is = ff.createInputStream();
        return new ByteArrayInputStream(IOUtils.toByteArray((InputStream)is));
    }

    public Map<Integer, Integer> getWidthsMap() {
        return this.newWidth;
    }

    public PDFDictionary getRef() {
        return this.ref;
    }

    @Override
    public void setRef(PDFDictionary d) {
        this.ref = d;
    }

    @Override
    public int size() {
        if (this.getFontType() == FontType.CIDTYPE0) {
            return 1;
        }
        return 0;
    }

    private void readFontBBox(COSBase b) throws IOException {
        block4: {
            block5: {
                block3: {
                    if (!(b instanceof COSDictionary)) break block3;
                    COSDictionary dict = (COSDictionary)b;
                    for (Map.Entry n : dict.entrySet()) {
                        this.readFontBBox((COSBase)n.getValue());
                        if (n.getKey() != COSName.FONT_BBOX) continue;
                        COSArray w = (COSArray)n.getValue();
                        float[] bboxf = w.toFloatArray();
                        int[] bbox = new int[bboxf.length];
                        for (int i = 0; i < bbox.length; ++i) {
                            bbox[i] = (int)bboxf[i];
                        }
                        this.setFontBBox(bbox);
                    }
                    break block4;
                }
                if (!(b instanceof COSObject)) break block5;
                COSObject o = (COSObject)b;
                this.readFontBBox(o.getObject());
                break block4;
            }
            if (!(b instanceof COSArray)) break block4;
            COSArray o = (COSArray)b;
            for (int i = 0; i < o.size(); ++i) {
                this.readFontBBox(o.get(i));
            }
        }
    }

    public boolean isEmbeddable() {
        return true;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.mergeFonts.getMergedFontSubset());
    }

    protected FontContainer getFont(COSDictionary fontData) throws IOException {
        if (!this.fontMap.containsKey(fontData)) {
            if (this.fontMap.size() > 10) {
                this.fontMap.clear();
            }
            this.fontMap.put(fontData, new FontContainer(fontData));
        }
        return this.fontMap.get(fontData);
    }

    protected static void setProperties(CustomFont cFont, PDFont font) {
        if (font.getFontDescriptor() != null) {
            cFont.setCapHeight((int)font.getFontDescriptor().getCapHeight());
            cFont.setAscender((int)font.getFontDescriptor().getAscent());
            cFont.setDescender((int)font.getFontDescriptor().getDescent());
            cFont.setXHeight((int)font.getFontDescriptor().getXHeight());
            cFont.setStemV((int)font.getFontDescriptor().getStemV());
        }
    }

    protected static void mergeMaxp(TrueTypeFont ttf, MaximumProfileTable outMaxp) throws IOException {
        org.apache.fontbox.ttf.MaximumProfileTable mp = ttf.getMaximumProfile();
        outMaxp.setVersion(mp.getVersion());
        outMaxp.setNumGlyphs(outMaxp.getNumGlyphs() + mp.getNumGlyphs());
        outMaxp.setMaxPoints(outMaxp.getMaxPoints() + mp.getMaxPoints());
        outMaxp.setMaxContours(outMaxp.getMaxContours() + mp.getMaxContours());
        outMaxp.setMaxCompositePoints(outMaxp.getMaxCompositePoints() + mp.getMaxCompositePoints());
        outMaxp.setMaxCompositeContours(outMaxp.getMaxCompositeContours() + mp.getMaxCompositeContours());
        outMaxp.setMaxZones(outMaxp.getMaxZones() + mp.getMaxZones());
        outMaxp.setMaxTwilightPoints(outMaxp.getMaxTwilightPoints() + mp.getMaxTwilightPoints());
        outMaxp.setMaxStorage(outMaxp.getMaxStorage() + mp.getMaxStorage());
        outMaxp.setMaxFunctionDefs(outMaxp.getMaxFunctionDefs() + mp.getMaxFunctionDefs());
        outMaxp.setMaxInstructionDefs(outMaxp.getMaxInstructionDefs() + mp.getMaxInstructionDefs());
        outMaxp.setMaxStackElements(outMaxp.getMaxStackElements() + mp.getMaxStackElements());
        outMaxp.setMaxSizeOfInstructions(outMaxp.getMaxSizeOfInstructions() + mp.getMaxSizeOfInstructions());
        outMaxp.setMaxComponentElements(outMaxp.getMaxComponentElements() + mp.getMaxComponentElements());
        outMaxp.setMaxComponentDepth(outMaxp.getMaxComponentDepth() + mp.getMaxComponentDepth());
    }

    @Override
    public String getMappedWord(List<String> word, byte[] bytes, FontContainer oldFont) {
        StringBuilder newHex = new StringBuilder();
        for (String str : word) {
            char c = str.charAt(0);
            if (str.length() > 1) {
                c = (char)str.hashCode();
            }
            if (this.hasChar(c)) {
                char mapped = this.mapChar(c);
                newHex.append(String.format("%1$04x", mapped & 0xFFFF).toUpperCase(Locale.getDefault()));
                continue;
            }
            return null;
        }
        return "<" + newHex.toString() + ">";
    }
}

