/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.password;

import java.io.File;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.servlet.ServletContext;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.exceptions.OperationNotAllowedEx;
import org.fao.geonet.exceptions.UserNotFoundEx;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.services.NotInReadOnlyModeService;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.util.PasswordUtil;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
public class Change
extends NotInReadOnlyModeService {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String CHANGE_KEY = "changeKey";
    private static final String PWD_CHANGED_XSLT = "password-changed-email.xsl";
    private static String FS = File.separator;
    private Path stylePath;

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.stylePath = appPath.resolve("xslt").resolve("services").resolve("account");
    }

    public Element serviceSpecificExec(Element params, ServiceContext context) throws Exception {
        String username = Util.getParam((Element)params, (String)"username");
        String password = Util.getParam((Element)params, (String)"password");
        String changeKey = Util.getParam((Element)params, (String)CHANGE_KEY);
        String template = Util.getParam((Element)params, (String)"template", (String)PWD_CHANGED_XSLT);
        UserRepository userRepository = (UserRepository)context.getBean(UserRepository.class);
        User elUser = userRepository.findOneByUsername(username);
        if (elUser == null) {
            throw new UserNotFoundEx(username);
        }
        if (elUser.getProfile() != Profile.RegisteredUser) {
            throw new OperationNotAllowedEx("Only users with profile RegisteredUser can change their password using this option");
        }
        String scrambledPassword = elUser.getPassword();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String todaysDate = sdf.format(cal.getTime());
        boolean passwordMatches = PasswordUtil.encoder((ServletContext)context.getServlet().getServletContext()).matches((CharSequence)(scrambledPassword + todaysDate), changeKey);
        if (!passwordMatches) {
            throw new BadParameterEx("Change key invalid or expired", (Object)changeKey);
        }
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        String adminEmail = sm.getValue("system/feedback/email");
        String thisSite = sm.getSiteName();
        SettingInfo si = (SettingInfo)context.getBean(SettingInfo.class);
        String siteURL = si.getSiteUrl() + context.getBaseUrl();
        elUser.getSecurity().setPassword(PasswordUtil.encode((ServiceContext)context, (String)password));
        userRepository.save((Object)elUser);
        Element root = new Element("root");
        root.addContent((Content)elUser.asXml());
        root.addContent((Content)new Element("site").setText(thisSite));
        root.addContent((Content)new Element("siteURL").setText(siteURL));
        root.addContent((Content)new Element("adminEmail").setText(adminEmail));
        root.addContent((Content)new Element("password").setText(password));
        FilePathChecker.verify((String)template);
        Path emailXslt = this.stylePath.resolve(template);
        Element elEmail = Xml.transform((Element)root, (Path)emailXslt);
        String subject = elEmail.getChildText("subject");
        String to = elEmail.getChildText("to");
        String content = elEmail.getChildText("content");
        if (!MailUtil.sendMail((String)to, (String)subject, (String)content, null, (SettingManager)sm, (String)adminEmail, (String)"").booleanValue()) {
            throw new OperationAbortedEx("Could not send email");
        }
        return new Element("response");
    }
}

