/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.oaipmh.Lib;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.services.Utils;
import org.fao.geonet.services.metadata.Show;
import org.jdom.Element;

public class Convert
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SchemaManager sm = (SchemaManager)gc.getBean(SchemaManager.class);
        String id = Utils.getIdentifierFromParameters((Element)params, (ServiceContext)context);
        if (id == null) {
            throw new MetadataNotFoundEx("Metadata not found.");
        }
        Element elMd = new Show().exec(params, context);
        if (elMd == null) {
            throw new MetadataNotFoundEx(id);
        }
        String styleSheet = Util.getParam((Element)params, (String)"styleSheet");
        AbstractMetadata metadata = ((IMetadataUtils)context.getBean(IMetadataUtils.class)).findOne(id);
        Path schemaDir = sm.getSchemaDir(metadata.getDataInfo().getSchemaId());
        String baseUrl = context.getBaseUrl();
        ISODate changeDate = metadata.getDataInfo().getChangeDate();
        String uuid = metadata.getUuid();
        String siteURL = ((SettingManager)context.getBean(SettingManager.class)).getSiteURL(context);
        String siteName = ((SettingManager)gc.getBean(SettingManager.class)).getSiteName();
        Element env = Lib.prepareTransformEnv((String)uuid, (String)changeDate.getDateAndTime(), (String)baseUrl, (String)siteURL, (String)siteName);
        return Lib.transform((Path)schemaDir, (Element)env, (Element)elMd, (String)styleSheet);
    }
}

