/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.main;

import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.MissingParameterEx;
import org.fao.geonet.exceptions.UserNotFoundEx;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Element;

public class Forward
implements Service {
    public void init(Path appPath, ServiceConfig config) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        Element site = Util.getChild((Element)params, (String)"site");
        Element par = Util.getChild((Element)params, (String)"params");
        Element acc = site.getChild("account");
        String url = Util.getParam((Element)site, (String)"url");
        String type = Util.getParam((Element)site, (String)"type", (String)"generic");
        String username = acc == null ? null : Util.getParam((Element)acc, (String)"username");
        String password = acc == null ? null : Util.getParam((Element)acc, (String)"password");
        List list = par.getChildren();
        if (list.size() == 0) {
            throw new MissingParameterEx("<request>", (Object)par);
        }
        XmlRequest req = ((GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(new URL(url));
        if (username != null) {
            this.authenticate(req, username, password, type);
        }
        Lib.net.setupProxy(context, req);
        if (list.size() == 1) {
            params = (Element)list.get(0);
            req.setRequest(params);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                Element elem = (Element)list.get(i);
                req.addParam(elem.getName(), (Object)elem.getText());
            }
        }
        Element result = req.execute();
        return result;
    }

    private void authenticate(XmlRequest req, String username, String password, String type) throws Exception {
        if (!type.equals("geonetwork")) {
            req.setCredentials(username, password);
        } else {
            String addr = req.getAddress();
            int pos = addr.lastIndexOf(47);
            req.setAddress(addr.substring(0, pos + 1) + "xml.user.login");
            req.addParam("username", (Object)username);
            req.addParam("password", (Object)password);
            Element response = req.execute();
            if (!response.getName().equals("ok")) {
                throw new UserNotFoundEx(username);
            }
            req.setAddress(addr);
        }
    }
}

