/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.users;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.api.users.model.UserRegisterDto;
import org.fao.geonet.api.users.recaptcha.RecaptchaChecker;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.kernel.security.SecurityProviderConfiguration;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.util.PasswordUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import springfox.documentation.annotations.ApiIgnore;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/user", "/{portal}/api/0.1/user"})
@Api(value="users", tags={"users"}, description="User operations")
public class RegisterApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired(required=false)
    SecurityProviderConfiguration securityProviderConfiguration;

    @ApiOperation(value="Create user account", nickname="registerUser", notes="User is created with a registered user profile. username field is ignored and the email is used as username. Password is sent by email. Catalog administrator is also notified.")
    @RequestMapping(value={"/actions/register"}, method={RequestMethod.PUT}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity<String> registerUser(@ApiParam(value="User details", required=true) @RequestBody UserRegisterDto userRegisterDto, @ApiIgnore BindingResult bindingResult, @ApiIgnore HttpServletRequest request) throws Exception {
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale);
        if (this.securityProviderConfiguration != null && !this.securityProviderConfiguration.isUserProfileUpdateEnabled()) {
            return new ResponseEntity((Object)messages.getString("security_provider_unsupported_functionality"), HttpStatus.PRECONDITION_FAILED);
        }
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            String message;
            String subject;
            String catalogAdminEmail;
            boolean validRecaptcha;
            SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
            boolean selfRegistrationEnabled = sm.getValueAsBool("system/userSelfRegistration/enable");
            if (!selfRegistrationEnabled) {
                ResponseEntity responseEntity = new ResponseEntity((Object)String.format(messages.getString("self_registration_disabled"), new Object[0]), HttpStatus.PRECONDITION_FAILED);
                return responseEntity;
            }
            boolean recaptchaEnabled = sm.getValueAsBool("system/userSelfRegistration/recaptcha/enable");
            if (recaptchaEnabled && !(validRecaptcha = RecaptchaChecker.verify(userRegisterDto.getCaptcha(), sm.getValue("system/userSelfRegistration/recaptcha/secretkey")))) {
                ResponseEntity responseEntity = new ResponseEntity((Object)messages.getString("recaptcha_not_valid"), HttpStatus.PRECONDITION_FAILED);
                return responseEntity;
            }
            if (bindingResult.hasErrors()) {
                List errorList = bindingResult.getAllErrors();
                StringBuilder sb = new StringBuilder();
                Iterator it = errorList.iterator();
                while (it.hasNext()) {
                    sb.append(messages.getString(((ObjectError)it.next()).getDefaultMessage()));
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                ResponseEntity responseEntity = new ResponseEntity((Object)sb.toString(), HttpStatus.PRECONDITION_FAILED);
                return responseEntity;
            }
            UserRepository userRepository = (UserRepository)context.getBean(UserRepository.class);
            if (userRepository.findOneByEmail(userRegisterDto.getEmail()) != null) {
                ResponseEntity sb = new ResponseEntity((Object)String.format(messages.getString("user_with_that_email_found"), userRegisterDto.getEmail()), HttpStatus.PRECONDITION_FAILED);
                return sb;
            }
            if (userRepository.findByUsernameIgnoreCase(userRegisterDto.getEmail()).size() != 0) {
                ResponseEntity sb = new ResponseEntity((Object)String.format(messages.getString("user_with_that_username_found"), userRegisterDto.getEmail()), HttpStatus.PRECONDITION_FAILED);
                return sb;
            }
            User user = new User();
            user.setName(userRegisterDto.getName());
            user.setSurname(userRegisterDto.getSurname());
            user.setOrganisation(userRegisterDto.getOrganisation());
            user.setProfile(Profile.findProfileIgnoreCase((String)userRegisterDto.getProfile()));
            user.getAddresses().add(userRegisterDto.getAddress());
            user.getEmailAddresses().add(userRegisterDto.getEmail());
            String password = User.getRandomPassword();
            user.getSecurity().setPassword(PasswordUtil.encode((ServiceContext)context, (String)password));
            user.setUsername(user.getEmail());
            Profile requestedProfile = user.getProfile();
            user.setProfile(Profile.RegisteredUser);
            user = (User)userRepository.save((Object)user);
            Group targetGroup = this.getGroup(context);
            if (targetGroup != null) {
                UserGroup userGroup = new UserGroup().setUser(user).setGroup(targetGroup).setProfile(Profile.RegisteredUser);
                ((UserGroupRepository)context.getBean(UserGroupRepository.class)).save((Object)userGroup);
            }
            if (!MailUtil.sendMail((String)(catalogAdminEmail = sm.getValue("system/feedback/email")), (String)(subject = String.format(messages.getString("register_email_admin_subject"), sm.getSiteName(), user.getEmail(), requestedProfile)), (String)(message = String.format(messages.getString("register_email_admin_message"), user.getEmail(), requestedProfile, sm.getNodeURL(), sm.getSiteName())), null, (SettingManager)sm).booleanValue()) {
                ResponseEntity responseEntity = new ResponseEntity((Object)String.format(messages.getString("mail_error"), new Object[0]), HttpStatus.PRECONDITION_FAILED);
                return responseEntity;
            }
            subject = String.format(messages.getString("register_email_subject"), sm.getSiteName(), user.getProfile());
            message = String.format(messages.getString("register_email_message"), sm.getSiteName(), user.getUsername(), password, Profile.RegisteredUser, requestedProfile, sm.getNodeURL(), sm.getSiteName());
            if (!MailUtil.sendMail((String)user.getEmail(), (String)subject, (String)message, null, (SettingManager)sm).booleanValue()) {
                ResponseEntity responseEntity = new ResponseEntity((Object)String.format(messages.getString("mail_error"), new Object[0]), HttpStatus.PRECONDITION_FAILED);
                return responseEntity;
            }
            ResponseEntity responseEntity = new ResponseEntity((Object)String.format(messages.getString("user_registered"), user.getUsername()), HttpStatus.CREATED);
            return responseEntity;
        }
    }

    Group getGroup(ServiceContext context) throws SQLException {
        GroupRepository bean = (GroupRepository)context.getBean(GroupRepository.class);
        return (Group)bean.findOne((Serializable)Integer.valueOf(ReservedGroup.guest.getId()));
    }
}

