/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.uisetting;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.UiSetting;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.UiSettingsRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/ui", "/{portal}/api/0.1/ui"})
@Api(value="ui", tags={"ui"}, description="User interface configuration operations")
@Controller(value="ui")
public class UiSettingApi {
    @Autowired
    UiSettingsRepository uiSettingsRepository;
    @Autowired
    SourceRepository sourceRepository;
    @Autowired
    UserGroupRepository userGroupRepository;

    @ApiOperation(value="Get UI configuration", notes="", nickname="getUiConfigurations")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="List of configuration.")})
    @ResponseBody
    public List<UiSetting> getUiConfigurations() throws Exception {
        return this.uiSettingsRepository.findAll();
    }

    @ApiOperation(value="Create a UI configuration", notes="", nickname="putUiConfiguration")
    @RequestMapping(method={RequestMethod.PUT}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(code=201, message="UI configuration created. Return the new UI configuration identifier."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasRole('UserAdmin')")
    public ResponseEntity<String> putUiConfiguration(@ApiParam(name="uiConfiguration") @RequestBody UiSetting uiConfiguration) throws Exception {
        if (StringUtils.isEmpty((String)uiConfiguration.getId())) {
            throw new IllegalArgumentException(String.format("A UI configuration MUST have an id. The id could be a string to easily identify the configuration.", uiConfiguration.getId()));
        }
        UiSetting one = (UiSetting)this.uiSettingsRepository.findOne((Serializable)((Object)uiConfiguration.getId()));
        if (one != null) {
            throw new IllegalArgumentException(String.format("A UI configuration with id '%d' already exist", uiConfiguration.getId()));
        }
        UiSetting save = (UiSetting)this.uiSettingsRepository.save((Object)uiConfiguration);
        return new ResponseEntity((Object)save.getId(), HttpStatus.CREATED);
    }

    @ApiOperation(value="Get a UI configuration", notes="", nickname="getUiConfiguration")
    @RequestMapping(value={"/{uiIdentifier}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="UI configuration.")})
    @ResponseBody
    public UiSetting getUiConfiguration(@ApiParam(value="UI identifier", required=true) @PathVariable String uiIdentifier) throws Exception {
        UiSetting uiConfiguration = (UiSetting)this.uiSettingsRepository.findOne((Serializable)((Object)uiIdentifier));
        if (uiConfiguration == null) {
            throw new ResourceNotFoundException(String.format("UI configuration with id '%s' does not exist.", uiIdentifier));
        }
        return uiConfiguration;
    }

    @ApiOperation(value="Update a UI configuration", notes="", nickname="updateUiConfiguration")
    @RequestMapping(value={"/{uiIdentifier}"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="UI configuration updated."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @ResponseBody
    public ResponseEntity updateUiConfiguration(@ApiParam(value="UI configuration identifier", required=true) @PathVariable String uiIdentifier, @ApiParam(name="UI configuration") @RequestBody UiSetting uiConfiguration, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession) throws Exception {
        UiSetting one = (UiSetting)this.uiSettingsRepository.findOne((Serializable)((Object)uiIdentifier));
        if (one != null) {
            UserSession session = ApiUtils.getUserSession(httpSession);
            boolean isUserAdmin = session.getProfile().equals((Object)Profile.UserAdmin);
            if (isUserAdmin) {
                if (this.canManageUISettings(uiIdentifier, session)) {
                    this.uiSettingsRepository.save((Object)uiConfiguration);
                    return new ResponseEntity(HttpStatus.NO_CONTENT);
                }
                throw new NotAllowedException(String.format("UI configuration with id '%s' is not used in any portal managed by current user. You are not allowed to update this configuration.", uiIdentifier));
            }
        } else {
            throw new ResourceNotFoundException(String.format("UI configuration with id '%s' does not exist.", uiIdentifier));
        }
        this.uiSettingsRepository.save((Object)uiConfiguration);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="Remove a UI Configuration", notes="", nickname="deleteUiConfiguration")
    @RequestMapping(value={"/{uiIdentifier}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="UI Configuration removed."), @ApiResponse(code=404, message="UI Configuration not found."), @ApiResponse(code=403, message="Operation not allowed. Only UserAdmins can access it.")})
    @PreAuthorize(value="hasRole('UserAdmin')")
    public ResponseEntity deleteUiConfiguration(@ApiParam(value="UI configuration identifier", required=true) @PathVariable String uiIdentifier, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession) throws Exception {
        UiSetting one = (UiSetting)this.uiSettingsRepository.findOne((Serializable)((Object)uiIdentifier));
        if (one != null) {
            UserSession session = ApiUtils.getUserSession(httpSession);
            boolean isUserAdmin = session.getProfile().equals((Object)Profile.UserAdmin);
            if (isUserAdmin) {
                if (this.canManageUISettings(uiIdentifier, session)) {
                    this.uiSettingsRepository.delete((Serializable)((Object)uiIdentifier));
                    return new ResponseEntity(HttpStatus.NO_CONTENT);
                }
                throw new NotAllowedException(String.format("UI configuration with id '%s' is not used in any portal managed by current user. You are not allowed to update this configuration.", uiIdentifier));
            }
        } else {
            throw new ResourceNotFoundException(String.format("UI Configuration with id '%s' does not exist.", uiIdentifier));
        }
        this.uiSettingsRepository.delete((Serializable)((Object)uiIdentifier));
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private boolean canManageUISettings(String uiIdentifier, UserSession session) {
        Specifications spec = Specifications.where((Specification)UserGroupSpecs.hasUserId((int)session.getUserIdAsInt()));
        spec = spec.and(UserGroupSpecs.hasProfile((Profile)Profile.UserAdmin));
        HashSet ids = new HashSet(this.userGroupRepository.findGroupIds((Specification)spec));
        List sources = this.sourceRepository.findByGroupOwnerIn(ids);
        boolean isUiConfigForOneOfUserPortal = sources.stream().anyMatch(source -> uiIdentifier.equals(source.getUiConfig()));
        return isUiConfigForOneOfUserPortal;
    }
}

