/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.tools.i18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.fao.geonet.languages.IsoLanguagesMapper;

public class LanguageUtils {
    private final Set<String> iso3code;
    private final String defaultLanguage;
    Collection<Locale> locales = new ArrayList<Locale>();

    public LanguageUtils(Set<String> localesToLoad, String defaultLanguage) {
        this.iso3code = Collections.unmodifiableSet(localesToLoad);
        this.defaultLanguage = defaultLanguage;
        for (String l : this.iso3code) {
            this.locales.add(Locale.forLanguageTag(l));
        }
    }

    public Locale parseAcceptLanguage(Enumeration<Locale> listOfLocales) {
        while (listOfLocales.hasMoreElements()) {
            Locale locale = listOfLocales.nextElement();
            if (!this.iso3code.contains(LanguageUtils.iso3code(locale))) continue;
            return locale;
        }
        return Locale.forLanguageTag(this.defaultLanguage);
    }

    @Deprecated
    public String getIso3langCode(Enumeration<Locale> locales) {
        return this.iso3code(locales);
    }

    public String iso3code(Enumeration<Locale> locales) {
        Locale locale = this.parseAcceptLanguage(locales);
        return LanguageUtils.iso3code(locale);
    }

    public static String iso3code(Locale locale) {
        if (locale == null) {
            return null;
        }
        return IsoLanguagesMapper.iso639_2T_to_iso639_2B((String)locale.getISO3Language());
    }

    public Locale parseAcceptLanguage(Locale locale) {
        List<Locale> localesToParse = Collections.singletonList(locale);
        return this.parseAcceptLanguage(Collections.enumeration(localesToParse));
    }

    public String getDefaultUiLanguage() {
        return this.defaultLanguage;
    }

    public Set<String> getUiLanguages() {
        return this.iso3code;
    }
}

