/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.standards;

import java.util.Iterator;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.guiservices.XmlFile;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.utils.Log;
import org.jdom.Element;

public class StandardsUtils {
    public static Element getCodelist(String codelist, SchemaManager schemaManager, String schema, String parent, String xpath, String isoType, ServiceContext context, String displayIf) throws Exception {
        return StandardsUtils.getCodelistOrLabel(codelist, schemaManager, schema, parent, xpath, isoType, context, displayIf, "codelists.xml");
    }

    public static Element getLabel(String element, SchemaManager schemaManager, String schema, String parent, String xpath, String isoType, String displayIf, ServiceContext context) throws Exception {
        return StandardsUtils.getCodelistOrLabel(element, schemaManager, schema, parent, xpath, isoType, context, displayIf, "labels.xml");
    }

    private static Element getCodelistOrLabel(String element, SchemaManager schemaManager, String schema, String parent, String xpath, String isoType, ServiceContext context, String displayIf, String fileName) throws Exception {
        String elementName = StandardsUtils.findNamespace(element, schemaManager, schema);
        Element e = StandardsUtils.getHelp(schemaManager, fileName, schema, elementName, parent, xpath, isoType, displayIf, context);
        if (e == null) {
            if (schema.startsWith("iso19139.")) {
                e = StandardsUtils.getHelp(schemaManager, fileName, "iso19139", elementName, parent, xpath, isoType, displayIf, context);
            }
            if (e == null) {
                throw new ResourceNotFoundException(String.format("Element '%s' from schema '%s' not found in '%s'.", elementName, schema, fileName));
            }
        }
        return e;
    }

    public static Element getHelp(SchemaManager scm, String fileName, String schema, String name, String parent, String xpath, String isoType, String displayIf, ServiceContext context) throws Exception {
        Element result;
        block5: {
            String baseSchema;
            XmlFile xf = (XmlFile)scm.getSchemaInfo(schema).get(fileName);
            if (xf == null) {
                throw new OperationAbortedEx("File not found for : " + schema + "/" + fileName);
            }
            Element entries = xf.exec(new Element("junk"), context);
            result = StandardsUtils.checkEntries(scm, schema, entries, xpath, name, isoType, displayIf, true);
            if (result == null) {
                result = StandardsUtils.checkEntries(scm, schema, entries, parent, name, isoType, displayIf, true);
            }
            if (result == null) {
                result = StandardsUtils.checkEntries(scm, schema, entries, xpath, name, isoType, displayIf, false);
            }
            if (result == null) {
                result = StandardsUtils.checkEntries(scm, schema, entries, parent, name, isoType, displayIf, false);
            }
            if (result != null) break block5;
            Set dependentSchemas = scm.getDependencies(schema);
            Iterator iterator = dependentSchemas.iterator();
            while (iterator.hasNext() && (result = StandardsUtils.getHelp(scm, fileName, baseSchema = (String)iterator.next(), name, parent, xpath, isoType, displayIf, context)) == null) {
            }
        }
        return result;
    }

    private static Element checkEntries(SchemaManager scm, String schema, Element entries, String context, String name, String isoType, String displayIf, boolean requireContextMatch) throws OperationAbortedEx {
        for (Object o : entries.getChildren()) {
            Element currElem = (Element)o;
            String currName = currElem.getAttributeValue("name");
            String aliasName = currElem.getAttributeValue("alias");
            String currContext = currElem.getAttributeValue("context");
            String displayIfAttribute = currElem.getAttributeValue("displayIf");
            if ((currName = StandardsUtils.findNamespace(currName, scm, schema)) == null) {
                Log.warning((String)"geonetwork.schemamanager", (Object)("Namespace prefix for element " + currElem.getAttributeValue("name") + " not found in " + schema + " schema namespaces.Check the element namespace or remove it from the labels.xml file."));
                continue;
            }
            if (!currName.equals(name) && (aliasName == null || !aliasName.equals(name))) continue;
            if (currContext != null && (context != null || isoType != null)) {
                if (!currContext.contains("/")) {
                    currContext = StandardsUtils.findNamespace(currContext, scm, schema);
                    if (context != null && !context.contains("/")) {
                        context = StandardsUtils.findNamespace(context, scm, schema);
                    }
                }
                if (context != null && context.equals(currContext) || isoType != null && isoType.equals(currContext)) {
                    return (Element)currElem.clone();
                }
            } else if (displayIf != null && displayIf.equals(displayIfAttribute)) {
                return (Element)currElem.clone();
            }
            if (requireContextMatch || displayIfAttribute != null) continue;
            return (Element)currElem.clone();
        }
        return null;
    }

    public static String findNamespace(String name, SchemaManager scm, String schema) {
        int pos = name.indexOf(58);
        if (pos == -1) {
            return name;
        }
        String prefix = name.substring(0, pos);
        String nsURI = scm.getNamespaceURI(schema, prefix);
        if (nsURI == null) {
            return null;
        }
        return nsURI + name.substring(pos);
    }

    public static Element buildError(Element elem, String error) {
        elem = (Element)elem.clone();
        elem.setAttribute("error", error);
        return elem;
    }
}

