/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.registries;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.List;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.registries.CrsUtils;
import org.fao.geonet.api.registries.model.Crs;
import org.fao.geonet.api.registries.model.CrsType;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/registries", "/{portal}/api/0.1/registries"})
@Api(value="registries", tags={"registries"}, description="Registries related operations")
public class CrsApi {
    public static final String DEFAULT_PARAMS_ROWS = "100";

    @ApiOperation(value="Get list of CRS type", nickname="getCrsType", notes="")
    @RequestMapping(value={"/crs/types"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="List of CRS types.")})
    @ResponseBody
    public List<CrsType> getCrsTypes() throws Exception {
        return Arrays.asList(CrsType.values());
    }

    @ApiOperation(value="Search coordinate reference system (CRS)", nickname="searchCrs", notes="Based on GeoTools EPSG database. If phrase query, each words are searched separately.")
    @RequestMapping(value={"/crs"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="List of CRS.")})
    @ResponseBody
    public List<Crs> getCrs(@ApiParam(value="Search value", required=false) @RequestParam(required=false, defaultValue="") String q, @ApiParam(value="Type of CRS", required=false) @RequestParam(required=false) CrsType type, @ApiParam(value="Number of results. Default is: 100", required=false) @RequestParam(required=false, defaultValue="100") int rows) throws Exception {
        List<Crs> crsList = CrsUtils.search(q.split(" "), type, rows);
        return crsList;
    }

    @ApiOperation(value="Get CRS", nickname="getCrsById", notes="")
    @RequestMapping(value={"/crs/{id}"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="CRS details."), @ApiResponse(code=404, message="CRS not found.")})
    @ResponseBody
    public Crs getCrs(@ApiParam(value="CRS identifier", required=true) @PathVariable String id) throws Exception {
        Crs crs = CrsUtils.getById(id);
        if (crs != null) {
            return crs;
        }
        throw new ResourceNotFoundException(String.format("CRS with id '%s' not found in EPSG database", id));
    }
}

