/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.regions.metadata;

import com.google.common.collect.Lists;
import java.util.List;
import org.fao.geonet.api.regions.metadata.MetadataRegionFinder;
import org.fao.geonet.api.regions.metadata.MetadataRegionSearchRequest;
import org.fao.geonet.kernel.region.Region;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.Namespace;

public class FindRegionByGmlId
extends MetadataRegionFinder {
    public static final String GML_ID_PREFIX = "@gml";

    @Override
    public boolean accepts(String id) {
        return id.startsWith(GML_ID_PREFIX);
    }

    @Override
    public void findRegion(MetadataRegionSearchRequest searchRequest, List<Region> regions, MetadataRegionSearchRequest.Id mdId, String id, Element metadata) throws Exception {
        String gmlId = id.substring(GML_ID_PREFIX.length());
        Element geomEl = Xml.selectElement((Element)metadata, (String)("*//*[@gml:id = '" + gmlId + "']"), (List)Lists.newArrayList((Object[])new Namespace[]{metadata.getNamespace("gml")}));
        if (geomEl != null) {
            searchRequest.findContainingGmdEl(regions, mdId, geomEl);
        }
    }

    @Override
    public boolean needsEditData() {
        return false;
    }
}

