/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.rdf;

import java.util.List;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SearcherType;
import org.fao.geonet.services.util.SearchDefaults;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

public class RdfSearcher {
    private MetaSearcher searcher;
    private Element searchRequest;
    private long _versionToken = -1L;
    private int numberMatched;

    public RdfSearcher(Element params, ServiceContext context) {
        this.searchRequest = SearchDefaults.getDefaultSearch((ServiceContext)context, (Element)params);
        this.searchRequest.addContent((Content)new Element("buildSummary").setText("false"));
        this.searchRequest.addContent((Content)new Element("_isTemplate").setText("n"));
        this.searchRequest.addContent((Content)new Element("_op0").setText("1"));
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)("PUBLIC METADATA SEARCH CRITERIA:\n" + Xml.getString((Element)this.searchRequest)));
        }
    }

    public List search(ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SearchManager searchMan = (SearchManager)gc.getBean(SearchManager.class);
        this.searcher = searchMan.newSearcher(SearcherType.LUCENE, "lucene.xsl");
        ServiceConfig config = new ServiceConfig();
        this.searcher.search(context, this.searchRequest, config);
        this.numberMatched = this.searcher.getSize();
        this._versionToken = this.searcher.getVersionToken();
        this.searchRequest.addContent((Content)new Element("buildSummary").setText("false"));
        return this.searcher.present(context, this.searchRequest, config).getChildren();
    }

    public void close() {
        try {
            if (this.searcher != null) {
                this.searcher.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getSize() {
        return this.numberMatched;
    }

    public long getVersionToken() {
        return this._versionToken;
    }
}

