/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.template;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.records.formatters.ConfigFile;
import org.fao.geonet.api.records.formatters.groovy.template.FileResult;
import org.fao.geonet.api.records.formatters.groovy.template.TNode;
import org.fao.geonet.api.records.formatters.groovy.template.TemplateParser;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.utils.IO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class TemplateCache {
    @VisibleForTesting
    final Map<Path, TNode> canonicalFileNameToText = Maps.newHashMap();
    private final Set<Path> filesKnownToNotExist = Sets.newHashSet();
    @Autowired
    @VisibleForTesting
    TemplateParser xmlTemplateParser;

    public synchronized FileResult createFileResult(Path formatterDir, Path schemaDir, Path rootFormatterDir, String path, Map<String, Object> model) throws IOException {
        return new Request().createFileResult(formatterDir, schemaDir, rootFormatterDir, path, model);
    }

    private class Request {
        private final SystemInfo systemInfo;
        private final SchemaManager schemaManager;

        public Request() {
            ConfigurableApplicationContext context = ApplicationContextHolder.get();
            this.systemInfo = (SystemInfo)context.getBean(SystemInfo.class);
            this.schemaManager = (SchemaManager)context.getBean(SchemaManager.class);
        }

        public synchronized FileResult createFileResult(Path formatterDir, Path schemaDir, Path rootFormatterDir, String path, Map<String, Object> model) throws IOException {
            Path file;
            Path originalPath = IO.toPath((String)path, (String[])new String[0]);
            TNode template = this.fetchFromCache(originalPath, file = formatterDir.resolve(path));
            if (template != null) {
                return new FileResult(template, model);
            }
            if (schemaDir != null) {
                file = schemaDir.resolve(path);
            }
            if ((template = this.fetchFromCache(originalPath, file)) != null) {
                return new FileResult(template, model);
            }
            Path fromParentSchema = this.fromParentSchema(formatterDir, schemaDir, path);
            if (fromParentSchema != null && (template = this.fetchFromCache(originalPath, fromParentSchema)) != null) {
                return new FileResult(template, model);
            }
            file = rootFormatterDir.resolve(path);
            template = this.fetchFromCache(originalPath, file);
            if (template != null) {
                return new FileResult(template, model);
            }
            file = formatterDir.resolve(path);
            if (!this.exists(file) && schemaDir != null) {
                file = schemaDir.resolve(path);
            }
            if (!this.exists(file)) {
                if (fromParentSchema == null) {
                    fromParentSchema = this.fromParentSchema(formatterDir, schemaDir, path);
                }
                if (fromParentSchema != null) {
                    file = fromParentSchema;
                }
            }
            if (!this.exists(file)) {
                file = rootFormatterDir.resolve(path);
            }
            if (!this.exists(file)) {
                throw new IllegalArgumentException("There is no file: " + path + " in any of: \n\t * " + formatterDir + "\n\t * " + schemaDir + "\n\t * if parent exists: " + fromParentSchema + "\n\t * " + rootFormatterDir);
            }
            template = TemplateCache.this.xmlTemplateParser.parse(file);
            this.cacheTemplate(originalPath, file, template);
            return new FileResult(template, model);
        }

        public boolean exists(Path file) throws IOException {
            if (!this.systemInfo.isDevMode() && (TemplateCache.this.filesKnownToNotExist.contains(file) || TemplateCache.this.filesKnownToNotExist.contains(file.toAbsolutePath()))) {
                return false;
            }
            boolean exists = Files.exists(file, new LinkOption[0]);
            if (!exists) {
                TemplateCache.this.filesKnownToNotExist.add(file);
                TemplateCache.this.filesKnownToNotExist.add(file.toAbsolutePath());
            }
            return exists;
        }

        public void cacheTemplate(Path originalPath, Path file, TNode template) throws IOException {
            this.doCache(originalPath, template);
            this.doCache(this.toRealPath(file), template);
            this.doCache(file, template);
            this.doCache(file.toAbsolutePath(), template);
            this.doCache(file.toAbsolutePath().normalize(), template);
        }

        public void doCache(Path originalPath, TNode template) {
            TemplateCache.this.filesKnownToNotExist.remove(originalPath);
            TemplateCache.this.canonicalFileNameToText.put(originalPath, template);
        }

        public TNode fetchFromCache(Path originalPath, Path file) throws IOException {
            if (this.systemInfo.isDevMode()) {
                return null;
            }
            TNode template = TemplateCache.this.canonicalFileNameToText.get(originalPath);
            boolean recache = false;
            if (template == null) {
                template = TemplateCache.this.canonicalFileNameToText.get(file);
                recache = true;
            }
            if (template == null) {
                template = TemplateCache.this.canonicalFileNameToText.get(file.toAbsolutePath());
                recache = true;
            }
            if (template == null) {
                template = TemplateCache.this.canonicalFileNameToText.get(file.toAbsolutePath().normalize());
                recache = true;
            }
            if (template == null) {
                template = TemplateCache.this.canonicalFileNameToText.get(this.toRealPath(file));
                recache = true;
            }
            if (recache && template != null) {
                this.cacheTemplate(originalPath, file, template);
            }
            return template;
        }

        private Path toRealPath(Path file) throws IOException {
            if (this.exists(file)) {
                return file.toRealPath(new LinkOption[0]);
            }
            return file.toAbsolutePath().normalize();
        }

        private Path fromParentSchema(Path formatterDir, Path schemaDir, String path) throws IOException {
            ConfigFile configFile = formatterDir != null ? new ConfigFile(formatterDir, true, schemaDir) : new ConfigFile(schemaDir, false, null);
            String schemaName = configFile.dependOn();
            if (schemaName != null) {
                Path parentSchema = this.schemaManager.getSchemaDir(schemaName).resolve("formatter");
                Path file = parentSchema.resolve(path);
                if (this.exists(file)) {
                    return file;
                }
                return this.fromParentSchema(null, parentSchema, path);
            }
            return null;
        }
    }
}

