/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy;

import groovy.util.ClosureComparator;
import groovy.util.slurpersupport.GPathResult;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.fao.geonet.api.records.formatters.groovy.Handler;
import org.fao.geonet.api.records.formatters.groovy.Sorter;
import org.fao.geonet.api.records.formatters.groovy.TransformationContext;

public class SorterPathSelect
extends Sorter {
    private final Pattern pathPattern;

    public SorterPathSelect(int priority, Pattern pathPattern, ClosureComparator comparator) {
        super(priority, (Comparator<GPathResult>)comparator);
        this.pathPattern = pathPattern;
    }

    @Override
    public boolean select(TransformationContext context, GPathResult parentElement) {
        StringBuilder path = new StringBuilder(context.getRootPath());
        if (path.length() > 0) {
            path.append(">");
        }
        Handler.createPath(parentElement, path);
        return this.pathPattern.matcher(path.toString()).matches();
    }

    @Override
    protected String extraToString() {
        return ", pathPattern ~= /" + this.pathPattern + "/";
    }
}

