/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.editing;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.guiservices.session.Get;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.guiservices.XmlFile;
import jeeves.services.ReadWriteController;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.records.editing.AjaxEditUtils;
import org.fao.geonet.api.records.model.Direction;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.events.history.RecordUpdatedEvent;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.EditLib;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataStatus;
import org.fao.geonet.kernel.metadata.StatusActions;
import org.fao.geonet.kernel.metadata.StatusActionsFactory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.repository.specification.MetadataValidationSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="recordEditing")
@PreAuthorize(value="hasRole('Editor')")
@ReadWriteController
public class MetadataEditingApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    IMetadataIndexer metadataIndexer;
    @Autowired
    MetadataDraftRepository metadataDraftRepository;
    @Autowired
    private StatusValueRepository statusValueRepository;
    @Autowired
    SchemaManager schemaManager;

    @ApiOperation(value="Edit a record", notes="Return HTML form for editing.", nickname="editor")
    @RequestMapping(value={"/{metadataUuid}/editor"}, method={RequestMethod.GET}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="The editor form."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    public void startEditing(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Tab") @RequestParam(defaultValue="simple") String currTab, @RequestParam(defaultValue="false") boolean withAttributes, @ApiIgnore @ApiParam(hidden=true) HttpSession session, @ApiIgnore @ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            IMetadataUtils dm;
            Integer id2;
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            boolean showValidationErrors = false;
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
            boolean isEnabledWorkflow = sm.getValueAsBool("metadata/workflow/enable");
            boolean flagCreateDraftFromApprovedMetadata = false;
            if (isEnabledWorkflow) {
                boolean bl = flagCreateDraftFromApprovedMetadata = this.metadataDraftRepository.findOneByUuid(metadata.getUuid()) == null;
            }
            if ((id2 = (dm = (IMetadataUtils)applicationContext.getBean(IMetadataUtils.class)).startEditingSession(context, String.valueOf(metadata.getId()))).intValue() != metadata.getId()) {
                StringBuilder sb = new StringBuilder("?");
                Enumeration parameters = request.getParameterNames();
                boolean hasPreviousURL = false;
                while (parameters.hasMoreElements()) {
                    String key = (String)parameters.nextElement();
                    sb.append(key + "=" + request.getParameter(key) + "%26");
                    if (!key.equalsIgnoreCase("redirectUrl")) continue;
                    hasPreviousURL = true;
                }
                if (!hasPreviousURL) {
                    sb.append("redirectUrl=catalog.edit");
                }
                context.getUserSession().setProperty("metadata.editing.created.draft", (Object)flagCreateDraftFromApprovedMetadata);
                Element el = new Element("script");
                el.setText("window.location.hash = decodeURIComponent(\"#/metadata/" + id2 + sb.toString() + "\")");
                String elStr = Xml.getString((Element)el);
                response.getWriter().print(elStr);
                return;
            }
            Element elMd = new AjaxEditUtils(context).getMetadataEmbedded(context, String.valueOf(metadata.getId()), true, showValidationErrors);
            this.buildEditorForm(currTab, session, allRequestParams, request, elMd, metadata.getDataInfo().getSchemaId(), context, (ApplicationContext)applicationContext, false, false, response);
        }
    }

    @ApiOperation(value="Save edits", notes="Save the HTML form content.", nickname="saveEdits")
    @RequestMapping(value={"/{metadataUuid}/editor"}, method={RequestMethod.POST}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="The editor form."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    public void saveEdits(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Tab") @RequestParam(defaultValue="simple") String tab, @RequestParam(defaultValue="false") boolean withAttributes, @RequestParam(defaultValue="false") boolean withValidationErrors, @RequestParam(defaultValue="false") boolean minor, @ApiParam(value="Submit for review directly after save.") @RequestParam(defaultValue="1") String status, @ApiParam(value="Save current edits.") @RequestParam(defaultValue="false") boolean commit, @ApiParam(value="Save and terminate session.") @RequestParam(defaultValue="false") boolean terminate, @ApiParam(value="Record as XML. TODO: rename xml") @RequestParam(defaultValue="") String data, @ApiIgnore @ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request, HttpServletResponse response, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession) throws Exception {
        Log.trace((String)"geonetwork.datamanager", (Object)("Saving metadata editing with UUID " + metadataUuid));
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            AjaxEditUtils ajaxEditUtils = new AjaxEditUtils(context);
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            DataManager dataMan = (DataManager)applicationContext.getBean(DataManager.class);
            UserSession session = ApiUtils.getUserSession(httpSession);
            IMetadataValidator validator = (IMetadataValidator)applicationContext.getBean(IMetadataValidator.class);
            BaseMetadataStatus statusRepository = (BaseMetadataStatus)ApplicationContextHolder.get().getBean(BaseMetadataStatus.class);
            String id = String.valueOf(metadata.getId());
            Log.trace((String)"geonetwork.datamanager", (Object)(" > ID of the record to edit: " + id));
            String isTemplate = allRequestParams.get("template");
            SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
            boolean isEditor = session.getProfile().equals((Object)Profile.Editor);
            boolean isReviewer = session.getProfile().equals((Object)Profile.Reviewer);
            boolean isAdmin = session.getProfile().equals((Object)Profile.Administrator);
            boolean isEnabledWorkflow = sm.getValueAsBool("metadata/workflow/enable");
            if (isEnabledWorkflow && isEditor && !statusRepository.canEditorEdit(Integer.valueOf(metadata.getId()))) {
                throw new NotAllowedException("Editing is allowed only in Draft state for the current profile.");
            }
            Log.trace((String)"geonetwork.datamanager", (Object)" > Getting parameters from request");
            Element params = new Element("request");
            HashMap<String, String> forwardedParams = new HashMap<String, String>();
            for (Map.Entry<String, String> e : allRequestParams.entrySet()) {
                params.addContent((Content)new Element(e.getKey()).setText(e.getValue()));
                if (e.getKey().startsWith("_")) continue;
                forwardedParams.put(e.getKey(), e.getValue());
            }
            if (Log.isTraceEnabled((String)"geonetwork.datamanager")) {
                Log.trace((String)"geonetwork.datamanager", (Object)(" > Setting type of record " + MetadataType.lookup((String)isTemplate)));
            }
            int iLocalId = Integer.parseInt(id);
            Log.trace((String)"geonetwork.datamanager", (Object)(" > Id is " + iLocalId));
            dataMan.setTemplateExt(iLocalId, MetadataType.lookup((String)isTemplate));
            Log.trace((String)"geonetwork.datamanager", (Object)" > Trigger status actions based on this edit");
            StatusActionsFactory saf = (StatusActionsFactory)context.getBean(StatusActionsFactory.class);
            StatusActions statusActions = saf.createStatusActions(context);
            statusActions.onEdit(iLocalId, minor);
            Element beforeMetadata = dataMan.getMetadata(context, String.valueOf(metadata.getId()), false, false, false);
            if (StringUtils.isNotEmpty((String)data)) {
                Log.trace((String)"geonetwork.datamanager", (Object)" > Updating metadata through data manager");
                Element md = Xml.loadString((String)data, (boolean)false);
                String changeDate = null;
                boolean updateDateStamp = !minor;
                boolean ufo = true;
                boolean index = true;
                dataMan.updateMetadata(context, id, md, withValidationErrors, ufo, index, context.getLanguage(), changeDate, updateDateStamp);
                if (terminate) {
                    XMLOutputter outp = new XMLOutputter();
                    String xmlBefore = outp.outputString(beforeMetadata);
                    String xmlAfter = outp.outputString(md);
                    new RecordUpdatedEvent(Long.valueOf(Long.parseLong(id)), Integer.valueOf(session.getUserIdAsInt()), xmlBefore, xmlAfter).publish((ApplicationContext)applicationContext);
                }
            } else {
                Log.trace((String)"geonetwork.datamanager", (Object)" > Updating contents");
                ajaxEditUtils.updateContent(params, false, true);
                Element afterMetadata = dataMan.getMetadata(context, String.valueOf(metadata.getId()), false, false, false);
                if (terminate) {
                    XMLOutputter outp = new XMLOutputter();
                    String xmlBefore = outp.outputString(beforeMetadata);
                    String xmlAfter = outp.outputString(afterMetadata);
                    new RecordUpdatedEvent(Long.valueOf(Long.parseLong(id)), Integer.valueOf(session.getUserIdAsInt()), xmlBefore, xmlAfter).publish((ApplicationContext)applicationContext);
                }
            }
            if (commit && !terminate) {
                return;
            }
            if (terminate) {
                Metadata metadataApproved;
                Log.trace((String)"geonetwork.datamanager", (Object)" > Closing editor");
                boolean forceValidationOnMdSave = sm.getValueAsBool("metadata/workflow/forceValidationOnMdSave");
                boolean reindex = false;
                String lang = String.valueOf(this.languageUtils.parseAcceptLanguage(request.getLocales()));
                ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", new Locale(lang));
                if (forceValidationOnMdSave) {
                    validator.doValidate(metadata, context.getLanguage());
                    reindex = true;
                }
                if (isEnabledWorkflow) {
                    ArrayList<MetadataStatus> listOfStatusChange;
                    MetadataStatus metadataStatus;
                    StatusValue statusValue;
                    if (status.equals("4")) {
                        if (isEditor || isAdmin) {
                            Integer changeToStatus = Integer.parseInt("4");
                            statusValue = this.statusValueRepository.findOneById(changeToStatus.intValue());
                            metadataStatus = new MetadataStatus();
                            metadataStatus.setMetadataId(metadata.getId());
                            metadataStatus.setUuid(metadata.getUuid());
                            metadataStatus.setChangeDate(new ISODate());
                            metadataStatus.setUserId(session.getUserIdAsInt());
                            metadataStatus.setStatusValue(statusValue);
                            metadataStatus.setChangeMessage(messages.getString("metadata_save_submit_text"));
                            listOfStatusChange = new ArrayList<MetadataStatus>(1);
                            listOfStatusChange.add(metadataStatus);
                            statusActions.onStatusChange(listOfStatusChange, true);
                        } else {
                            throw new SecurityException(String.format("Only users with editor profile can submit.", new Object[0]));
                        }
                    }
                    if (status.equals("2")) {
                        if (isReviewer || isAdmin) {
                            Integer changeToStatus = Integer.parseInt("2");
                            statusValue = this.statusValueRepository.findOneById(changeToStatus.intValue());
                            metadataStatus = new MetadataStatus();
                            metadataStatus.setMetadataId(metadata.getId());
                            metadataStatus.setUuid(metadata.getUuid());
                            metadataStatus.setChangeDate(new ISODate());
                            metadataStatus.setUserId(session.getUserIdAsInt());
                            metadataStatus.setStatusValue(statusValue);
                            metadataStatus.setChangeMessage(messages.getString("metadata_save_approve_text"));
                            listOfStatusChange = new ArrayList(1);
                            listOfStatusChange.add(metadataStatus);
                            statusActions.onStatusChange(listOfStatusChange, true);
                        } else {
                            throw new SecurityException(String.format("Only users with review profile can approve.", new Object[0]));
                        }
                    }
                }
                boolean automaticUnpublishInvalidMd = sm.getValueAsBool("metadata/workflow/automaticUnpublishInvalidMd");
                boolean isUnpublished = false;
                if (automaticUnpublishInvalidMd) {
                    boolean isPublic;
                    OperationAllowedRepository operationAllowedRepo = (OperationAllowedRepository)context.getBean(OperationAllowedRepository.class);
                    boolean bl = isPublic = operationAllowedRepo.count((Specification)Specifications.where((Specification)OperationAllowedSpecs.hasMetadataId((String)id)).and(OperationAllowedSpecs.hasOperation((ReservedOperation)ReservedOperation.view)).and(OperationAllowedSpecs.hasGroupId((int)ReservedGroup.all.getId()))) > 0L;
                    if (isPublic) {
                        boolean isInvalid;
                        MetadataValidationRepository metadataValidationRepository = (MetadataValidationRepository)context.getBean(MetadataValidationRepository.class);
                        boolean bl2 = isInvalid = metadataValidationRepository.count(MetadataValidationSpecs.isInvalidAndRequiredForMetadata((int)Integer.parseInt(id))) > 0L;
                        if (isInvalid) {
                            isUnpublished = true;
                            operationAllowedRepo.deleteAll((Specification)Specifications.where((Specification)OperationAllowedSpecs.hasMetadataId((String)id)).and(OperationAllowedSpecs.hasGroupId((int)ReservedGroup.all.getId())));
                        }
                        reindex = true;
                    }
                }
                if (reindex) {
                    Log.trace((String)"geonetwork.datamanager", (Object)" > Reindexing record");
                    dataMan.indexMetadata(id, true, null);
                }
                if (metadata instanceof MetadataDraft && (metadataApproved = this.metadataRepository.findOneByUuid(metadata.getUuid())) != null) {
                    this.metadataIndexer.indexMetadata(String.valueOf(metadataApproved.getId()), true, null);
                }
                ajaxEditUtils.removeMetadataEmbedded(session, id);
                dataMan.endEditingSession(id, session);
                if (isEnabledWorkflow) {
                    context.getUserSession().removeProperty("metadata.editing.created.draft");
                }
                if (isUnpublished) {
                    throw new IllegalStateException(String.format("Record saved but as it was invalid at the end of the editing session. The public record '%s' was unpublished.", metadata.getUuid()));
                }
                return;
            }
            Element elMd = new AjaxEditUtils(context).getMetadataEmbedded(context, String.valueOf(id), true, withValidationErrors);
            this.buildEditorForm(tab, httpSession, forwardedParams, request, elMd, metadata.getDataInfo().getSchemaId(), context, (ApplicationContext)applicationContext, false, false, response);
            if (isEnabledWorkflow) {
                context.getUserSession().removeProperty("metadata.editing.created.draft");
            }
        }
    }

    @ApiOperation(value="Cancel edits", notes="Cancel current editing session.", nickname="cancelEdits")
    @RequestMapping(value={"/{metadataUuid}/editor"}, method={RequestMethod.DELETE}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Editing session cancelled."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public void cancelEdits(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiIgnore @ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        DataManager dataMan = (DataManager)applicationContext.getBean(DataManager.class);
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            dataMan.cancelEditingSession(context, String.valueOf(metadata.getId()));
        }
    }

    @ApiOperation(value="Add element", notes="", nickname="addElement")
    @RequestMapping(value={"/{metadataUuid}/editor/elements"}, method={RequestMethod.PUT}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Element added."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    public void addElement(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Reference of the insertion point.", required=true) @RequestParam String ref, @ApiParam(value="Name of the element to add (with prefix)", required=true) @RequestParam String name, @ApiParam(value="Use geonet:attribute for attributes or child name.", required=false) @RequestParam(required=false) String child, @ApiParam(value="Should attributes be shown on the editor snippet?", required=false) @RequestParam(defaultValue="false") boolean displayAttributes, @ApiIgnore @ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request, HttpServletResponse response, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            Element elResp = new AjaxEditUtils(context).addElementEmbedded(ApiUtils.getUserSession(httpSession), String.valueOf(metadata.getId()), ref, name, child);
            EditLib.tagForDisplay((Element)elResp);
            Element md = (Element)this.findRoot(elResp).clone();
            EditLib.removeDisplayTag((Element)elResp);
            this.buildEditorForm(allRequestParams.get("currTab"), httpSession, allRequestParams, request, md, metadata.getDataInfo().getSchemaId(), context, (ApplicationContext)applicationContext, true, true, response);
        }
    }

    @ApiOperation(value="Reorder element", notes="", nickname="reorderElement")
    @RequestMapping(value={"/{metadataUuid}/editor/elements/{direction}"}, method={RequestMethod.PUT}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(code=201, message="Element reordered."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public void addElement(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Reference of the element to move.", required=true) @RequestParam String ref, @ApiParam(value="Direction", required=true) @PathVariable Direction direction, @ApiParam(value="Should attributes be shown on the editor snippet?", required=false) @RequestParam(defaultValue="false") boolean displayAttributes, @ApiIgnore @ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            new AjaxEditUtils(context).swapElementEmbedded(ApiUtils.getUserSession(httpSession), String.valueOf(metadata.getId()), ref, direction == Direction.down);
        }
    }

    @ApiOperation(value="Delete element", notes="", nickname="deleteElement")
    @RequestMapping(value={"/{metadataUuid}/editor/elements"}, method={RequestMethod.DELETE}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Element removed."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public void deleteElement(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Reference of the element to remove.", required=true) @RequestParam String[] ref, @ApiParam(value="Name of the parent.", required=true) @RequestParam String parent, @ApiParam(value="Should attributes be shown on the editor snippet?", required=false) @RequestParam(defaultValue="false") boolean displayAttributes, HttpServletRequest request, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            String id = String.valueOf(metadata.getId());
            for (int i = 0; i < ref.length; ++i) {
                new AjaxEditUtils(context).deleteElementEmbedded(ApiUtils.getUserSession(httpSession), id, ref[i], parent);
            }
        }
    }

    @ApiOperation(value="Delete attribute", notes="", nickname="deleteAttribute")
    @RequestMapping(value={"/{metadataUuid}/editor/attributes"}, method={RequestMethod.DELETE}, consumes={"*/*"}, produces={"application/xml"})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Attribute removed."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public void deleteAttribute(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Reference of the attribute to remove.", required=true) @RequestParam String ref, @ApiParam(value="Should attributes be shown on the editor snippet?", required=false) @RequestParam(defaultValue="false") boolean displayAttributes, HttpServletRequest request, @ApiIgnore @ApiParam(hidden=true) HttpSession httpSession) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            new AjaxEditUtils(context).deleteAttributeEmbedded(ApiUtils.getUserSession(httpSession), String.valueOf(metadata.getId()), ref);
        }
    }

    private Element findRoot(Element element) {
        if (element.isRootElement() || element.getParentElement() == null) {
            return element;
        }
        return this.findRoot(element.getParentElement());
    }

    private void buildEditorForm(String tab, HttpSession session, Map<String, String> allRequestParams, HttpServletRequest request, Element xml, String schema, ServiceContext context, ApplicationContext applicationContext, boolean isEmbedded, boolean embedded, HttpServletResponse response) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        Element root = this.buildResourceDocument(applicationContext, context, userSession);
        root.addContent((Content)xml);
        Element gui = root.getChild("gui");
        gui.addContent((Content)new Element("currTab").setText(tab));
        gui.addContent((Content)new Element("reqService").setText(embedded ? "embedded" : "md.edit"));
        String iso3langCode = this.languageUtils.iso3code(request.getLocales());
        gui.addContent((Content)new Element("language").setText(iso3langCode));
        gui.addContent((Content)this.getSchemaStrings(schema, context));
        Element requestParams = new Element("request");
        for (Map.Entry<String, String> e : allRequestParams.entrySet()) {
            requestParams.addContent((Content)new Element(e.getKey()).setText(e.getValue()));
        }
        root.addContent((Content)requestParams);
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class);
        Path xslt = dataDirectory.getWebappDir().resolve(isEmbedded ? "xslt/ui-metadata/edit/edit-embedded.xsl" : "xslt/ui-metadata/edit/edit.xsl");
        Xml.transformXml((Element)root, (Path)xslt, (OutputStream)response.getOutputStream());
    }

    private Element buildResourceDocument(ApplicationContext applicationContext, ServiceContext context, UserSession userSession) throws JDOMException, SQLException, IOException {
        Element root = new Element("root");
        Element gui = new Element("gui");
        gui.addContent((Content)((SettingManager)applicationContext.getBean(SettingManager.class)).getAllAsXML(true));
        gui.addContent((Content)Get.getSessionAsXML((UserSession)userSession));
        ThesaurusManager th = (ThesaurusManager)applicationContext.getBean(ThesaurusManager.class);
        gui.addContent((Content)new Element("thesaurus").addContent((Content)th.buildResultfromThTable(context)));
        root.addContent((Content)gui);
        return root;
    }

    public Element getSchemaStrings(String schemaToLoad, ServiceContext context) throws Exception {
        Element schemas = new Element("schemas");
        for (String schema : this.schemaManager.getSchemas()) {
            if (!schema.equals(schemaToLoad) && !schemaToLoad.startsWith(schema) && !this.schemaManager.getDependencies(schemaToLoad).contains(schema)) continue;
            try {
                Map schemaInfo = this.schemaManager.getSchemaInfo(schema);
                for (Map.Entry entry : schemaInfo.entrySet()) {
                    XmlFile xf = (XmlFile)entry.getValue();
                    String fname = (String)entry.getKey();
                    Element response = xf.exec(new Element("junk"), context);
                    response.setName(FilenameUtils.removeExtension((String)fname));
                    response.removeAttribute("noNamespaceSchemaLocation", Geonet.Namespaces.XSI);
                    Element schemaElem = new Element(schema);
                    schemaElem.addContent((Content)response);
                    schemas.addContent((Content)schemaElem);
                }
            }
            catch (Exception e) {
                context.error("Failed to load localization file for schema " + schema + ": " + e.getMessage());
                context.error((Throwable)e);
            }
        }
        return schemas;
    }
}

