/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerConfigurationException;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.exception.WebApplicationException;
import org.fao.geonet.api.processing.XslProcessUtils;
import org.fao.geonet.api.processing.report.XsltMetadataProcessingReport;
import org.fao.geonet.api.records.model.suggestion.SuggestionType;
import org.fao.geonet.api.records.model.suggestion.SuggestionsType;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.events.history.RecordProcessingChangeEvent;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="recordProcessing")
@ReadWriteController
public class MetadataProcessApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    DataManager dm;
    @Autowired
    SettingManager sm;
    public static final String XSL_SUGGEST_FILE = "suggest.xsl";

    @ApiOperation(value="Get suggestions", notes="Analyze the record an suggest processes to improve the quality of the record.<br/><a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/workflow/batchupdate-xsl.html'>More info</a>", nickname="getSuggestions")
    @RequestMapping(value={"/{metadataUuid}/processes"}, method={RequestMethod.GET}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Record suggestions."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public List<SuggestionType> getSuggestions(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        Throwable throwable = null;
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            HashMap<String, String> xslParameter = new HashMap<String, String>();
            xslParameter.put("guiLang", request.getLocale().getISO3Language());
            xslParameter.put("siteUrl", this.sm.getSiteURL(context));
            xslParameter.put("nodeUrl", this.sm.getNodeURL());
            xslParameter.put("baseUrl", context.getBaseUrl());
            xslParameter.put("action", "analyze");
            MetadataSchema metadataSchema = this.dm.getSchema(metadata.getDataInfo().getSchemaId());
            Path xslProcessing = metadataSchema.getSchemaDir().resolve(XSL_SUGGEST_FILE);
            if (Files.exists(xslProcessing, new LinkOption[0])) {
                Element xmlSuggestions;
                boolean forEditing = false;
                boolean withValidationErrors = false;
                boolean keepXlinkAttributes = false;
                Element md = this.dm.getMetadata(context, String.valueOf(metadata.getId()), forEditing, withValidationErrors, keepXlinkAttributes);
                try {
                    xmlSuggestions = Xml.transform((Element)md, (Path)xslProcessing, xslParameter);
                }
                catch (TransformerConfigurationException e) {
                    throw new WebApplicationException(String.format("Error while retrieving suggestion for record '%s'. Check your suggest.xsl process (and all its imports).", metadataUuid, xslProcessing), (Throwable)e);
                }
                SuggestionsType suggestions = (SuggestionsType)Xml.unmarshall((Element)xmlSuggestions, SuggestionsType.class);
                List<SuggestionType> list = suggestions.getSuggestion();
                return list;
            }
            try {
                throw new ResourceNotFoundException(String.format("No %s files available in schema '%s'. No suggestion to provides.", XSL_SUGGEST_FILE, metadata.getDataInfo().getSchemaId()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @ApiOperation(value="Preview process result", notes="Process a metadata with an XSL transformation declared in the metadata schema (See the process folder). Parameters sent to the service are forwarded to XSL process.", nickname="processRecordPreview")
    @RequestMapping(value={"/{metadataUuid}/processes/{process}"}, method={RequestMethod.GET}, produces={"application/xml"})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="A preview of the processed record."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public ResponseEntity<Element> processRecordPreview(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Process identifier") @PathVariable String process, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            boolean save = request.getMethod().equals("POST");
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            XsltMetadataProcessingReport report = new XsltMetadataProcessingReport(process);
            Element processedMetadata = this.process((ApplicationContext)applicationContext, process, request, metadata, save, context, this.sm, report);
            ResponseEntity responseEntity = new ResponseEntity((Object)processedMetadata, HttpStatus.OK);
            return responseEntity;
        }
    }

    @ApiOperation(value="Apply a process", notes="Process a metadata with an XSL transformation declared in the metadata schema (See the process folder). Parameters sent to the service are forwarded to XSL process.", nickname="processRecord")
    @RequestMapping(value={"/{metadataUuid}/processes/{process}"}, method={RequestMethod.POST}, produces={"application/xml"})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=204, message="Record processed and saved."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public ResponseEntity processRecord(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Process identifier") @PathVariable String process, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            boolean save = true;
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            XsltMetadataProcessingReport report = new XsltMetadataProcessingReport(process);
            this.process((ApplicationContext)applicationContext, process, request, metadata, save, context, this.sm, report);
            ResponseEntity responseEntity = new ResponseEntity(HttpStatus.NO_CONTENT);
            return responseEntity;
        }
    }

    private Element process(ApplicationContext applicationContext, String process, HttpServletRequest request, AbstractMetadata metadata, boolean save, ServiceContext context, SettingManager sm, XsltMetadataProcessingReport report) throws Exception {
        boolean forEditing = false;
        boolean withValidationErrors = false;
        boolean keepXlinkAttributes = true;
        Element beforeMetadata = this.dm.getMetadata(context, Integer.toString(metadata.getId()), false, false, false);
        String siteURL = sm.getSiteURL(context);
        Element processedMetadata = XslProcessUtils.process(context, String.valueOf(metadata.getId()), process, save, true, true, report, siteURL, request.getParameterMap());
        if (processedMetadata == null) {
            throw new BadParameterEx("Processing failed", (Object)("Not found:" + report.getNumberOfRecordNotFound() + ", Not owner:" + report.getNumberOfRecordsNotEditable() + ", No process found:" + report.getNoProcessFoundCount() + "."));
        }
        UserSession userSession = context.getUserSession();
        if (userSession != null) {
            XMLOutputter outp = new XMLOutputter();
            String xmlAfter = outp.outputString(processedMetadata);
            String xmlBefore = outp.outputString(beforeMetadata);
            new RecordProcessingChangeEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(Integer.parseInt(userSession.getUserId())), xmlBefore, xmlAfter, process).publish((ApplicationContext)ApplicationContextHolder.get());
        }
        return processedMetadata;
    }
}

