/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.links;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import jeeves.transaction.TransactionManager;
import jeeves.transaction.TransactionTask;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.kernel.url.UrlAnalyzer;
import org.fao.geonet.repository.LinkRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.context.ApplicationContext;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.transaction.TransactionStatus;

@ManagedResource
public class MAnalyseProcess
implements SelfNaming {
    private final ApplicationContext appContext;
    private LinkRepository linkRepository;
    private MetadataRepository metadataRepository;
    private UrlAnalyzer urlAnalyser;
    private ObjectName probeName;
    private int metadataToAnalyseCount = -1;
    private int metadataAnalysed = 0;
    private int metadataNotAnalysedInError = 0;
    private int urlToCheckCount = -1;
    private AtomicInteger urlChecked = new AtomicInteger(0);
    private long deleteAllDate = Long.MAX_VALUE;
    private long analyseMdDate = Long.MAX_VALUE;
    private long testLinkDate = Long.MAX_VALUE;

    @ManagedAttribute
    public int getMetadataToAnalyseCount() {
        return this.metadataToAnalyseCount;
    }

    @ManagedAttribute
    public int getUrlToCheckCount() {
        return this.urlToCheckCount;
    }

    @ManagedAttribute
    public int getMetadataAnalysed() {
        return this.metadataAnalysed;
    }

    @ManagedAttribute
    public int getUrlChecked() {
        return this.urlChecked.get();
    }

    @ManagedAttribute
    public int getMetadataNotAnalysedInError() {
        return this.metadataNotAnalysedInError;
    }

    @ManagedAttribute
    public long getDeleteAllDate() {
        return this.deleteAllDate;
    }

    @ManagedAttribute
    public long getAnalyseMdDate() {
        return this.analyseMdDate;
    }

    @ManagedAttribute
    public long getTestLinkDate() {
        return this.testLinkDate;
    }

    @ManagedAttribute
    public ObjectName getObjectName() {
        return this.probeName;
    }

    public MAnalyseProcess(LinkRepository linkRepository, MetadataRepository metadataRepository, UrlAnalyzer urlAnalyser, ApplicationContext appContext) {
        this.linkRepository = linkRepository;
        this.metadataRepository = metadataRepository;
        this.urlAnalyser = urlAnalyser;
        this.appContext = appContext;
        try {
            this.probeName = new ObjectName(String.format("geonetwork:name=url-check,idx=%s", this.hashCode()));
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
    }

    public void deleteAll() {
        this.runInNewTransaction("manalyseprocess-deleteall", new TransactionTask<Object>(){

            public Object doInTransaction(TransactionStatus transaction) throws Throwable {
                MAnalyseProcess.this.deleteAllDate = System.currentTimeMillis();
                MAnalyseProcess.this.urlAnalyser.deleteAll();
                return null;
            }
        });
    }

    public void processMetadataAndTestLink(boolean testLink, Set<Integer> ids) throws JDOMException, IOException {
        this.metadataToAnalyseCount = ids.size();
        this.analyseMdDate = System.currentTimeMillis();
        for (int i : ids) {
            try {
                final Metadata metadata = (Metadata)this.metadataRepository.findOne((Serializable)Integer.valueOf(i));
                final Element xmlData = metadata.getXmlData(false);
                this.runInNewTransaction("manalyseprocess-process-metadata", new TransactionTask<Object>(){

                    public Object doInTransaction(TransactionStatus transaction) throws Throwable {
                        try {
                            MAnalyseProcess.this.urlAnalyser.processMetadata(xmlData, (AbstractMetadata)metadata);
                            MAnalyseProcess.this.metadataAnalysed++;
                        }
                        catch (Exception e) {
                            MAnalyseProcess.this.metadataNotAnalysedInError++;
                            e.printStackTrace();
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                ++this.metadataNotAnalysedInError;
                e.printStackTrace();
            }
        }
        if (testLink) {
            this.runInNewTransaction("manalyseprocess-testlink", new TransactionTask<Object>(){

                public Object doInTransaction(TransactionStatus transaction) throws Throwable {
                    MAnalyseProcess.this.testLinkDate = System.currentTimeMillis();
                    List all = MAnalyseProcess.this.linkRepository.findAll();
                    MAnalyseProcess.this.urlToCheckCount = all.size();
                    all.parallelStream().peek(arg_0 -> ((UrlAnalyzer)MAnalyseProcess.this.urlAnalyser).testLink(arg_0)).forEach(x -> MAnalyseProcess.this.urlChecked.getAndIncrement());
                    return null;
                }
            });
        }
    }

    private final void runInNewTransaction(String name, TransactionTask<Object> transactionTask) {
        TransactionManager.runInTransaction((String)name, (ApplicationContext)this.appContext, (TransactionManager.TransactionRequirement)TransactionManager.TransactionRequirement.CREATE_NEW, (TransactionManager.CommitBehavior)TransactionManager.CommitBehavior.ALWAYS_COMMIT, (boolean)false, transactionTask);
    }
}

