/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.io.IOException;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.geotools.util.LineWriter;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class MonolineFormatter
extends Formatter {
    private static final String PREFIX = "";
    private static final String SUFFIX = " - ";
    private static final int DEFAULT_WIDTH = 9;
    private static final int NO_SOURCE = 0;
    private static final int NO_SOURCE_EX = 1;
    private static final int LOGGER_SHORT = 2;
    private static final int LOGGER_LONG = 3;
    private static final int CLASS_SHORT = 4;
    private static final int CLASS_LONG = 5;
    private static String[] FORMAT_LABELS = new String[6];
    private final String lineSeparator;
    private String bodyLineSeparator;
    private final int margin;
    private final long startMillis;
    private SimpleDateFormat timeFormat;
    private int sourceFormat;
    private final StringBuffer buffer;
    private final LineWriter writer;

    public MonolineFormatter() {
        this.bodyLineSeparator = this.lineSeparator = System.getProperty("line.separator", "\n");
        this.timeFormat = null;
        this.sourceFormat = 0;
        this.startMillis = System.currentTimeMillis();
        this.margin = 9;
        StringWriter str = new StringWriter();
        this.writer = new LineWriter(str);
        this.buffer = str.getBuffer();
        this.buffer.append(PREFIX);
        LogManager manager = LogManager.getLogManager();
        String classname = MonolineFormatter.class.getName();
        try {
            this.setTimeFormat(manager.getProperty(classname + ".time"));
        }
        catch (IllegalArgumentException exception) {
            System.err.println(exception);
        }
        try {
            this.setSourceFormat(manager.getProperty(classname + ".source"));
        }
        catch (IllegalArgumentException exception) {
            System.err.println(exception);
        }
    }

    public synchronized void setTimeFormat(String pattern) {
        if (pattern == null) {
            this.timeFormat = null;
        } else if (this.timeFormat == null) {
            this.timeFormat = new SimpleDateFormat(pattern);
            this.timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            this.timeFormat.applyPattern(pattern);
        }
    }

    public synchronized String getTimeFormat() {
        return this.timeFormat != null ? this.timeFormat.toPattern() : null;
    }

    public synchronized void setSourceFormat(String format) {
        if (format != null) {
            format = format.trim().toLowerCase();
        }
        for (int i = 0; i < FORMAT_LABELS.length; ++i) {
            if (!Utilities.equals(FORMAT_LABELS[i], format)) continue;
            this.sourceFormat = i;
            return;
        }
        throw new IllegalArgumentException(format);
    }

    public synchronized String getSourceFormat() {
        return FORMAT_LABELS[this.sourceFormat];
    }

    @Override
    public synchronized String format(LogRecord record) {
        this.buffer.setLength(PREFIX.length());
        if (this.timeFormat != null) {
            Date time = new Date(Math.max(0L, record.getMillis() - this.startMillis));
            this.timeFormat.format(time, this.buffer, new FieldPosition(0));
            this.buffer.append(' ');
        }
        int offset = this.buffer.length();
        this.buffer.append(record.getLevel().getLocalizedName());
        offset = this.buffer.length() - offset;
        this.buffer.append(Utilities.spaces(this.margin - offset));
        String logger = record.getLoggerName();
        String classname = record.getSourceClassName();
        switch (this.sourceFormat) {
            case 2: {
                int pos = logger.lastIndexOf(46);
                if (pos >= 0) {
                    logger = logger.substring(pos);
                }
            }
            case 3: {
                this.buffer.append(' ');
                this.buffer.append(logger);
                break;
            }
            case 4: {
                int dot = classname.lastIndexOf(46);
                if (dot >= 0) {
                    classname = classname.substring(dot + 1);
                }
                classname = classname.replace('$', '.');
            }
            case 5: {
                this.buffer.append(' ');
                this.buffer.append(classname);
            }
        }
        this.buffer.append(SUFFIX);
        int margin = this.buffer.length();
        assert (margin >= this.margin);
        if (this.bodyLineSeparator.length() != this.lineSeparator.length() + margin) {
            this.bodyLineSeparator = this.lineSeparator + Utilities.spaces(margin);
        }
        try {
            this.writer.setLineSeparator(this.bodyLineSeparator);
            this.writer.write(String.valueOf(this.formatMessage(record)));
            this.writer.setLineSeparator(this.lineSeparator);
            this.writer.write(10);
            this.writer.flush();
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
        return this.buffer.toString();
    }

    public static MonolineFormatter configureConsoleHandler(Logger logger, Level level) {
        MonolineFormatter monoline = null;
        boolean foundConsoleHandler = false;
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            if (!handler.getClass().equals(ConsoleHandler.class)) continue;
            foundConsoleHandler = true;
            Formatter formatter = handler.getFormatter();
            if (formatter instanceof MonolineFormatter) {
                if (monoline != null) continue;
                monoline = (MonolineFormatter)formatter;
                if (level == null) continue;
                handler.setLevel(level);
                continue;
            }
            if (!formatter.getClass().equals(SimpleFormatter.class)) continue;
            if (monoline == null) {
                monoline = new MonolineFormatter();
            }
            try {
                handler.setFormatter(monoline);
                if (level == null) continue;
                handler.setLevel(level);
                continue;
            }
            catch (SecurityException exception) {
                MonolineFormatter.unexpectedException(exception);
            }
        }
        Logger parent = logger;
        while (parent.getUseParentHandlers() && (parent = parent.getParent()) != null) {
            handlers = parent.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                Handler handler = handlers[i];
                if (handler.getClass().equals(ConsoleHandler.class)) {
                    if (!foundConsoleHandler) continue;
                    foundConsoleHandler = true;
                    Formatter formatter = handler.getFormatter();
                    if (formatter.getClass().equals(SimpleFormatter.class)) {
                        monoline = MonolineFormatter.addHandler(logger, level);
                        continue;
                    }
                }
                logger.addHandler(handler);
            }
        }
        logger.setUseParentHandlers(false);
        if (!foundConsoleHandler) {
            monoline = MonolineFormatter.addHandler(logger, level);
        }
        return monoline;
    }

    private static MonolineFormatter addHandler(Logger logger, Level level) {
        MonolineFormatter monoline = new MonolineFormatter();
        try {
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(monoline);
            if (level != null) {
                handler.setLevel(level);
            }
            logger.addHandler(handler);
        }
        catch (SecurityException exception) {
            MonolineFormatter.unexpectedException(exception);
        }
        return monoline;
    }

    private static void unexpectedException(Exception exception) {
        Logging.unexpectedException(MonolineFormatter.class, "configureConsoleHandler", exception);
    }

    static {
        MonolineFormatter.FORMAT_LABELS[1] = "none";
        MonolineFormatter.FORMAT_LABELS[2] = "logger:short";
        MonolineFormatter.FORMAT_LABELS[3] = "logger:long";
        MonolineFormatter.FORMAT_LABELS[4] = "class:short";
        MonolineFormatter.FORMAT_LABELS[5] = "class:long";
    }
}

