/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import org.geotools.util.NIOUtilities;
import org.geotools.util.WeakCollectionCleaner;

class BufferSoftReference
extends SoftReference<ByteBuffer> {
    public BufferSoftReference(ByteBuffer referent) {
        super(referent, WeakCollectionCleaner.DEFAULT.getReferenceQueue());
    }

    @Override
    public void clear() {
        ByteBuffer buffer = (ByteBuffer)this.get();
        NIOUtilities.clean(buffer);
        super.clear();
    }

    public boolean equals(Object other) {
        if (!(other instanceof BufferSoftReference)) {
            return false;
        }
        ByteBuffer buffer = (ByteBuffer)this.get();
        if (buffer == null) {
            return false;
        }
        ByteBuffer otherBuffer = (ByteBuffer)((BufferSoftReference)other).get();
        if (otherBuffer == null) {
            return false;
        }
        return otherBuffer == buffer;
    }

    public int hashCode() {
        ByteBuffer byteBuffer = (ByteBuffer)this.get();
        if (byteBuffer != null) {
            return byteBuffer.hashCode();
        }
        return super.hashCode();
    }
}

