/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.webapp;

import com.yammer.metrics.core.HealthCheck;
import com.yammer.metrics.core.HealthCheckRegistry;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.SortedMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

public class GeonetworkHealthCheckServlet
extends HttpServlet {
    public static final String REGISTRY_ATTRIBUTE_KEY = "REGISTRY_ATTRIBUTE_KEY";
    private static final long serialVersionUID = 5367584489771010404L;
    private static final String CONTENT_TYPE = "application/json";
    private transient HealthCheckRegistry registry;

    private static boolean isAllHealthy(Map<String, HealthCheck.Result> results) {
        for (HealthCheck.Result result : results.values()) {
            if (result.isHealthy()) continue;
            return false;
        }
        return true;
    }

    public void init(ServletConfig config) throws ServletException {
        String registryAttribute = config.getInitParameter(REGISTRY_ATTRIBUTE_KEY);
        this.registry = (HealthCheckRegistry)config.getServletContext().getAttribute(registryAttribute);
        if (this.registry == null) {
            throw new IllegalStateException("Expected a HealthCheckRegistery to be registered in the ServletContext attributes but there was none");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SortedMap results = this.registry.runHealthChecks();
        resp.setContentType(CONTENT_TYPE);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        PrintWriter writer = resp.getWriter();
        Element report = new Element("report");
        if (results.isEmpty()) {
            resp.setStatus(200);
            report.addContent((Content)new Element("msg").setText("No health checks registered."));
        } else {
            if (GeonetworkHealthCheckServlet.isAllHealthy(results)) {
                resp.setStatus(200);
            } else {
                resp.setStatus(500);
            }
            for (Map.Entry entry : results.entrySet()) {
                Element healthcheck = new Element("healthcheck");
                HealthCheck.Result result = (HealthCheck.Result)entry.getValue();
                healthcheck.addContent((Content)new Element("name").setText((String)entry.getKey()));
                if (result.isHealthy()) {
                    healthcheck.addContent((Content)new Element("status").setText("OK"));
                    if (result.getMessage() != null) {
                        healthcheck.addContent((Content)new Element("msg").setText(result.getMessage()));
                    }
                } else {
                    Throwable error;
                    healthcheck.addContent((Content)new Element("status").setText("ERROR"));
                    if (result.getMessage() != null) {
                        healthcheck.addContent((Content)new Element("msg").setText(result.getMessage()));
                    }
                    if ((error = result.getError()) != null) {
                        healthcheck.addContent((Content)new Element("exception").setText(ExceptionUtils.getStackTrace((Throwable)error)));
                    }
                }
                report.addContent((Content)healthcheck);
            }
            writer.println(Xml.getJSON((Element)report));
        }
        writer.close();
    }
}

