/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.health;

import com.yammer.metrics.core.HealthCheck;
import jeeves.monitor.HealthCheckFactory;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SearcherType;
import org.jdom.Content;
import org.jdom.Element;

public class NoIndexErrorsHealthCheck
implements HealthCheckFactory {
    public HealthCheck create(final ServiceContext context) {
        return new HealthCheck(this.getClass().getSimpleName()){

            protected HealthCheck.Result check() throws Exception {
                GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
                SearchManager searchMan = (SearchManager)gc.getBean(SearchManager.class);
                ServiceConfig config = new ServiceConfig();
                config.setValue("resultType", "hits");
                try (MetaSearcher metaSearcher = searchMan.newSearcher(SearcherType.LUCENE, "lucene.xsl");){
                    Element request = new Element("request").addContent((Content)new Element("fast").setText("true")).addContent((Content)new Element("_indexingError").setText("1")).addContent((Content)new Element("from").setText("1")).addContent((Content)new Element("to").setText("50"));
                    metaSearcher.search(context, request, config);
                    if (metaSearcher.getSize() > 0) {
                        HealthCheck.Result result = HealthCheck.Result.unhealthy((String)("Found " + metaSearcher.getSize() + " metadata that had errors during indexing"));
                        return result;
                    }
                    HealthCheck.Result result = HealthCheck.Result.healthy();
                    return result;
                }
            }
        };
    }
}

