/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.util.ArrayList;
import java.util.List;
import org.geotools.brewer.styling.builder.AbstractSLDBuilder;
import org.geotools.brewer.styling.builder.FeatureTypeConstraintBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.brewer.styling.builder.StyledLayerDescriptorBuilder;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.Style;

public class NamedLayerBuilder
extends AbstractSLDBuilder<NamedLayer> {
    List<FeatureTypeConstraintBuilder> featureTypeConstraint = new ArrayList<FeatureTypeConstraintBuilder>();
    private String name;
    List<StyleBuilder> styles = new ArrayList<StyleBuilder>();

    public NamedLayerBuilder() {
        this(null);
    }

    public NamedLayerBuilder(AbstractSLDBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public NamedLayerBuilder name(String name) {
        this.unset = false;
        this.name = name;
        return this;
    }

    public StyleBuilder style() {
        this.unset = false;
        StyleBuilder sb = new StyleBuilder(this);
        this.styles.add(sb);
        return sb;
    }

    @Override
    public NamedLayer build() {
        if (this.unset) {
            return null;
        }
        NamedLayer layer = this.sf.createNamedLayer();
        layer.setName(this.name);
        ArrayList<FeatureTypeConstraint> list = new ArrayList<FeatureTypeConstraint>();
        for (FeatureTypeConstraintBuilder constraint : this.featureTypeConstraint) {
            list.add(constraint.build());
        }
        layer.layerFeatureConstraints().addAll(list);
        for (StyleBuilder sb : this.styles) {
            layer.addStyle(sb.build());
        }
        if (this.parent == null) {
            this.reset();
        }
        return layer;
    }

    public NamedLayerBuilder reset() {
        this.unset = false;
        this.name = null;
        this.featureTypeConstraint.clear();
        return this;
    }

    public NamedLayerBuilder reset(NamedLayer layer) {
        if (layer == null) {
            return this.unset();
        }
        this.name = layer.getName();
        this.featureTypeConstraint.clear();
        if (layer.layerFeatureConstraints() != null) {
            for (FeatureTypeConstraint featureConstraint : layer.layerFeatureConstraints()) {
                this.featureTypeConstraint.add(new FeatureTypeConstraintBuilder(this).reset(featureConstraint));
            }
        }
        this.styles.clear();
        for (Style style : layer.getStyles()) {
            this.styles.add(new StyleBuilder().reset(style));
        }
        this.unset = false;
        return this;
    }

    @Override
    public NamedLayerBuilder unset() {
        return (NamedLayerBuilder)super.unset();
    }

    @Override
    protected void buildSLDInternal(StyledLayerDescriptorBuilder sb) {
        sb.namedLayer().init(this);
    }
}

