/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util.spring;

import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

public final class AutowiringSpringBeanJobFactory
extends SpringBeanJobFactory
implements ApplicationContextAware {
    private transient AutowireCapableBeanFactory beanFactory;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
        this.beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
    }

    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        if (this.beanFactory == null) {
            throw new IllegalStateException("beanFactory must be initialized before callin createJobInstance");
        }
        bundle.getJobDetail().getJobDataMap().put("applicationContext", (Object)this.applicationContext);
        Object job = super.createJobInstance(bundle);
        this.beanFactory.autowireBean(job);
        return job;
    }
}

