/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.util.z3950.jzkitextensions;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.springframework.context.ApplicationContext;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;
import org.z3950.zing.cql.CQLPrefixNode;
import org.z3950.zing.cql.CQLProxNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLTermNode;

public class GNCQLString
implements QueryModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private static String default_qualifier = "cql.serverChoice";
    private transient Log log = LogFactory.getLog(GNCQLString.class);
    private InternalModelRootNode internal_model = null;
    private transient CQLNode cql_root;

    public GNCQLString(String the_cql_string) {
        try {
            CQLParser parser = new CQLParser();
            this.cql_root = parser.parse(the_cql_string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Parsed CQL");
            }
        }
        catch (CQLParseException cqle) {
            this.log.warn((Object)"Problem parsing CQL", (Throwable)cqle);
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Problem parsing CQL", (Throwable)ioe);
        }
    }

    public GNCQLString(CQLNode cql_root) {
        this.cql_root = cql_root;
    }

    public InternalModelRootNode toInternalQueryModel(ApplicationContext ctx) throws InvalidQueryException {
        if (this.internal_model == null) {
            this.internal_model = new InternalModelRootNode(this.translate(this.cql_root));
        }
        return this.internal_model;
    }

    private QueryNode translate(CQLNode cql_node) {
        ComplexNode result = null;
        if (cql_node instanceof CQLBooleanNode) {
            CQLBooleanNode cbn = (CQLBooleanNode)cql_node;
            if (cbn instanceof CQLAndNode) {
                result = new ComplexNode(this.translate(cbn.left), this.translate(cbn.right), 1);
            } else if (cbn instanceof CQLOrNode) {
                result = new ComplexNode(this.translate(cbn.left), this.translate(cbn.right), 2);
            } else if (cbn instanceof CQLNotNode) {
                result = new ComplexNode(this.translate(cbn.left), this.translate(cbn.right), 3);
            } else if (cbn instanceof CQLProxNode) {
                result = new ComplexNode(this.translate(cbn.left), this.translate(cbn.right), 4);
            }
        } else if (cql_node instanceof CQLTermNode) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Warning: We should properly translate the CQLTermNode");
            }
            CQLTermNode cql_term_node = (CQLTermNode)cql_node;
            AttrPlusTermNode aptn = new AttrPlusTermNode();
            this.processCQLTermNode(aptn, cql_term_node);
            result = aptn;
        } else if (cql_node instanceof CQLPrefixNode) {
            CQLPrefixNode pn = (CQLPrefixNode)cql_node;
            result = new InternalModelNamespaceNode(pn.prefix.name, this.translate(((CQLPrefixNode)cql_node).subtree));
        }
        return result;
    }

    protected void processCQLTermNode(AttrPlusTermNode aptn, CQLTermNode cql_term_node) {
        aptn.setTerm((Object)cql_term_node.getTerm());
        String qualifier = cql_term_node.getQualifier();
        if (qualifier != null && qualifier.length() > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using supplied qualifier : " + qualifier));
            }
            aptn.setAttr("AccessPoint", (Object)this.process(qualifier));
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Using default qualifier");
            }
            aptn.setAttr("AccessPoint", (Object)this.process(default_qualifier));
        }
        CQLRelation relation = cql_term_node.getRelation();
        if (relation != null && relation.getBase() != null) {
            if (relation.getBase().equalsIgnoreCase("scr")) {
                aptn.setAttr("Relation", (Object)new AttrValue("="));
            } else if (relation.getBase().equalsIgnoreCase("exact")) {
                aptn.setAttr("Relation", (Object)new AttrValue("="));
            } else if (relation.getBase().equalsIgnoreCase("all")) {
                aptn.setAttr("Relation", (Object)new AttrValue("="));
            } else if (relation.getBase().equalsIgnoreCase("any")) {
                aptn.setAttr("Relation", (Object)new AttrValue("="));
            } else {
                aptn.setAttr("Relation", (Object)new AttrValue(relation.getBase()));
            }
        }
    }

    private AttrValue process(String s) {
        AttrValue result = null;
        if (s != null && s.length() > 0) {
            String[] components = s.split("\\.");
            result = components.length == 1 ? new AttrValue(components[0]) : (components.length == 2 ? new AttrValue(components[0], components[1]) : new AttrValue(s));
        }
        return result;
    }

    public String toString() {
        if (this.cql_root != null) {
            return this.cql_root.toCQL();
        }
        return "";
    }
}

