/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jeeves.interfaces.Service;
import org.fao.geonet.utils.Log;

public abstract class MailSendingService
implements Service {
    protected boolean sendMail(String host, int port, String subject, String from, String to, String content, String protocol) throws MessagingException {
        boolean isSendout;
        Properties props = new Properties();
        props.put("mail.transport.protocol", protocol);
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", (Object)port);
        props.put("mail.smtp.auth", "false");
        Session mailSession = Session.getDefaultInstance((Properties)props);
        try {
            MimeMessage msg = new MimeMessage(mailSession);
            msg.setFrom((Address)new InternetAddress(from));
            msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            msg.setSentDate(new Date());
            msg.setSubject(subject);
            msg.setText(content);
            Transport.send((Message)msg);
            isSendout = true;
        }
        catch (AddressException e) {
            isSendout = false;
            Log.error((String)"jeeves.service", (Object)e.getMessage(), (Throwable)e);
        }
        catch (MessagingException e) {
            isSendout = false;
            Log.error((String)"jeeves.service", (Object)e.getMessage(), (Throwable)e);
        }
        return isSendout;
    }
}

