/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.security.web.csrf;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class GeonetworkCsrfSecurityRequestMatcher
implements RequestMatcher {
    private Pattern allowedMethods = Pattern.compile("^(GET|HEAD|TRACE|OPTIONS)$");
    private RegexRequestMatcher unprotectedMatcher;
    private Set<RequestMatcher> otherMatchers = new LinkedHashSet<RequestMatcher>();

    public GeonetworkCsrfSecurityRequestMatcher(Set<String> unprotectedUrlPatterns) {
        this.unprotectedMatcher = new RegexRequestMatcher(String.join((CharSequence)"|", unprotectedUrlPatterns), null);
    }

    public void addRequestMatcher(RequestMatcher ... matcher) {
        Assert.notNull((Object)matcher, (String)"To add additional matchers the parameter matcher cannot be null");
        this.otherMatchers.addAll(Arrays.asList(matcher));
    }

    public boolean matches(HttpServletRequest request) {
        boolean result = true;
        if (this.allowedMethods.matcher(request.getMethod()).matches()) {
            result = false;
        }
        if (result) {
            boolean bl = result = !this.unprotectedMatcher.matches(request);
        }
        if (result && !this.otherMatchers.isEmpty()) {
            result = this.otherMatchers.stream().anyMatch(matcher -> matcher.matches(request));
        }
        return result;
    }
}

