/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.setting;

import java.util.Calendar;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.kernel.setting.Settings;

public class SettingInfo {
    public String getSiteName() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        return settingManager.getSiteName();
    }

    public String getSiteUrl() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String protocol = settingManager.getValue("system/server/protocol");
        String host = settingManager.getValue("system/server/host");
        Integer configuredPort = this.toIntOrNull("system/server/port");
        Integer port = configuredPort != null ? configuredPort : (protocol.equalsIgnoreCase("https") ? Integer.valueOf(443) : Integer.valueOf(80));
        StringBuffer sb = new StringBuffer(protocol + "://");
        sb.append(host);
        if (SettingManager.isPortRequired(protocol, port + "")) {
            sb.append(":");
            sb.append(port);
        }
        return sb.toString();
    }

    private Integer toIntOrNull(String key) {
        try {
            SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
            return Integer.parseInt(settingManager.getValue(key));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getSelectionMaxRecords() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String value = settingManager.getValue("system/selectionmanager/maxrecords");
        if (value == null) {
            value = "10000";
        }
        return value;
    }

    public boolean getAutoDetect() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String value = settingManager.getValue("system/autodetect/enable");
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public SearchRequestLanguage getRequestedLanguageOnly() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String value = settingManager.getValue("system/requestedLanguage/only");
        return SearchRequestLanguage.find(value);
    }

    public boolean getRequestedLanguageOnTop() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String value = settingManager.getValue("system/requestedLanguage/sorted");
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public boolean getLuceneIndexOptimizerSchedulerEnabled() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String value = settingManager.getValue("system/indexoptimizer/enable");
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public boolean isXLinkResolverEnabled() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String value = settingManager.getValue("system/xlinkResolver/enable");
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public boolean isSearchStatsEnabled() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String value = settingManager.getValue("system/searchStats/enable");
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    public Calendar getLuceneIndexOptimizerSchedulerAt() throws IllegalArgumentException {
        Calendar calendar = Calendar.getInstance();
        try {
            SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
            calendar.set(0, 0, 0, Integer.parseInt(settingManager.getValue("system/indexoptimizer/at/hour")), Integer.parseInt(settingManager.getValue("system/indexoptimizer/at/min")), Integer.parseInt(settingManager.getValue("system/indexoptimizer/at/sec")));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed parsing schedule at info from settings: " + e.getMessage());
        }
        return calendar;
    }

    public int getLuceneIndexOptimizerSchedulerInterval() throws IllegalArgumentException {
        int result = -1;
        try {
            SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
            int day = Integer.parseInt(settingManager.getValue("system/indexoptimizer/interval/day"));
            int hour = Integer.parseInt(settingManager.getValue("system/indexoptimizer/interval/hour"));
            int min = Integer.parseInt(settingManager.getValue("system/indexoptimizer/interval/min"));
            result = day * 24 * 60 + hour * 60 + min;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed parsing scheduler interval from settings: " + e.getMessage());
        }
        return result;
    }

    public String getFeedbackEmail() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        return settingManager.getValue("system/feedback/email");
    }

    public boolean getInspireEnabled() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        return settingManager.getValueAsBool("system/inspire/enable");
    }

    public char[] getAnalyzerIgnoreChars() {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String ignoreChars = settingManager.getValue(Settings.SYSTEM_LUCENE_IGNORECHARS);
        if (ignoreChars == null || ignoreChars.length() == 0) {
            return null;
        }
        return ignoreChars.toCharArray();
    }

    public static enum SearchRequestLanguage {
        OFF("off", null, null),
        PREFER_LOCALE("prefer_locale", "_locale", BooleanClause.Occur.SHOULD),
        ONLY_LOCALE("only_locale", "_locale", BooleanClause.Occur.MUST),
        PREFER_DOC_LOCALE("prefer_docLocale", "_docLocale", BooleanClause.Occur.SHOULD),
        ONLY_DOC_LOCALE("only_docLocale", "_docLocale", BooleanClause.Occur.MUST),
        PREFER_UI_LOCALE("prefer_ui_locale", "_locale", BooleanClause.Occur.SHOULD),
        ONLY_UI_LOCALE("only_ui_locale", "_locale", BooleanClause.Occur.MUST),
        PREFER_UI_DOC_LOCALE("prefer_ui_docLocale", "_docLocale", BooleanClause.Occur.SHOULD),
        ONLY_UI_DOC_LOCALE("only_ui_docLocale", "_docLocale", BooleanClause.Occur.MUST);

        public final String databaseValue;
        public final String fieldName;
        private final BooleanClause.Occur occur;

        private SearchRequestLanguage(String databaseValue, String fieldName, BooleanClause.Occur occur) {
            this.databaseValue = databaseValue;
            this.fieldName = fieldName;
            this.occur = occur;
        }

        public static SearchRequestLanguage find(String value) {
            for (SearchRequestLanguage enumValue : SearchRequestLanguage.values()) {
                if (!enumValue.databaseValue.equals(value)) continue;
                return enumValue;
            }
            return OFF;
        }

        public void addQuery(BooleanQuery query, String langCode) {
            if (this.fieldName != null) {
                query.add((Query)new TermQuery(new Term(this.fieldName, langCode)), this.occur);
            }
        }
    }
}

