/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.store.Directory;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.search.index.DirectoryFactory;
import org.fao.geonet.utils.Log;

class TaxonomyIndexTracker {
    private final DirectoryFactory taxonomyDir;
    private final LuceneConfig luceneConfig;
    private DirectoryTaxonomyWriter taxonomyWriter;
    private TaxonomyReader taxonomyReader;
    private LinkedList<TaxonomyReader> expiredReaders = new LinkedList();
    private Directory cachedFSDir;

    public TaxonomyIndexTracker(DirectoryFactory taxonomyDir, LuceneConfig luceneConfig) throws Exception {
        this.taxonomyDir = taxonomyDir;
        this.luceneConfig = luceneConfig;
        this.init();
    }

    private void init() throws Exception {
        try {
            this.cachedFSDir = this.taxonomyDir.createTaxonomyDirectory(this.luceneConfig);
            this.taxonomyWriter = new DirectoryTaxonomyWriter(this.cachedFSDir);
            this.taxonomyWriter.commit();
            this.taxonomyReader = null;
            try {
                TaxonomyReader reader = this.acquire();
                this.quietDecRef(reader);
            }
            finally {
                IOUtils.closeQuietly((Closeable)this.taxonomyReader);
                this.taxonomyReader = null;
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.index", (Object)"An error occurred while openning taxonomy readers/writers", (Throwable)e);
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            this.close(errors);
            if (!errors.isEmpty()) {
                for (Throwable throwable : errors) {
                    Log.error((String)"geonetwork.lucene", (Object)"Failure while closing luceneIndexLanguageTracker", (Throwable)throwable);
                }
            }
            throw e;
        }
    }

    TaxonomyReader acquire() throws IOException {
        if (this.taxonomyReader == null) {
            this.taxonomyReader = new DirectoryTaxonomyReader(this.taxonomyWriter);
        }
        Iterator iterator = this.expiredReaders.iterator();
        while (iterator.hasNext()) {
            TaxonomyReader reader = (TaxonomyReader)iterator.next();
            if (reader.getRefCount() >= 1) continue;
            IOUtils.closeQuietly((Closeable)reader);
            iterator.remove();
        }
        this.taxonomyReader.incRef();
        return this.taxonomyReader;
    }

    Document addDocument(Document doc, Collection<CategoryPath> categories) {
        Document docAfterFacetBuild = null;
        try {
            docAfterFacetBuild = this.luceneConfig.getTaxonomyConfiguration().build((TaxonomyWriter)this.taxonomyWriter, doc);
            if (Log.isDebugEnabled((String)"geonetwork.index")) {
                Log.debug((String)"geonetwork.index", (Object)("Taxonomy writer: " + this.taxonomyWriter.toString()));
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.index", (Object)("Taxonomy writer: " + this.taxonomyWriter.toString() + " error: " + e.getMessage()), (Throwable)e);
        }
        return docAfterFacetBuild;
    }

    void close(List<Throwable> errors) throws IOException {
        try {
            if (this.taxonomyReader != null) {
                this.taxonomyReader.close();
                this.taxonomyReader = null;
            }
        }
        catch (Throwable e) {
            errors.add(e);
        }
        for (TaxonomyReader reader : this.expiredReaders) {
            IOUtils.closeQuietly((Closeable)reader);
        }
        this.expiredReaders.clear();
        try {
            if (this.taxonomyWriter != null) {
                this.taxonomyWriter.close();
                this.taxonomyWriter = null;
            }
        }
        catch (Throwable e) {
            errors.add(e);
        }
        try {
            if (this.cachedFSDir != null) {
                this.cachedFSDir.close();
                this.cachedFSDir = null;
            }
        }
        catch (Throwable e) {
            errors.add(e);
        }
    }

    void reset() throws Exception {
        ArrayList<Throwable> errors = new ArrayList<Throwable>(5);
        this.close(errors);
        this.taxonomyDir.resetTaxonomy();
        this.init();
        if (!errors.isEmpty()) {
            for (Throwable throwable : errors) {
                Log.error((String)"geonetwork.lucene", (Object)"Failure while closing luceneIndexLanguageTracker", (Throwable)throwable);
            }
        }
    }

    void commit() {
        try {
            try {
                this.taxonomyWriter.commit();
            }
            catch (Throwable e) {
                Log.error((String)"geonetwork.lucene", (Object)("Error committing taxonomy: " + this.taxonomyWriter), (Throwable)e);
            }
        }
        catch (OutOfMemoryError e) {
            try {
                Log.error((String)"geonetwork.lucene", (Object)("OOM Error committing taxonomy: " + this.taxonomyWriter), (Throwable)e);
                this.reset();
            }
            catch (Exception e1) {
                Log.error((String)"geonetwork.lucene", (Object)"Error resetting lucene indices", (Throwable)e);
            }
            throw new RuntimeException(e);
        }
    }

    TaxonomyWriter writer() {
        return this.taxonomyWriter;
    }

    private void quietDecRef(TaxonomyReader tr) {
        try {
            tr.decRef();
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.lucene", (Object)"Error removing ref to TaxonomyReader", (Throwable)e);
        }
    }

    public void maybeRefresh() throws IOException {
        TaxonomyReader newReader;
        if (this.taxonomyReader != null && (newReader = TaxonomyReader.openIfChanged((TaxonomyReader)this.taxonomyReader)) != null) {
            this.quietDecRef(this.taxonomyReader);
            if (this.taxonomyReader.getRefCount() != 0) {
                this.expiredReaders.add(this.taxonomyReader);
            }
            this.taxonomyReader = newReader;
        }
    }
}

