/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.index;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.fao.geonet.kernel.search.index.GeonetworkNRTManager;

public class SearcherVersionTracker {
    private final AtomicLong version = new AtomicLong(0L);
    private final Map<Long, Map<String, Long>> mapping = new HashMap<Long, Map<String, Long>>();

    public long get(String lang, long version) {
        Map<String, Long> versions = this.mapping.get(version);
        if (versions == null) {
            return -1L;
        }
        Long actualVersion = versions.get(lang);
        if (actualVersion == null) {
            return -1L;
        }
        return actualVersion;
    }

    public long lastVersion() {
        return this.version.get();
    }

    public long register(Map<GeonetworkNRTManager.AcquireResult, GeonetworkNRTManager> searchers) {
        long finalVersion = this.version.incrementAndGet();
        Map<String, Long> versions = this.mapping.get(finalVersion);
        if (versions == null) {
            versions = new HashMap<String, Long>();
            this.mapping.put(finalVersion, versions);
        }
        for (Map.Entry<GeonetworkNRTManager.AcquireResult, GeonetworkNRTManager> entry : searchers.entrySet()) {
            versions.put(entry.getValue().getLanguage(), entry.getKey().version);
        }
        return finalVersion;
    }

    public Long last(String language) {
        return this.get(language, this.lastVersion());
    }

    public void prune(String language, Predicate<Long> predicate) {
        Iterator<Map.Entry<Long, Map<String, Long>>> iter = this.mapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Map<String, Long>> entry = iter.next();
            Long version = entry.getValue().get(language);
            if (version != null && predicate.apply((Object)version)) continue;
            iter.remove();
        }
    }

    public int size() {
        return this.mapping.size();
    }
}

