/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PreDestroy;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TrackingIndexWriter;
import org.apache.lucene.store.Directory;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.kernel.search.IndexAndTaxonomy;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.index.DirectoryFactory;
import org.fao.geonet.kernel.search.index.Function;
import org.fao.geonet.kernel.search.index.GeonetworkMultiReader;
import org.fao.geonet.kernel.search.index.GeonetworkNRTManager;
import org.fao.geonet.kernel.search.index.IndexInformation;
import org.fao.geonet.kernel.search.index.SearcherVersionTracker;
import org.fao.geonet.kernel.search.index.TaxonomyIndexTracker;
import org.fao.geonet.utils.Log;
import org.springframework.context.ConfigurableApplicationContext;

public class LuceneIndexLanguageTracker {
    private final Map<String, Directory> dirs = new HashMap<String, Directory>();
    private final Map<String, TrackingIndexWriter> trackingWriters = new HashMap<String, TrackingIndexWriter>();
    private final Map<String, GeonetworkNRTManager> searchManagers = new HashMap<String, GeonetworkNRTManager>();
    private final SearcherVersionTracker versionTracker = new SearcherVersionTracker();
    private TaxonomyIndexTracker taxonomyIndexTracker;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private Lock lock = new ReentrantLock();
    private AtomicInteger _openReaderCounter = new AtomicInteger(0);
    private AtomicBoolean destroyed = new AtomicBoolean(false);

    private static String normalize(String locale) {
        if (locale == null) {
            locale = "none";
        }
        switch (locale = locale.toLowerCase()) {
            case "deu": {
                locale = "ger";
                break;
            }
            case "fra": {
                locale = "fre";
                break;
            }
        }
        return locale;
    }

    private void lazyInit() {
        ConfigurableApplicationContext context = ApplicationContextHolder.get();
        LuceneConfig luceneConfig = (LuceneConfig)context.getBean(LuceneConfig.class);
        DirectoryFactory directoryFactory = (DirectoryFactory)context.getBean(DirectoryFactory.class);
        ScheduledThreadPoolExecutor timer = (ScheduledThreadPoolExecutor)context.getBean("timerThreadPool", ScheduledThreadPoolExecutor.class);
        if (!this.initialized.get()) {
            this.lock.lock();
            try {
                this.taxonomyIndexTracker = new TaxonomyIndexTracker(directoryFactory, luceneConfig);
                this.init();
                if (timer != null) {
                    timer.scheduleAtFixedRate(new CommitTimerTask(), 30L, 30L, TimeUnit.SECONDS);
                    timer.scheduleAtFixedRate(new PurgeExpiredSearchersTask(), 30L, 30L, TimeUnit.SECONDS);
                }
                this.initialized.set(true);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void init() throws Exception {
        ConfigurableApplicationContext context = ApplicationContextHolder.get();
        DirectoryFactory directoryFactory = (DirectoryFactory)context.getBean(DirectoryFactory.class);
        try {
            Set<String> indices = directoryFactory.listIndices();
            for (String indexDir : indices) {
                this.openIndex(indexDir);
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.index", (Object)"An error occurred while opening lucene index readers/writers", (Throwable)e);
            this.close(60000L, true);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openIndex(String indexId) throws IOException {
        TrackingIndexWriter trackingIndexWriter;
        GeonetworkNRTManager nrtManager;
        Directory cachedFSDir;
        block3: {
            ConfigurableApplicationContext context = ApplicationContextHolder.get();
            LuceneConfig luceneConfig = (LuceneConfig)context.getBean(LuceneConfig.class);
            DirectoryFactory directoryFactory = (DirectoryFactory)context.getBean(DirectoryFactory.class);
            cachedFSDir = directoryFactory.createIndexDirectory(indexId, luceneConfig);
            IndexWriter writer = null;
            nrtManager = null;
            boolean done = false;
            try {
                IndexWriterConfig conf = new IndexWriterConfig(Geonet.LUCENE_VERSION, (Analyzer)SearchManager.getAnalyzer(indexId, false));
                ConcurrentMergeScheduler mergeScheduler = new ConcurrentMergeScheduler();
                conf.setMergeScheduler((MergeScheduler)mergeScheduler);
                writer = new IndexWriter(cachedFSDir, conf);
                trackingIndexWriter = new TrackingIndexWriter(writer);
                nrtManager = new GeonetworkNRTManager(luceneConfig, indexId, trackingIndexWriter, writer, null, true, this.taxonomyIndexTracker);
                done = true;
                if (done) break block3;
            }
            catch (Throwable throwable) {
                if (!done) {
                    IOUtils.closeQuietly(nrtManager);
                    IOUtils.closeQuietly(writer);
                    IOUtils.closeQuietly((Closeable)cachedFSDir);
                }
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)nrtManager);
            IOUtils.closeQuietly((Closeable)writer);
            IOUtils.closeQuietly((Closeable)cachedFSDir);
        }
        this.dirs.put(indexId, cachedFSDir);
        this.trackingWriters.put(indexId, trackingIndexWriter);
        this.searchManagers.put(indexId, nrtManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexAndTaxonomy acquire(String preferredLang, long versionToken) throws IOException {
        this.lock.lock();
        try {
            this.lazyInit();
            ConfigurableApplicationContext context = ApplicationContextHolder.get();
            LuceneConfig luceneConfig = (LuceneConfig)context.getBean(LuceneConfig.class);
            if (!luceneConfig.useNRTManagerReopenThread() || Boolean.parseBoolean(System.getProperty("useNRTManagerReopenThread"))) {
                this.maybeRefreshBlocking();
            }
            long finalVersion = versionToken;
            HashMap<GeonetworkNRTManager.AcquireResult, GeonetworkNRTManager> searchers = new HashMap<GeonetworkNRTManager.AcquireResult, GeonetworkNRTManager>((int)((double)this.searchManagers.size() * 1.5));
            IndexReader[] readers = new IndexReader[this.searchManagers.size()];
            int i = 1;
            boolean tokenExpired = false;
            boolean lastVersionUpToDate = true;
            for (GeonetworkNRTManager manager : this.searchManagers.values()) {
                GeonetworkNRTManager.AcquireResult result = manager.acquire(versionToken, this.versionTracker);
                lastVersionUpToDate = lastVersionUpToDate && result.lastVersionUpToDate;
                boolean bl = tokenExpired = tokenExpired || result.newSearcher;
                if (preferredLang != null && preferredLang.equalsIgnoreCase(manager.language) || i >= readers.length) {
                    readers[0] = result.searcher.getIndexReader();
                } else {
                    readers[i] = result.searcher.getIndexReader();
                    ++i;
                }
                searchers.put(result, manager);
            }
            if (tokenExpired) {
                if (lastVersionUpToDate) {
                    finalVersion = this.versionTracker.lastVersion();
                } else {
                    this.taxonomyIndexTracker.maybeRefresh();
                    finalVersion = this.versionTracker.register(searchers);
                }
            }
            IndexAndTaxonomy indexAndTaxonomy = new IndexAndTaxonomy(finalVersion, new GeonetworkMultiReader(this._openReaderCounter, readers, searchers), this.taxonomyIndexTracker.acquire());
            return indexAndTaxonomy;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void maybeRefreshBlocking() throws IOException {
        this.lock.lock();
        try {
            this.lazyInit();
            this.commit();
            for (GeonetworkNRTManager manager : this.searchManagers.values()) {
                manager.maybeRefreshBlocking();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void commit() throws IOException {
        this.lock.lock();
        try {
            this.lazyInit();
            this.taxonomyIndexTracker.commit();
            for (TrackingIndexWriter writer : this.trackingWriters.values()) {
                writer.getIndexWriter().commit();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void withWriter(Function function) throws IOException {
        this.lock.lock();
        try {
            this.lazyInit();
            for (TrackingIndexWriter writer : this.trackingWriters.values()) {
                function.apply(this.taxonomyIndexTracker.writer(), writer);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(IndexInformation info) throws IOException {
        this.lock.lock();
        try {
            this.lazyInit();
            String language = LuceneIndexLanguageTracker.normalize(info.language);
            if (Log.isDebugEnabled((String)"geonetwork.index")) {
                Log.debug((String)"geonetwork.index", (Object)("Adding document to " + language + " index"));
            }
            this.open(language);
            Document docAfterFacetBuild = info.document;
            docAfterFacetBuild = this.taxonomyIndexTracker.addDocument(info.document, info.taxonomy);
            if (docAfterFacetBuild == null) {
                this.removeFacetFields(info.document);
                this.trackingWriters.get(language).addDocument((Iterable)info.document);
            } else {
                this.trackingWriters.get(language).addDocument((Iterable)docAfterFacetBuild);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    Document removeFacetFields(Document doc) {
        List listOfFields = doc.getFields();
        Iterator iterator = listOfFields.iterator();
        while (iterator.hasNext()) {
            IndexableField field = (IndexableField)iterator.next();
            if (!(field instanceof FacetField)) continue;
            iterator.remove();
        }
        return doc;
    }

    public void open(String language) throws IOException {
        this.lock.lock();
        try {
            this.lazyInit();
            language = LuceneIndexLanguageTracker.normalize(language);
            if (!this.trackingWriters.containsKey(language)) {
                this.openIndex(language);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(long timeoutInMillis) throws Exception {
        this.lock.lock();
        try {
            this.lazyInit();
            ConfigurableApplicationContext context = ApplicationContextHolder.get();
            DirectoryFactory directoryFactory = (DirectoryFactory)context.getBean(DirectoryFactory.class);
            this.waitForReadersToClose(timeoutInMillis);
            this.taxonomyIndexTracker.reset();
            this.close(0L, false);
            directoryFactory.resetIndex();
            this.init();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitForReadersToClose(long timeoutInMillis) throws TimeoutException {
        long startWait = System.currentTimeMillis();
        while (this._openReaderCounter.get() > 0) {
            if (startWait + timeoutInMillis < System.currentTimeMillis()) {
                throw new TimeoutException("Waited for longer than " + timeoutInMillis + " and readers remain open");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @PreDestroy
    public synchronized void destroy() throws IOException {
        if (this.destroyed.get()) {
            return;
        }
        Log.warning((String)"geonetwork.lucene.tracking", (Object)"LuceneIndexLanguageTracker:destroy() called, closing indexes ...");
        try {
            this.close(TimeUnit.MINUTES.toMillis(1L), true, false);
            Log.warning((String)"geonetwork.lucene.tracking", (Object)"LuceneIndexLanguageTracker:destroy() Done.");
            this.destroyed.set(true);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.lucene.tracking", (Object)"error occured while closing the indexes", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long timeoutInMillis, boolean closeTaxonomy, boolean lazyInitRequired) throws IOException {
        this.lock.lock();
        try {
            if (lazyInitRequired) {
                this.lazyInit();
            }
            ArrayList<Throwable> errors = new ArrayList<Throwable>(5);
            try {
                this.waitForReadersToClose(timeoutInMillis);
            }
            catch (TimeoutException e) {
                Log.warning((String)"geonetwork.lucene.tracking", (Object)("not all Lucene readers closed after waiting " + timeoutInMillis + " ms.  Going ahead and closing indices"));
            }
            if (closeTaxonomy && this.taxonomyIndexTracker != null) {
                this.taxonomyIndexTracker.close(errors);
            }
            for (GeonetworkNRTManager manager : this.searchManagers.values()) {
                try {
                    manager.close();
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
            for (TrackingIndexWriter writer : this.trackingWriters.values()) {
                try {
                    writer.getIndexWriter().close(true);
                }
                catch (OutOfMemoryError e) {
                    writer.getIndexWriter().close(true);
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
            for (Directory dir : this.dirs.values()) {
                try {
                    dir.close();
                }
                catch (Throwable e) {
                    errors.add(e);
                }
            }
            this.dirs.clear();
            this.trackingWriters.clear();
            this.searchManagers.clear();
            if (!errors.isEmpty()) {
                for (Throwable throwable : errors) {
                    Log.error((String)"geonetwork.lucene", (Object)"Failure while closing luceneIndexLanguageTracker", (Throwable)throwable);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close(long timeoutInMillis, boolean closeTaxonomy) throws IOException {
        this.close(timeoutInMillis, closeTaxonomy, true);
    }

    /*
     * Exception decompiling
     */
    public void optimize() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteDocuments(final Term term) throws IOException {
        this.lock.lock();
        try {
            this.lazyInit();
            if (Log.isDebugEnabled((String)"geonetwork.index")) {
                Log.debug((String)"geonetwork.index", (Object)("deleting term '" + term + "' from index"));
            }
            this.withWriter(new Function(){

                @Override
                public void apply(TaxonomyWriter taxonomyWriter, TrackingIndexWriter input) throws IOException {
                    input.deleteDocuments(term);
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    private class PurgeExpiredSearchersTask
    implements Runnable {
        private PurgeExpiredSearchersTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LuceneIndexLanguageTracker.this.lock.lock();
            try {
                Collection values = LuceneIndexLanguageTracker.this.searchManagers.values();
                for (GeonetworkNRTManager geonetworkNRTManager : values) {
                    geonetworkNRTManager.purgeExpiredSearchers(LuceneIndexLanguageTracker.this.versionTracker);
                }
            }
            finally {
                LuceneIndexLanguageTracker.this.lock.unlock();
            }
            Log.info((String)"geonetwork.lucene", (Object)("Done running PurgeExpiredSearchersTask. " + LuceneIndexLanguageTracker.this.versionTracker.size() + " versions still cached."));
        }
    }

    private class CommitTimerTask
    implements Runnable {
        private CommitTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            LuceneIndexLanguageTracker.this.lock.lock();
            try {
                Log.debug((String)"geonetwork.lucene", (Object)"Running Lucene committer timer");
                for (TrackingIndexWriter writer : LuceneIndexLanguageTracker.this.trackingWriters.values()) {
                    try {
                        try {
                            writer.getIndexWriter().commit();
                        }
                        catch (Throwable e) {
                            Log.error((String)"geonetwork.lucene", (Object)("Error committing writer: " + writer), (Throwable)e);
                        }
                    }
                    catch (OutOfMemoryError e) {
                        try {
                            Log.error((String)"geonetwork.lucene", (Object)("OOM Error committing writer: " + writer), (Throwable)e);
                            LuceneIndexLanguageTracker.this.reset(TimeUnit.MINUTES.toMillis(1L));
                            throw new RuntimeException(e);
                        }
                        catch (Exception e1) {
                            Log.error((String)"geonetwork.lucene", (Object)"Error resetting lucene indices", (Throwable)e);
                        }
                        throw new RuntimeException(e);
                        return;
                    }
                }
            }
            finally {
                LuceneIndexLanguageTracker.this.lock.unlock();
            }
        }
    }
}

