/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.facet;

import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.search.classifier.Classifier;
import org.fao.geonet.kernel.search.classifier.Value;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class Dimension {
    public static final String FACET_FIELD_SUFFIX = "_facet";
    private static final String TEMPLATE = "  * %s: {indexKey=%s, label=%s, classifier=%s, localized=%b}%n";
    private String name;
    private String indexKey;
    private String label;
    private boolean localized;
    private Classifier classifier;
    private ConfigurableApplicationContext context;

    public Dimension(String name, String indexKey, String label) {
        this.name = name;
        this.indexKey = indexKey;
        this.label = label;
        this.localized = false;
        this.classifier = new Value();
    }

    public String getName() {
        return this.name;
    }

    public String getIndexKey() {
        return this.indexKey;
    }

    public String getLabel() {
        return this.label;
    }

    public Classifier getClassifier() {
        return this.classifier;
    }

    public void setClassifier(Classifier classifier) {
        this.classifier = classifier;
    }

    public String toString() {
        return String.format(TEMPLATE, this.name, this.indexKey, this.label, this.classifier.getClass().getName(), this.localized);
    }

    public String getFacetFieldName(String langCode) {
        return this.getName(langCode) + FACET_FIELD_SUFFIX;
    }

    public boolean isLocalized() {
        return this.localized;
    }

    public void setLocalized(Boolean localized) {
        this.localized = localized;
    }

    public String getName(String langCode) {
        if (this.localized && this.getLocales().contains(langCode)) {
            return this.name + "_" + langCode.toLowerCase();
        }
        return this.name;
    }

    public Set<String> getLocales() {
        try {
            ConfigurableApplicationContext context = ApplicationContextHolder.get();
            if (context != null) {
                return (Set)context.getBean("languages", Set.class);
            }
            return (Set)this.context.getBean("languages", Set.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            return (Set)this.context.getBean("languages", Set.class);
        }
    }

    @VisibleForTesting
    void setApplicationContext(GenericApplicationContext applicationContext) {
        this.context = applicationContext;
    }
}

