/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.kernel.search.UserQueryInput;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.jdom.Element;

public class LuceneQueryInput
extends UserQueryInput {
    private String owner;
    private Set<String> groups;
    private Set<String> editableGroups;
    private Set<String> groupOwners;
    private boolean isReviewer;
    private boolean isUserAdmin;
    private boolean isAdmin;
    private SettingInfo.SearchRequestLanguage requestedLanguageOnly;

    public LuceneQueryInput(Element jdom) {
        super(jdom);
        this.setOwner(jdom.getChildText("owner"));
        List groupsE = jdom.getChildren("group");
        if (groupsE != null) {
            LinkedHashSet<String> groups = new LinkedHashSet<String>();
            for (Element groupE : groupsE) {
                groups.add(groupE.getText());
            }
            this.setGroups(groups);
        }
        List groupsEd = jdom.getChildren("groupEdit");
        HashSet<String> groups = new HashSet<String>();
        if (groupsEd != null) {
            for (Element groupEd : groupsEd) {
                groups.add(groupEd.getText());
            }
        }
        this.setEditableGroups(groups);
        List groupOwnersE = jdom.getChildren("groupOwner");
        LinkedHashSet<String> groupOwners = new LinkedHashSet<String>();
        for (Element groupOwnerE : groupOwnersE) {
            groupOwners.add(groupOwnerE.getText());
        }
        this.setGroupOwners(groupOwners);
        Element isReviewerE = jdom.getChild("isReviewer");
        this.setReviewer(isReviewerE != null);
        Element isUserAdminE = jdom.getChild("isUserAdmin");
        this.setUserAdmin(isUserAdminE != null);
        Element isAdminE = jdom.getChild("isAdmin");
        this.setAdmin(isAdminE != null);
        Element isEditable = jdom.getChild("editable");
        if (isEditable != null && StringUtils.isNotEmpty((String)isEditable.getText())) {
            this.setEditable(isEditable.getText());
        } else {
            this.setEditable("false");
        }
    }

    public SettingInfo.SearchRequestLanguage isRequestedLanguageOnly() {
        return this.requestedLanguageOnly;
    }

    public void setRequestedLanguageOnly(SettingInfo.SearchRequestLanguage requestedLanguageOnly) {
        this.requestedLanguageOnly = requestedLanguageOnly;
    }

    @Override
    public String toString() {
        StringBuffer groupsToString = new StringBuffer();
        for (String group : this.groups) {
            groupsToString.append(" group: " + group);
        }
        StringBuffer groupOwnersToString = new StringBuffer();
        for (String groupOwner : this.groupOwners) {
            groupOwnersToString.append(" groupOwner: " + groupOwner);
        }
        return "owner:" + this.owner + groupsToString + groupOwnersToString + " isReviewer:" + this.isReviewer + " isUserAdmin:" + this.isUserAdmin + " isAdmin:" + this.isAdmin + " " + super.toString();
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        if (this.groups == null) {
            this.groups = new LinkedHashSet<String>();
        }
        this.groups = groups;
    }

    public Set<String> getEditableGroups() {
        if (this.editableGroups == null) {
            this.editableGroups = new HashSet<String>();
        }
        return this.editableGroups;
    }

    public void setEditableGroups(Set<String> editableGroups) {
        this.editableGroups = editableGroups;
    }

    public boolean getReviewer() {
        return this.isReviewer;
    }

    public void setReviewer(boolean reviewer) {
        this.isReviewer = reviewer;
    }

    public boolean getUserAdmin() {
        return this.isUserAdmin;
    }

    public void setUserAdmin(boolean userAdmin) {
        this.isUserAdmin = userAdmin;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean getAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean admin) {
        this.isAdmin = admin;
    }

    public Set<String> getGroupOwners() {
        return this.groupOwners;
    }

    public void setGroupOwners(Set<String> groupOwners) {
        if (this.groupOwners == null) {
            this.groupOwners = new LinkedHashSet<String>();
        }
        this.groupOwners = groupOwners;
    }
}

