/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.kernel.search.CharToSpaceReader;
import org.fao.geonet.utils.Log;

public final class GeoNetworkAnalyzer
extends Analyzer {
    private final char[] charsToIgnore;
    private final CharArraySet stopwords;

    public GeoNetworkAnalyzer() {
        this(null, null);
    }

    public GeoNetworkAnalyzer(Set<String> stopwords, char[] charsToIgnore) {
        this.stopwords = stopwords == null || stopwords.isEmpty() ? CharArraySet.EMPTY_SET : new CharArraySet(Geonet.LUCENE_VERSION, stopwords, true);
        if (charsToIgnore == null) {
            this.charsToIgnore = new char[0];
        } else {
            this.charsToIgnore = new char[charsToIgnore.length];
            System.arraycopy(charsToIgnore, 0, this.charsToIgnore, 0, charsToIgnore.length);
            for (char s : charsToIgnore) {
                Log.debug((String)((Object)((Object)this)).getClass().getName(), (Object)("character to ignore: " + s));
            }
        }
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer source = new StandardTokenizer(Geonet.LUCENE_VERSION, reader);
        ASCIIFoldingFilter asciiFoldingFilter = new ASCIIFoldingFilter((TokenStream)new LowerCaseFilter(Geonet.LUCENE_VERSION, (TokenStream)new StandardFilter(Geonet.LUCENE_VERSION, (TokenStream)source)));
        if (this.stopwords != null && !this.stopwords.isEmpty()) {
            return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new StopFilter(Geonet.LUCENE_VERSION, (TokenStream)asciiFoldingFilter, this.stopwords)){

                protected void setReader(Reader reader) throws IOException {
                    super.setReader(GeoNetworkAnalyzer.this.wrapReader(reader));
                }
            };
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)asciiFoldingFilter){

            protected void setReader(Reader reader) throws IOException {
                super.setReader(GeoNetworkAnalyzer.this.wrapReader(reader));
            }
        };
    }

    private Reader wrapReader(Reader reader) {
        if (this.charsToIgnore != null && this.charsToIgnore.length > 0) {
            return new CharToSpaceReader(reader, this.charsToIgnore);
        }
        return reader;
    }
}

