/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.search.MetadataRecordSelector;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SearcherType;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;

public class SelectionManager {
    public static final String SELECTION_METADATA = "metadata";
    public static final String SELECTION_BUCKET = "bucket";
    public static final int DEFAULT_MAXHITS = 1000;
    public static final String ADD_ALL_SELECTED = "add-all";
    public static final String REMOVE_ALL_SELECTED = "remove-all";
    public static final String ADD_SELECTED = "add";
    public static final String REMOVE_SELECTED = "remove";
    public static final String CLEAR_ADD_SELECTED = "clear-add";
    private Hashtable<String, Set<String>> selections = new Hashtable(0);

    private SelectionManager() {
        Set MDSelection = Collections.synchronizedSet(new HashSet(0));
        this.selections.put(SELECTION_METADATA, MDSelection);
    }

    public static void updateMDResult(UserSession session, Element result) {
        SelectionManager.updateMDResult(session, result, SELECTION_METADATA);
    }

    public static void updateMDResult(UserSession session, Element result, String bucket) {
        SelectionManager manager = SelectionManager.getManager(session);
        List elList = result.getChildren();
        Set<String> selection = manager.getSelection(bucket);
        for (Element element : elList) {
            if (element.getName().equals("summary")) continue;
            Element info = element.getChild("info", Edit.NAMESPACE);
            String uuid = info.getChildText("uuid");
            if (selection.contains(uuid)) {
                info.addContent((Content)new Element("selected").setText("true"));
                continue;
            }
            info.addContent((Content)new Element("selected").setText("false"));
        }
        result.setAttribute("selected", selection == null ? "0" : Integer.toString(selection.size()));
    }

    public static int updateSelection(String type, UserSession session, Element params, ServiceContext context) {
        List listOfIdentifiersElement = params.getChildren("id");
        ArrayList<String> listOfIdentifiers = new ArrayList<String>(listOfIdentifiersElement.size());
        for (Element e : listOfIdentifiersElement) {
            listOfIdentifiers.add(e.getText());
        }
        String selected = params.getChildText("selected");
        SelectionManager manager = SelectionManager.getManager(session);
        return manager.updateSelection(type, context, selected, listOfIdentifiers, session);
    }

    public static int updateSelection(String type, UserSession session, String actionOnSelection, List<String> listOfIdentifiers, ServiceContext context) {
        SelectionManager manager = SelectionManager.getManager(session);
        return manager.updateSelection(type, context, actionOnSelection, listOfIdentifiers, session);
    }

    @Nonnull
    public static SelectionManager getManager(UserSession session) {
        SelectionManager manager = (SelectionManager)session.getProperty("selected.result");
        if (manager == null) {
            manager = new SelectionManager();
            session.setProperty("selected.result", manager);
        }
        return manager;
    }

    public int updateSelection(String type, ServiceContext context, String selected, List<String> listOfIdentifiers, UserSession session) {
        Set<String> selection = this.getSelection(type);
        if (selection == null) {
            selection = Collections.synchronizedSet(new HashSet());
            this.selections.put(type, selection);
        }
        if (selected != null) {
            if (selected.equals(ADD_ALL_SELECTED)) {
                this.selectAll(type, context, session);
            } else if (selected.equals(REMOVE_ALL_SELECTED)) {
                this.close(type);
            } else if (selected.equals(ADD_SELECTED) && listOfIdentifiers.size() > 0) {
                for (String paramid : listOfIdentifiers) {
                    selection.add(paramid);
                }
            } else if (selected.equals(REMOVE_SELECTED) && listOfIdentifiers.size() > 0) {
                for (String paramid : listOfIdentifiers) {
                    selection.remove(paramid);
                }
            } else if (selected.equals(CLEAR_ADD_SELECTED) && listOfIdentifiers.size() > 0) {
                this.close(type);
                for (String paramid : listOfIdentifiers) {
                    selection.add(paramid);
                }
            }
        }
        Iterator<String> iter = selection.iterator();
        while (iter.hasNext()) {
            String element = iter.next();
            if (element != null) continue;
            iter.remove();
        }
        return selection.size();
    }

    public void selectAll(String type, ServiceContext context, UserSession session) {
        Set<String> selection = this.selections.get(type);
        SettingInfo si = context.getBean(SettingInfo.class);
        int maxhits = 1000;
        try {
            maxhits = Integer.parseInt(si.getSelectionMaxRecords());
        }
        catch (Exception e) {
            Log.error((String)"geonetwork", (Object)("Select all - invalid max hits value, error: " + e.getMessage()), (Throwable)e);
        }
        if (selection != null) {
            selection.clear();
        }
        if (StringUtils.isNotEmpty((String)type)) {
            Element request = (Element)session.getProperty("search.request" + type);
            Object searcher = null;
            if (request != null) {
                request = (Element)request.clone();
                request.addContent((Content)new Element("buildSummary").setText("false"));
                GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
                SearchManager searchMan = gc.getBean(SearchManager.class);
                try {
                    searcher = searchMan.newSearcher(SearcherType.LUCENE, "lucene.xsl");
                    ServiceConfig sc = new ServiceConfig();
                    ((LuceneSearcher)searcher).search(context, request, sc);
                }
                catch (Exception e) {
                    Log.error((String)"geonetwork", (Object)("Select all error: " + e.getMessage()), (Throwable)e);
                }
            } else {
                searcher = session.getProperty("search.result" + type);
            }
            if (searcher == null) {
                return;
            }
            try {
                if (!(searcher instanceof MetadataRecordSelector)) {
                    return;
                }
                List<String> uuidList = ((MetadataRecordSelector)searcher).getAllUuids(maxhits, context);
                if (selection != null) {
                    selection.addAll(uuidList);
                }
            }
            catch (Exception e) {
                Log.error((String)"geonetwork", (Object)("Select all error: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void close(String type) {
        Set<String> selection = this.selections.get(type);
        if (selection != null) {
            selection.clear();
        }
    }

    public void close() {
        for (Set<String> selection : this.selections.values()) {
            selection.clear();
        }
    }

    public Set<String> getSelection(String type) {
        Set<String> sel = this.selections.get(type);
        if (sel == null) {
            Set MDSelection = Collections.synchronizedSet(new HashSet(0));
            this.selections.put(type, MDSelection);
        }
        return this.selections.get(type);
    }

    public boolean addSelection(String type, String uuid) {
        return this.selections.get(type).add(uuid);
    }

    public boolean addAllSelection(String type, Set<String> uuids) {
        return this.selections.get(type).addAll(uuids);
    }
}

